/**
 * Copyright (c) Tiny Technologies, Inc. All rights reserved.
 * Licensed under the LGPL or a commercial license.
 * For LGPL see License.txt in the project root for license information.
 * For commercial licenses see https://www.tiny.cloud/
 */

export const enum ListAction {
  ToggleUlList = 'ToggleUlList',
  ToggleOlList = 'ToggleOlList',
  ToggleDLList = 'ToggleDLList',
  IndentList = 'IndentList',
  OutdentList = 'OutdentList'
}

export const listToggleActionFromListName = (listName: 'UL' | 'OL' | 'DL'): ListAction => {
  switch (listName) {
    case 'UL': return ListAction.ToggleUlList;
    case 'OL': return ListAction.ToggleOlList;
    case 'DL': return ListAction.ToggleDLList;
  }
};
