use core;
use core:debug;

// Test usage of value types.
Int testValue() {
	DbgVal v = DbgVal();
	v.get;
}

Int testDefInit() {
	DbgVal v;
	v.get;
}

// Test assigning values.
Int testValAssign() {
	DbgVal v1;
	DbgVal v2 = DbgVal();
	v2 = v1;
	v1.set(5);
	v2.set(15);
	v1.get + v2.get;
}

// Test copy of values.
Int testValCopy() {
	DbgVal v1;
	DbgVal v2 = v1;
	v1.set(5);
	v2.set(15);
	v1.get + v2.get;
}

// Test direct creation of values.
Int testValCtor() {
	DbgVal v(7);
	v.get;
}

Int asVal(DbgVal v) {
	v.set(v.get + 2);
	v.get;
}

// Test values as function parameters.
Int testValParam() {
	DbgVal toPar(7);
	toPar.get + asVal(toPar);
}

DbgVal createVal(Int v) {
	DbgVal(v);
}

// Test values as return parameters.
Int testValReturn() {
	DbgVal v(createVal(22));
	v.get;
}

// Declare a value!
value Pt2 {
	Int x;
	Int y;

	Int cross(Pt2 o) {
		x*o.y - y*o.x;
	}
}

Int testCustomValue() {
	Pt2 a;
	a.x = 10;
	a.y = 20;
	Pt2 b;
	b.x = 20;
	b.y = 10;
	a.cross(b);
}

// What happens when we have refs in a value?
// Note that this class relies on Values being zeroed automatically in the constructor.
value RefVal {
	Dbg d;

	void init(Int z) {
		d = Dbg(z);
	}

	Int v() {
		d.get;
	}
}

Int testRefVal(Int z) {
	RefVal v;
	v.init(z);
	v.v;
}

Int testCopyRefVal(Int z) {
	RefVal o;
	o.init(z);
	RefVal c(o);
	c.v;
}

Int testAssignRefVal(Int z) {
	RefVal o;
	o.init(z);
	RefVal c;
	c = o;
	c.v;
}

// What happens when we have values in values?
value ValVal {
	DbgVal v;
}

Int testValVal(Int z) {
	ValVal v;
	v.v.set(z);
	v.v.get;
}

Int testCopyValVal(Int z) {
	ValVal o;
	o.v.set(z);
	ValVal c(o);
	c.v.get;
}

Int testAssignValVal(Int z) {
	ValVal o;
	o.v.set(z);
	ValVal c;
	c = o;
	c.v.get;
}

// Returning values from member functions?
// In C++, the this pointer comes before the return value pointer, make sure we do the right thing!
class DbgDerived extends Dbg {

	init(Int v) {
		init(v) {}
	}

	// This overrides the Dbg base function.
	DbgVal asDbgVal() {
		DbgVal(20);
	}

	DbgVal dbgVal() {
		DbgVal(15);
	}
}

Int testVirtualVal1() {
	Dbg base(10);
	base.asDbgVal.get;
}

Int testVirtualVal2() {
	Dbg v = DbgDerived(10);
	v.asDbgVal.get;
}

Int testVirtualVal3() {
	DbgDerived v = DbgDerived(10);
	v.dbgVal.get;
}

Dbg testVirtualVal4() {
	DbgDerived(10);
}

Int testActorVal() {
	DbgActor a(10);
	a.asDbgVal.get;
}
