% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-patterns.R
\name{fill_alpha}
\alias{fill_alpha}
\title{Modify fill transparency}
\usage{
fill_alpha(fill, alpha)
}
\arguments{
\item{fill}{A fill colour given as a \code{character} or \code{integer} vector, or as a
(list of) \verb{<GridPattern>} object(s).}

\item{alpha}{A transparency value between 0 (transparent) and 1 (opaque),
parallel to \code{fill}.}
}
\value{
A \code{character} vector of colours, or list of \verb{<GridPattern>} objects.
}
\description{
This works much like \link[scales:alpha]{alpha()} in that it modifies the
transparency of fill colours. It differs in that \code{fill_alpha()} also attempts
to set the transparency of \verb{<GridPattern>} objects.
}
\examples{
# Typical colour input
fill_alpha("red", 0.5)

if (utils::packageVersion("grid") > "4.2") {
  # Pattern input
  fill_alpha(list(grid::linearGradient()), 0.5)
}
}
\keyword{internal}
