% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBaseList.R
\name{readBaseList}
\alias{readBaseList}
\alias{loadBaseList}
\title{Read a base list from disk}
\usage{
readBaseList(path, metadata, simple_list.parallel = TRUE, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the list method for \code{\link{stageObject}}.}

\item{metadata}{Named list containing metadata for the object, see \code{\link{readObjectFile}} for details.}

\item{simple_list.parallel}{Whether to perform reading and parsing in parallel for greater speed.
Only relevant for lists stored in the JSON format.}

\item{...}{Further arguments to be passed to \code{\link{altReadObject}} for complex child objects.}
}
\value{
The list represented by \code{path}.
}
\description{
Read a \link{list} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\details{
The \pkg{uzuki2} specification (see \url{https://github.com/ArtifactDB/uzuki2}) allows length-1 vectors to be stored as-is or as a scalar.
If the file stores a length-1 vector as-is, \code{readBaseList} will read the list element as a length-1 vector with the \link{AsIs} class.
If the file stores a length-1 vector as a scalar, \code{readBaseList} will read the list element as a length-1 vector without this class.
This allows downstream users to distinguish between the storage modes in the rare cases that it is necessary.
}
\examples{
library(S4Vectors)
ll <- list(A=1, B=LETTERS, C=DataFrame(X=letters))

tmp <- tempfile()
saveObject(ll, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{stageObject,list-method}"}, for the staging method.
}
\author{
Aaron Lun
}
