% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveObject.R
\name{moveObject}
\alias{moveObject}
\title{Move a non-child object in the staging directory}
\usage{
moveObject(dir, from, to, rename.redirections = TRUE)
}
\arguments{
\item{dir}{String containing the path to the staging directory.}

\item{from}{String containing the path to a non-child object inside \code{dir}, as used in \code{\link{acquireMetadata}}.
This can also be a redirection to such an object.}

\item{to}{String containing the new path inside \code{dir}.}

\item{rename.redirections}{Logical scalar specifying whether redirections pointing to \code{from} should be renamed as \code{to}.}
}
\value{
The object represented by \code{path} is moved, along with any redirections to it.
A \code{NULL} is invisibly returned.
}
\description{
\emph{WARNING: this function is deprecated, as directories of non-child objects can just be moved with regular methods (e.g., \code{\link{file.rename}}) in the latest version of \pkg{alabaster}.}
Pretty much as it says in the title.
This only works with non-child objects as children are referenced by their parents and cannot be safely moved in this manner.
}
\details{
This function will look around \code{path} for JSON files containing redirections to \code{from}, and update them to point to \code{to}.
More specifically, if \code{path} is a subdirectory, it will search in the same directory containing \code{path};
otherwise, it will search in the directory containing \code{dirname(path)}.
Redirections in other locations will not be removed automatically - these will be caught by \code{\link{checkValidDirectory}} and should be manually updated.

If \code{rename.redirections=TRUE}, this function will additionally move the redirection files so that they are named as \code{to}.
In the unusual case where \code{from} is the target of multiple redirection files, the renaming process will clobber all of them such that only one of them will be present after the move.
}
\section{Safety of moving operations}{

In general, \pkg{alabaster.*} representations are safe to move as only the parent object's \code{resource.path} metadata properties will contain links to the children's paths.
These links are updated with the new \code{to} path after running \code{moveObject} on the parent \code{from}.

However, alabaster applications may define custom data structures where the paths are present elsewhere, e.g., in the data file itself or in other metadata properties.
If so, applications are reponsible for updating those paths to reflect the naming to \code{to}.
}

\examples{
tmp <- tempfile()
dir.create(tmp)

library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])
meta <- stageObject(df, tmp, path="whee")
writeMetadata(meta, tmp)

ll <- list(A=1, B=LETTERS, C=DataFrame(X=1:5))
meta <- stageObject(ll, tmp, path="stuff")
writeMetadata(meta, tmp)

redirect <- createRedirection(tmp, "whoop", "whee/simple.csv.gz")
writeMetadata(redirect, tmp)

list.files(tmp, recursive=TRUE)
moveObject(tmp, "whoop", "YAY")
list.files(tmp, recursive=TRUE)

}
\author{
Aaron Lun
}
