import mypy.nodes
import mypy.patterns

VisitorNodeTypeMap = dict[str, type[mypy.nodes.Node]]

METHOD_NODE_MAPPINGS: VisitorNodeTypeMap = {
    "visit_as_pattern": mypy.patterns.AsPattern,
    "visit_assert_stmt": mypy.nodes.AssertStmt,
    "visit_assert_type_expr": mypy.nodes.AssertTypeExpr,
    "visit_assignment_expr": mypy.nodes.AssignmentExpr,
    "visit_assignment_stmt": mypy.nodes.AssignmentStmt,
    "visit_await_expr": mypy.nodes.AwaitExpr,
    "visit_block": mypy.nodes.Block,
    "visit_break_stmt": mypy.nodes.BreakStmt,
    "visit_bytes_expr": mypy.nodes.BytesExpr,
    "visit_call_expr": mypy.nodes.CallExpr,
    "visit_cast_expr": mypy.nodes.CastExpr,
    "visit_class_def": mypy.nodes.ClassDef,
    "visit_class_pattern": mypy.patterns.ClassPattern,
    "visit_comparison_expr": mypy.nodes.ComparisonExpr,
    "visit_complex_expr": mypy.nodes.ComplexExpr,
    "visit_conditional_expr": mypy.nodes.ConditionalExpr,
    "visit_continue_stmt": mypy.nodes.ContinueStmt,
    "visit_decorator": mypy.nodes.Decorator,
    "visit_del_stmt": mypy.nodes.DelStmt,
    "visit_dict_expr": mypy.nodes.DictExpr,
    "visit_dictionary_comprehension": mypy.nodes.DictionaryComprehension,
    "visit_ellipsis": mypy.nodes.EllipsisExpr,
    "visit_enum_call_expr": mypy.nodes.EnumCallExpr,
    "visit_expression_stmt": mypy.nodes.ExpressionStmt,
    "visit_float_expr": mypy.nodes.FloatExpr,
    "visit_for_stmt": mypy.nodes.ForStmt,
    "visit_func_def": mypy.nodes.FuncDef,
    "visit_func": mypy.nodes.FuncItem,
    "visit_generator_expr": mypy.nodes.GeneratorExpr,
    "visit_global_decl": mypy.nodes.GlobalDecl,
    "visit_if_stmt": mypy.nodes.IfStmt,
    "visit_import_all": mypy.nodes.ImportAll,
    "visit_import_from": mypy.nodes.ImportFrom,
    "visit_import": mypy.nodes.Import,
    "visit_index_expr": mypy.nodes.IndexExpr,
    "visit_int_expr": mypy.nodes.IntExpr,
    "visit_lambda_expr": mypy.nodes.LambdaExpr,
    "visit_list_comprehension": mypy.nodes.ListComprehension,
    "visit_list_expr": mypy.nodes.ListExpr,
    "visit_mapping_pattern": mypy.patterns.MappingPattern,
    "visit_match_stmt": mypy.nodes.MatchStmt,
    "visit_member_expr": mypy.nodes.MemberExpr,
    "visit_mypy_file": mypy.nodes.MypyFile,
    "visit_namedtuple_expr": mypy.nodes.NamedTupleExpr,
    "visit_name_expr": mypy.nodes.NameExpr,
    "visit_newtype_expr": mypy.nodes.NewTypeExpr,
    "visit_nonlocal_decl": mypy.nodes.NonlocalDecl,
    "visit_operator_assignment_stmt": mypy.nodes.OperatorAssignmentStmt,
    "visit_op_expr": mypy.nodes.OpExpr,
    "visit_or_pattern": mypy.patterns.OrPattern,
    "visit_overloaded_func_def": mypy.nodes.OverloadedFuncDef,
    "visit_paramspec_expr": mypy.nodes.ParamSpecExpr,
    "visit_pass_stmt": mypy.nodes.PassStmt,
    "visit_placeholder_node": mypy.nodes.PlaceholderNode,
    "visit__promote_expr": mypy.nodes.PromoteExpr,
    "visit_raise_stmt": mypy.nodes.RaiseStmt,
    "visit_return_stmt": mypy.nodes.ReturnStmt,
    "visit_reveal_expr": mypy.nodes.RevealExpr,
    "visit_sequence_pattern": mypy.patterns.SequencePattern,
    "visit_set_comprehension": mypy.nodes.SetComprehension,
    "visit_set_expr": mypy.nodes.SetExpr,
    "visit_singleton_pattern": mypy.patterns.SingletonPattern,
    "visit_slice_expr": mypy.nodes.SliceExpr,
    "visit_star_expr": mypy.nodes.StarExpr,
    "visit_starred_pattern": mypy.patterns.StarredPattern,
    "visit_str_expr": mypy.nodes.StrExpr,
    "visit_super_expr": mypy.nodes.SuperExpr,
    "visit_temp_node": mypy.nodes.TempNode,
    "visit_try_stmt": mypy.nodes.TryStmt,
    "visit_tuple_expr": mypy.nodes.TupleExpr,
    "visit_type_alias_expr": mypy.nodes.TypeAliasExpr,
    "visit_type_alias": mypy.nodes.TypeAlias,
    "visit_type_application": mypy.nodes.TypeApplication,
    "visit_typeddict_expr": mypy.nodes.TypedDictExpr,
    "visit_type_var_expr": mypy.nodes.TypeVarExpr,
    "visit_type_var_tuple_expr": mypy.nodes.TypeVarTupleExpr,
    "visit_unary_expr": mypy.nodes.UnaryExpr,
    "visit_value_pattern": mypy.patterns.ValuePattern,
    "visit_var": mypy.nodes.Var,
    "visit_while_stmt": mypy.nodes.WhileStmt,
    "visit_with_stmt": mypy.nodes.WithStmt,
    "visit_yield_expr": mypy.nodes.YieldExpr,
    "visit_yield_from_expr": mypy.nodes.YieldFromExpr,
}
