-- Sheaf cohomology and the cotangent sheaf have to have algorithms developed for computing them:

-- Date: Thu, 29 Mar 2007 16:48:20 -0500
-- From: "Daniel R. Grayson" <dan@math.uiuc.edu>
-- To: Yang-Hui He <yang-hui.he@merton.ox.ac.uk>
-- CC: dan@math.uiuc.edu, mike@math.cornell.edu
-- In-reply-to: <200703292118.l2TLI5px009289@u123.math.uiuc.edu>
-- 	(dan@math.uiuc.edu)
-- Subject: Re: Proj
-- Reply-to: dan@math.uiuc.edu
-- 
-- 
-- We also compute the singularLocus of a weighted projective space incorrectly:
-- 
--     i41 : A = ZZ/101[x,y,z,Degrees=>{1,1,2}]
-- 
--     o41 = A
-- 
--     o41 : PolynomialRing
-- 
--     i42 : X = Proj A
-- 
--     o42 = X
-- 
--     o42 : ProjectiveVariety
-- 
--     i43 : singularLocus X
-- 
-- 		ZZ
-- 	       --- [x, y, z]
-- 	       101
--     o43 = Proj(-------------)
-- 		     1
-- 
--     o43 : ProjectiveVariety
-- 
-- 
-- > Date: Thu, 29 Mar 2007 16:18:05 -0500
-- > From: "Daniel R. Grayson" <dan@math.uiuc.edu>
-- > To: Yang-Hui He <yang-hui.he@merton.ox.ac.uk>
-- > CC: mike@math.cornell.edu, dan@math.uiuc.edu
-- > Subject: Re: Proj
-- > Reply-to: dan@math.uiuc.edu
-- > 
-- > 
-- > Yup, the algorithm for cotangentSheaf is wrong in that case ...
-- > 
-- > > Date: Tue, 13 Mar 2007 12:41:33 -0500
-- > > From: "Daniel R. Grayson" <dan@math.uiuc.edu>
-- > > To: Yang-Hui He <yang-hui.he@merton.ox.ac.uk>
-- > > CC: mike@math.cornell.edu, dan@math.uiuc.edu
-- > > Subject: Re: Proj
-- > > Reply-to: dan@math.uiuc.edu
-- > > 
-- > > 
-- > > Most likely our algorithm for cotangentSheaf is just wrong for nonstandard
-- > > weights.  I'll try to figure it out.
-- > > 
-- > > Here's the code if you want to take a look at it.
-- > > 
-- > >     i1 : code methods cotangentSheaf
-- > > 
-- > >     o1 = -- code for method: cotangentSheaf(ProjectiveVariety)
-- > > 	 -- src/M2/Macaulay2/m2/varieties.m2:243-248
-- > > 	 cotangentSheaf ProjectiveVariety := CoherentSheaf => opts -> (cacheValue symbol cotangentSheaf) ((X) -> (
-- > > 		   R := ring X;
-- > > 		   F := presentation R;
-- > > 		   om := sheaf(X, homology(vars ring F ** R,jacobian F ** R));
-- > > 		   if opts.Minimize then om = minimalPresentation om;
-- > > 		   om))
-- > > 	 ---------------------------------
-- > > 	 -- code for method: cotangentSheaf(ZZ,ProjectiveVariety)
-- > > 	 -- src/M2/Macaulay2/m2/varieties.m2:250-253
-- > > 	 cotangentSheaf(ZZ,ProjectiveVariety) := CoherentSheaf => opts -> (i,X) -> (
-- > > 	      if X#?(cotangentSheaf,i)
-- > > 	      then X#(cotangentSheaf,i) 
-- > > 	      else X#(cotangentSheaf,i) = exteriorPower(i,cotangentSheaf(X,opts)))
-- > > 
-- > > I'm also CC-ing Mike.
-- > > 
-- > > > Date: Tue, 13 Mar 2007 17:40:08 +0000
-- > > > From: Yang-Hui He <yang-hui.he@merton.ox.ac.uk>
-- > > > To: "Daniel R. Grayson" <dan@math.uiuc.edu>
-- > > > Subject: Proj
-- > > > 
-- > > > Hi Dan,
-- > > > 
-- > > > 
-- > > > Could I ask another Macaulay2 question regarding weighted projective spaces?
-- > > > 
-- > > > I know, for example, the the sextic in WP_{1,1,2,2} is a K3 surface.
-- > > > 
-- > > > So I can define:
-- > > > 
-- > > > R = ZZ/101[x_0..x_3, Degrees => {1,1,2,2}];
-- > > > k3 = Proj(R / random(6,R));
-- > > > 
-- > > > Then, I can define the cotangent bundle as:
-- > > > 
-- > > > cot = cotangentSheaf k3;
-- > > > 
-- > > > strangely, rank cot  does not give me 2, nor do the HH^i of cot  give 
-- > > > the expected values.
-- > > > 
-- > > > I tried some other weighted projective varieties, they all seem to give 
-- > > > non-sensical results.  What am I doing wrong?
-- > > > 
-- > > > Thanks a lot again in advance!
-- > > > 
-- > > > Yang.
-- > > > 
-- > > 
-- > 
-- 


-- Date: Mon, 2 Apr 2007 20:33:19 -0500 (CDT)
-- From: "Daniel R. Grayson" <dan@math.uiuc.edu>
-- To: "Dr. Yang-Hui He" <yang-hui.he@merton.ox.ac.uk>
-- CC: dan@math.uiuc.edu
-- In-reply-to: <46119D8D.4030503@merton.ox.ac.uk> (yang-hui.he@merton.ox.ac.uk)
-- Subject: Re: Proj
-- Reply-to: dan@math.uiuc.edu
-- 
-- 
-- Thanks!  We'll have to get an algorithm for that (and for cotangentSheaf).
-- 
-- > Date: Mon, 02 Apr 2007 20:19:25 -0400
-- > From: "Dr. Yang-Hui He" <yang-hui.he@merton.ox.ac.uk>
-- > To: dan@math.uiuc.edu
-- > CC: mike@math.cornell.edu
-- > Subject: Re: Proj
-- > 
-- > 
-- > Hi!
-- > 
-- > Thanks for the message.
-- > After some experimenting; I am not sure about computing the cohomologies 
-- > even for line bundles in weighted projective varieties.
-- > 
-- > 
-- > Take, for example the following:
-- > 
-- > r = ZZ/101[x_0..x_4, Degrees => {1,1,1,2,5}];
-- > s = r / random(10,r);
-- > 
-- > so s defines a Calabi-Yau threefold in weighted projective P^4
-- > 
-- > now consider the cohomology groups for the rank 3 bundle   O(2)^3:
-- > 
-- > for i from 0 to 3 do print rank HH^i sheaf s^{2,2,2}
-- > 
-- > this gives
-- > 
-- > 21
-- > 0
-- > 0
-- > 39
-- > 
-- > the index is therefore -18.
-- > 
-- > But I think the index should be -8.
-- > 
-- > 
-- > Or, taking for example,
-- > 
-- > for i from 0 to 3 do print rank HH^i sheaf s^{1,1,1,1,1,1}  which gives
-- > 
-- > 18
-- > 0
-- > 0
-- > 132
-- > 
-- > which has index -114
-- > 
-- > but I think the correct index should be -2
-- > 
-- > 
-- > 
-- > Yang.
-- > 
-- > 
-- > 
-- > 
-- > 
-- > Daniel R. Grayson wrote:
-- > > I'm guessing just local cohomology and not Serre duality is used, so it ought
-- > > to be okay.  Mike, do you know?
-- > >
-- > >   
-- > >> Date: Thu, 29 Mar 2007 22:46:00 +0100
-- > >> From: "Dr. Yang-Hui He" <yang-hui.he@merton.ox.ac.uk>
-- > >> To: dan@math.uiuc.edu
-- > >> CC: mike@math.cornell.edu
-- > >> Subject: Re: Proj
-- > >>
-- > >> What about cohomology for general bundles? is it also wrong in that case?
-- > >> e.g. if I did things like  HH^1 sheaf R^{1,1,1}  where R is the weighted 
-- > >> projective module?
-- > >>
-- > >>     
-- > 
-- 
