// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UHSUB_4H_TRACE_AARCH64_H_
#define VIXL_SIM_UHSUB_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uhsub_4H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd99a, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0x1999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0x003f, 0x1999, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x195a, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd99a, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd999, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xd999, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc444, 0xc444, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xaaea, 0xb333, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0x99d9, 0x99d9, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0x807f, 0x99d9, 0xaae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x807f, 0x99d8, 0xaae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x99d8, 0xaae9, 0xc006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x99d8, 0xaab2, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x99a1, 0xaaac, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8047, 0x999b, 0xaaab, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8041, 0x999a, 0xaaab, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc041, 0xd99a, 0xeaab, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd99a, 0xeaaa, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd999, 0xeaaa, 0xeaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd999, 0xd555, 0xd998, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc444, 0xc444, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xb333, 0xaaea, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0x99d9, 0xaaea, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x99d9, 0xaae9, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0xaae9, 0xc03d, 0xc007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d8, 0xaae9, 0xc006, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d8, 0xaab2, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999b, 0xaaab, 0xbfff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99b, 0xeaab, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaab, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xeaaa, 0xeaa9, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xd555, 0xd998, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc444, 0xc444, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xaaea, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0xaaea, 0xc03d, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xc03d, 0xc03d, 0xc007, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaae9, 0xc03d, 0xc007, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaae9, 0xc006, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaab2, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaac, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xd998, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc444, 0xc03e, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc03e, 0x8008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc03d, 0xc007, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc007, 0xc001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc006, 0xc000, 0xc000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xbfff, 0x3fff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x3fff, 0x3fff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fbf, 0x2666, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x2665, 0x1555, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x1554, 0x0001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x0000, 0x0000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfffe, 0xeaaa, 0x999a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xeaaa, 0xd999, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaa9, 0xd999, 0xc03f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd998, 0xc03f, 0xc03f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc03e, 0x803e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0x803e, 0x8008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0x8008, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc007, 0x8001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc007, 0xc001, 0x8001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x3fff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0xffff, 0xfff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0xe666, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x2666, 0xd555, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x1555, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x0001, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xbfff, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xaaab, 0x999a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xeaaa, 0x999a, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xd999, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xc03f, 0x803f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0x803f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0x803f, 0x803f, 0x8009, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0x803e, 0x8008, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0x8008, 0x8002, 0x8002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc007, 0x8001, 0x8001, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0x8001, 0x8001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xffff, 0xffff, 0xfff9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xffff, 0xfff8, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0xffc1, 0xffc1, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xffc0, 0xe667, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xe666, 0xd556, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0xd555, 0xc002, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0xc001, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0xc001, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc000, 0xc000, 0xaaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xbfff, 0xaaab, 0x999b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xaaab, 0x999a, 0x8041, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0x999a, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0x8040, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0x803f, 0x803f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x803f, 0x803f, 0x8010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x803f, 0x8009, 0x8009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803e, 0x8008, 0x8002, 0x8009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8008, 0x8002, 0x8002, 0x8008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8001, 0x8001, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8001, 0x0001, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x0000, 0x0000, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff9, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff8, 0xffc2, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff8, 0xffc2, 0xffc2, 0xffc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc1, 0xffc1, 0xe66e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc1, 0xe667, 0xd55d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc0, 0xe667, 0xd556, 0xc009, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe666, 0xd556, 0xc002, 0xc009, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xc002, 0xc002, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xc001, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xc001, 0xc007, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xc000, 0xaab3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xaaac, 0x99a2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xaaab, 0x999b, 0x8048, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x999a, 0x8041, 0x8047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0x8040, 0x8040, 0x8047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x8040, 0x8046, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x8046, 0x8046, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x803f, 0x8010, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x8009, 0x8009, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8008, 0x8002, 0x8009, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8002, 0x8008, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x8001, 0x0008, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0001, 0x0007, 0x003d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff9, 0xffc9, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff8, 0xffc2, 0xffc9, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc1, 0xe66e, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xe667, 0xd55d, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd556, 0xc009, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xc002, 0xc009, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xc002, 0xc008, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xc008, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xc007, 0xaae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xaab3, 0x99d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xaaac, 0x99a2, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x999b, 0x8048, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0x8041, 0x8047, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x8047, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8047, 0x807d, 0x8047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8046, 0x8046, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x8010, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8009, 0x8009, 0x803f, 0x803f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8009, 0x803f, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8002, 0x8008, 0x003e, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x0008, 0x003e, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0007, 0x003d, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff9, 0xffc9, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffc9, 0xffff, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffc8, 0xe6a5, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xe66e, 0xd594, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xd55d, 0xc040, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xc009, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xc009, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xc008, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc008, 0xc03e, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc007, 0xaae9, 0x99d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xaab3, 0x99d8, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0x99a2, 0x807e, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999b, 0x8048, 0x807e, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8041, 0x8047, 0x807d, 0x807d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8047, 0x807d, 0x807d, 0x8047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8047, 0x807d, 0x8047, 0x8041, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8046, 0x8046, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8010, 0x8040, 0x8040, 0x8040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8009, 0x803f, 0x803f, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8009, 0x803f, 0x003f, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8008, 0x003e, 0x003e, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003e, 0x003e, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0007, 0x003d, 0x0037, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0007, 0x0036, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0xffff, 0xffff, 0xe6a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0xffff, 0xe6a5, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc8, 0xe6a5, 0xd594, 0xc041, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe66e, 0xd594, 0xc040, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd55d, 0xc040, 0xc040, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc009, 0xc03f, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc009, 0xc03f, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xc03e, 0xc03e, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xc03e, 0xaaea, 0x99d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc007, 0xaae9, 0x99d9, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaab3, 0x99d8, 0x807f, 0x807f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99a2, 0x807e, 0x807e, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8048, 0x807e, 0x807e, 0x807e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807e, 0x807e, 0x99a1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x807d, 0x8047, 0x999b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x8047, 0x8041, 0x999a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8046, 0x8040, 0x8040, 0x999a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x8040, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x803f, 0x003f, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x003f, 0x003f, 0x1998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003e, 0x003e, 0x1991, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003e, 0x0037, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003d, 0x0037, 0x0001, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0036, 0x0000, 0x0000, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xe6a6, 0xeeef, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a5, 0xd595, 0xd99b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xd594, 0xc041, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xc040, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xc040, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc03f, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc03f, 0xc444, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xaaea, 0xb333, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xaaea, 0x99d9, 0x99d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaae9, 0x99d9, 0x807f, 0x99d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d8, 0x807f, 0x807f, 0x99d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807e, 0x807e, 0x99d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807e, 0x99d8, 0xaab2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x807e, 0x99a1, 0xaaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807d, 0x8047, 0x999b, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8047, 0x8041, 0x999a, 0xaaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x999a, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x8040, 0x1999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x803f, 0x003f, 0x1999, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x195a, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd99a, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd999, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xd999, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc444, 0xc444, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xaaea, 0xb333, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0x99d9, 0x99d9, 0xaaea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0x807f, 0x99d9, 0xaae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x807f, 0x99d8, 0xaae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x99d8, 0xaae9, 0xc006, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x99d8, 0xaab2, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807e, 0x99a1, 0xaaac, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8047, 0x999b, 0xaaab, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8041, 0x999a, 0xaaab, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x999a, 0x2aaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8040, 0x1999, 0x2aaa, 0x3ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc041, 0xd99a, 0xeaab, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd99a, 0xeaaa, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd999, 0xeaaa, 0xeaa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd999, 0xd555, 0xd998, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc444, 0xc444, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xb333, 0xaaea, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0x99d9, 0xaaea, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x807f, 0x99d9, 0xaae9, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0xaae9, 0xc03d, 0xc007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d8, 0xaae9, 0xc006, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d8, 0xaab2, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99a1, 0xaaac, 0xbfff, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999b, 0xaaab, 0xbfff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0xaaab, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x999a, 0x2aaa, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99b, 0xeaab, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaab, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaaa, 0xfffe, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xeaaa, 0xeaa9, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xd555, 0xd998, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc444, 0xc444, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xb333, 0xaaea, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x99d9, 0xaaea, 0xc03d, 0xc03d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xc03d, 0xc03d, 0xc007, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaae9, 0xc03d, 0xc007, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaae9, 0xc006, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaab2, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaac, 0xbfff, 0xbfff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0xbfff, 0x3fff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaab, 0x3ffe, 0x3ffe, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaac, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xfffe, 0xfffe, 0xeaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xfffe, 0xeaaa, 0xd999, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xeaa9, 0xd999, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xd998, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc444, 0xc03e, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaea, 0xc03e, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc03e, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc03d, 0xc007, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc007, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc006, 0xc000, 0xc000, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xc000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xbfff, 0x3fff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0x3ffe, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0x3ff7, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffd, 0x3ff7, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff6, 0x3fc0, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fbf, 0x2666, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x2665, 0x1555, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x1554, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xfffe, 0xeaaa, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xeaaa, 0xd999, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaa9, 0xd999, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd998, 0xc03f, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc03e, 0xc03e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc03e, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc008, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03d, 0xc007, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc007, 0xc001, 0xc001, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0xc000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0x3fff, 0x3fff, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0x3fff, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ffe, 0x3ff8, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ff7, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3fc1, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x2666, 0x1556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x2666, 0x1555, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x1555, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xeaab, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xeaaa, 0xd99a, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xd999, 0xc040, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xc03f, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc03f, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc03f, 0xd55d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc03e, 0xc008, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc008, 0xc002, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc007, 0xc001, 0xc001, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xc001, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc000, 0x4000, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0x4000, 0x4000, 0x5554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0x3fff, 0x554d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0x3ff8, 0x5516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3ff8, 0x3fc2, 0x5516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3fc1, 0x3fc1, 0x5515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3bbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x2667, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x2666, 0x1556, 0x1556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0x1555, 0x0002, 0x1556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0x0001, 0x0001, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x0001, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xeaab, 0xeeef, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xeaab, 0xd99a, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaaa, 0xd99a, 0xc040, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd999, 0xc040, 0xc040, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xc03f, 0xd593, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xd593, 0xe66e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc03f, 0xd55d, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03e, 0xc008, 0xd556, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xc002, 0xd556, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0xd555, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc001, 0x5555, 0x6665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0x4000, 0x5554, 0x6665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4000, 0x5554, 0x665e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0x554d, 0x6627, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3ff8, 0x5516, 0x6627, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff8, 0x3fc2, 0x5516, 0x6626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3fc1, 0x5515, 0x4ccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3fc1, 0x3bbb, 0x3bbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x2667, 0x2aaa, 0x2667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0x1556, 0x1556, 0x2667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0x0002, 0x1556, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x1555, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0001, 0x1555, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1554, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xeaab, 0xeeef, 0xe6a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xd99a, 0xd595, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xc040, 0xd594, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xc040, 0xd594, 0xe6a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd594, 0xe6a4, 0xffc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd593, 0xe66e, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd55d, 0xe667, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xd556, 0xe667, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xd556, 0xe666, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xd555, 0x6666, 0x7fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0x5555, 0x6665, 0x7fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x5554, 0x6665, 0x7fb8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x5554, 0x665e, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x554d, 0x6627, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff8, 0x5516, 0x6627, 0x7f80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc2, 0x5516, 0x6626, 0x6626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x5515, 0x4ccc, 0x5515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3bbb, 0x3bbb, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2667, 0x2aaa, 0x2667, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1556, 0x1556, 0x2667, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x1556, 0x2666, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x1555, 0x2666, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x1555, 0x2665, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xeeef, 0xe6a6, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xd595, 0xe6a5, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd594, 0xe6a5, 0xfffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a5, 0xfffe, 0xffc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a4, 0xffc8, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd593, 0xe66e, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd55d, 0xe667, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe667, 0xffc0, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe666, 0x7fc0, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0x6666, 0x7fbf, 0x7fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x6665, 0x7fbf, 0x7fb8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x6665, 0x7fb8, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5554, 0x665e, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x554d, 0x6627, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5516, 0x6627, 0x7f80, 0x6627, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5516, 0x6626, 0x6626, 0x5516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5515, 0x4ccc, 0x5515, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3bbb, 0x3bbb, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x2667, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1556, 0x2667, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1556, 0x2666, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0x2666, 0x3fbf, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0x2665, 0x2a6b, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xe6a6, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0xe6a5, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xffff, 0xffff, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe66e, 0xffc1, 0xffc1, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc1, 0xffc1, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc0, 0x7fc0, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe666, 0x7fc0, 0x7fc0, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x7fbf, 0x7fbf, 0x7fb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6665, 0x7fbf, 0x7fb8, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6665, 0x7fb8, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x665e, 0x7f81, 0x7f81, 0x7f81, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6627, 0x7f81, 0x7f81, 0x6627, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6627, 0x7f80, 0x6627, 0x5516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6626, 0x6626, 0x5516, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ccc, 0x5515, 0x3fc2, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3bbb, 0x3fc1, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2667, 0x3fc1, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2667, 0x3fc0, 0x3fc0, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0x3fc0, 0x3fc0, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x2a6b, 0x195a, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xffff, 0xffff, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffff, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xffc9, 0xffc3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffe, 0xffc8, 0xffc2, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc8, 0xffc2, 0xffc2, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc1, 0xffc1, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc1, 0x7fc1, 0x7fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc0, 0x7fc0, 0x7fc0, 0x7fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fc0, 0x7fc0, 0x7fc0, 0x7fb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fbf, 0x7fbf, 0x7fb9, 0x7f83, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fbf, 0x7fb8, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fb8, 0x7f82, 0x7f82, 0x7f82, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x7f81, 0x6628, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f81, 0x7f81, 0x6627, 0x5517, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f80, 0x6627, 0x5516, 0x3fc3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6626, 0x5516, 0x3fc2, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5515, 0x3fc2, 0x3fc2, 0x3fc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3fc1, 0x3fc1, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x195a, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_uhsub_4H = 576;

#endif  // VIXL_SIM_UHSUB_4H_TRACE_AARCH64_H_
