// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABDL2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_UABDL2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_uabdl2_2D[] = {
  0x0000000000000000, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000001,
  0x00000000007ffcff, 0x0000000000000002,
  0x00000000007ffcfe, 0x0000000000000020,
  0x00000000007ffce0, 0x000000000000007d,
  0x00000000007ffc83, 0x000000000000007e,
  0x00000000007ffc82, 0x000000000000007f,
  0x00000000007ffc81, 0x0000000000007ffd,
  0x00000000007f7d03, 0x0000000000007ffe,
  0x00000000007f7d02, 0x0000000000007fff,
  0x00000000007f7d01, 0x0000000033333333,
  0x0000000032b33633, 0x0000000055555555,
  0x0000000054d55855, 0x000000007ffffffd,
  0x000000007f8002fd, 0x000000007ffffffe,
  0x000000007f8002fe, 0x000000007fffffff,
  0x000000007f8002ff, 0x0000000080000000,
  0x000000007f800300, 0x0000000080000001,
  0x000000007f800301, 0x00000000aaaaaaaa,
  0x00000000aa2aadaa, 0x00000000cccccccc,
  0x00000000cc4ccfcc, 0x00000000ffff8000,
  0x00000000ff7f8300, 0x00000000ffff8001,
  0x00000000ff7f8301, 0x00000000ffff8002,
  0x00000000ff7f8302, 0x00000000ffff8003,
  0x00000000ff7f8303, 0x00000000ffffff80,
  0x00000000ff800280, 0x00000000ffffff81,
  0x00000000ff800281, 0x00000000ffffff82,
  0x00000000ff800282, 0x00000000ffffff83,
  0x00000000ff800283, 0x00000000ffffffe0,
  0x00000000ff8002e0, 0x00000000fffffffd,
  0x00000000ff8002fd, 0x00000000fffffffe,
  0x00000000ff8002fe, 0x00000000ffffffff,
  0x00000000ffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000000000001f,
  0x0000000000000020, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007f, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000033333332,
  0x0000000033333333, 0x0000000055555554,
  0x0000000055555555, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000001, 0x00000000aaaaaaa9,
  0x00000000aaaaaaaa, 0x00000000cccccccb,
  0x00000000cccccccc, 0x00000000ffff7fff,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8002, 0x00000000ffff8002,
  0x00000000ffff8003, 0x00000000ffffff7f,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff82, 0x00000000ffffff82,
  0x00000000ffffff83, 0x00000000ffffffdf,
  0x00000000ffffffe0, 0x00000000fffffffc,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000000fffffffe, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000000000001e,
  0x000000000000001f, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000033333331,
  0x0000000033333332, 0x0000000055555553,
  0x0000000055555554, 0x000000007ffffffb,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x0000000080000000, 0x00000000aaaaaaa8,
  0x00000000aaaaaaa9, 0x00000000ccccccca,
  0x00000000cccccccb, 0x00000000ffff7ffe,
  0x00000000ffff7fff, 0x00000000ffff7fff,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8002, 0x00000000ffffff7e,
  0x00000000ffffff7f, 0x00000000ffffff7f,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff82, 0x00000000ffffffde,
  0x00000000ffffffdf, 0x00000000fffffffb,
  0x00000000fffffffc, 0x00000000fffffffc,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffd, 0x0000000000000020,
  0x0000000000000002, 0x000000000000001f,
  0x0000000000000001, 0x000000000000001e,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000001e, 0x000000000000005d,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000007d, 0x0000000000007fdd,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007ffd, 0x0000000033333313,
  0x0000000033333331, 0x0000000055555535,
  0x0000000055555553, 0x000000007fffffdd,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007ffffffd, 0x000000007fffffe0,
  0x000000007ffffffe, 0x000000007fffffe1,
  0x000000007fffffff, 0x00000000aaaaaa8a,
  0x00000000aaaaaaa8, 0x00000000ccccccac,
  0x00000000ccccccca, 0x00000000ffff7fe0,
  0x00000000ffff7ffe, 0x00000000ffff7fe1,
  0x00000000ffff7fff, 0x00000000ffff7fe2,
  0x00000000ffff8000, 0x00000000ffff7fe3,
  0x00000000ffff8001, 0x00000000ffffff60,
  0x00000000ffffff7e, 0x00000000ffffff61,
  0x00000000ffffff7f, 0x00000000ffffff62,
  0x00000000ffffff80, 0x00000000ffffff63,
  0x00000000ffffff81, 0x00000000ffffffc0,
  0x00000000ffffffde, 0x00000000ffffffdd,
  0x00000000fffffffb, 0x00000000ffffffde,
  0x00000000fffffffc, 0x00000000ffffffdf,
  0x00000000ffffffdf, 0x000000000000007d,
  0x0000000000000020, 0x000000000000007c,
  0x000000000000001f, 0x000000000000007b,
  0x000000000000001e, 0x000000000000005d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000005d, 0x0000000000000001,
  0x000000000000005e, 0x0000000000000002,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007fdf, 0x00000000333332b6,
  0x0000000033333313, 0x00000000555554d8,
  0x0000000055555535, 0x000000007fffff80,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffffdf, 0x000000007fffff83,
  0x000000007fffffe0, 0x000000007fffff84,
  0x000000007fffffe1, 0x00000000aaaaaa2d,
  0x00000000aaaaaa8a, 0x00000000cccccc4f,
  0x00000000ccccccac, 0x00000000ffff7f83,
  0x00000000ffff7fe0, 0x00000000ffff7f84,
  0x00000000ffff7fe1, 0x00000000ffff7f85,
  0x00000000ffff7fe2, 0x00000000ffff7f86,
  0x00000000ffff7fe3, 0x00000000ffffff03,
  0x00000000ffffff60, 0x00000000ffffff04,
  0x00000000ffffff61, 0x00000000ffffff05,
  0x00000000ffffff62, 0x00000000ffffff06,
  0x00000000ffffff63, 0x00000000ffffff63,
  0x00000000ffffffc0, 0x00000000ffffff80,
  0x00000000ffffffdd, 0x00000000ffffff81,
  0x00000000ffffffde, 0x00000000ffffff82,
  0x00000000ffffff82, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000005d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x00000000333332b5,
  0x00000000333332b6, 0x00000000555554d7,
  0x00000000555554d8, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff84, 0x00000000aaaaaa2c,
  0x00000000aaaaaa2d, 0x00000000cccccc4e,
  0x00000000cccccc4f, 0x00000000ffff7f82,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f85, 0x00000000ffff7f85,
  0x00000000ffff7f86, 0x00000000ffffff02,
  0x00000000ffffff03, 0x00000000ffffff03,
  0x00000000ffffff04, 0x00000000ffffff04,
  0x00000000ffffff05, 0x00000000ffffff05,
  0x00000000ffffff06, 0x00000000ffffff62,
  0x00000000ffffff63, 0x00000000ffffff7f,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff81, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000005e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x00000000333332b4,
  0x00000000333332b5, 0x00000000555554d6,
  0x00000000555554d7, 0x000000007fffff7e,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x00000000aaaaaa2b,
  0x00000000aaaaaa2c, 0x00000000cccccc4d,
  0x00000000cccccc4e, 0x00000000ffff7f81,
  0x00000000ffff7f82, 0x00000000ffff7f82,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f85, 0x00000000ffffff01,
  0x00000000ffffff02, 0x00000000ffffff02,
  0x00000000ffffff03, 0x00000000ffffff03,
  0x00000000ffffff04, 0x00000000ffffff04,
  0x00000000ffffff05, 0x00000000ffffff61,
  0x00000000ffffff62, 0x00000000ffffff7e,
  0x00000000ffffff7f, 0x00000000ffffff7f,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff80, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000007f80, 0x000000003332b336,
  0x00000000333332b4, 0x000000005554d558,
  0x00000000555554d6, 0x000000007fff8000,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fffff80, 0x000000007fff8003,
  0x000000007fffff81, 0x000000007fff8004,
  0x000000007fffff82, 0x00000000aaaa2aad,
  0x00000000aaaaaa2b, 0x00000000cccc4ccf,
  0x00000000cccccc4d, 0x00000000ffff0003,
  0x00000000ffff7f81, 0x00000000ffff0004,
  0x00000000ffff7f82, 0x00000000ffff0005,
  0x00000000ffff7f83, 0x00000000ffff0006,
  0x00000000ffff7f84, 0x00000000ffff7f83,
  0x00000000ffffff01, 0x00000000ffff7f84,
  0x00000000ffffff02, 0x00000000ffff7f85,
  0x00000000ffffff03, 0x00000000ffff7f86,
  0x00000000ffffff04, 0x00000000ffff7fe3,
  0x00000000ffffff61, 0x00000000ffff8000,
  0x00000000ffffff7e, 0x00000000ffff8001,
  0x00000000ffffff7f, 0x00000000ffff8002,
  0x00000000ffff8002, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000003332b335,
  0x000000003332b336, 0x000000005554d557,
  0x000000005554d558, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8004, 0x00000000aaaa2aac,
  0x00000000aaaa2aad, 0x00000000cccc4cce,
  0x00000000cccc4ccf, 0x00000000ffff0002,
  0x00000000ffff0003, 0x00000000ffff0003,
  0x00000000ffff0004, 0x00000000ffff0004,
  0x00000000ffff0005, 0x00000000ffff0005,
  0x00000000ffff0006, 0x00000000ffff7f82,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f85, 0x00000000ffff7f85,
  0x00000000ffff7f86, 0x00000000ffff7fe2,
  0x00000000ffff7fe3, 0x00000000ffff7fff,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8001, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000003332b334,
  0x000000003332b335, 0x000000005554d556,
  0x000000005554d557, 0x000000007fff7ffe,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x00000000aaaa2aab,
  0x00000000aaaa2aac, 0x00000000cccc4ccd,
  0x00000000cccc4cce, 0x00000000ffff0001,
  0x00000000ffff0002, 0x00000000ffff0002,
  0x00000000ffff0003, 0x00000000ffff0003,
  0x00000000ffff0004, 0x00000000ffff0004,
  0x00000000ffff0005, 0x00000000ffff7f81,
  0x00000000ffff7f82, 0x00000000ffff7f82,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f85, 0x00000000ffff7fe1,
  0x00000000ffff7fe2, 0x00000000ffff7ffe,
  0x00000000ffff7fff, 0x00000000ffff7fff,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff8000, 0x0000000033333333,
  0x0000000000007fff, 0x0000000033333332,
  0x0000000000007ffe, 0x0000000033333331,
  0x0000000000007ffd, 0x0000000033333313,
  0x0000000000007fdf, 0x00000000333332b6,
  0x0000000000007f82, 0x00000000333332b5,
  0x0000000000007f81, 0x00000000333332b4,
  0x0000000000007f80, 0x000000003332b336,
  0x0000000000000002, 0x000000003332b335,
  0x0000000000000001, 0x000000003332b334,
  0x0000000000000000, 0x0000000000000000,
  0x000000003332b334, 0x0000000022222222,
  0x000000005554d556, 0x000000004cccccca,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000007fff8000, 0x000000004ccccccd,
  0x000000007fff8001, 0x000000004cccccce,
  0x000000007fff8002, 0x0000000077777777,
  0x00000000aaaa2aab, 0x0000000099999999,
  0x00000000cccc4ccd, 0x00000000cccc4ccd,
  0x00000000ffff0001, 0x00000000cccc4cce,
  0x00000000ffff0002, 0x00000000cccc4ccf,
  0x00000000ffff0003, 0x00000000cccc4cd0,
  0x00000000ffff0004, 0x00000000cccccc4d,
  0x00000000ffff7f81, 0x00000000cccccc4e,
  0x00000000ffff7f82, 0x00000000cccccc4f,
  0x00000000ffff7f83, 0x00000000cccccc50,
  0x00000000ffff7f84, 0x00000000ccccccad,
  0x00000000ffff7fe1, 0x00000000ccccccca,
  0x00000000ffff7ffe, 0x00000000cccccccb,
  0x00000000ffff7fff, 0x00000000cccccccc,
  0x00000000cccccccc, 0x0000000055555555,
  0x0000000033333333, 0x0000000055555554,
  0x0000000033333332, 0x0000000055555553,
  0x0000000033333331, 0x0000000055555535,
  0x0000000033333313, 0x00000000555554d8,
  0x00000000333332b6, 0x00000000555554d7,
  0x00000000333332b5, 0x00000000555554d6,
  0x00000000333332b4, 0x000000005554d558,
  0x000000003332b336, 0x000000005554d557,
  0x000000003332b335, 0x000000005554d556,
  0x000000003332b334, 0x0000000022222222,
  0x0000000000000000, 0x0000000000000000,
  0x0000000022222222, 0x000000002aaaaaa8,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000004ccccccc, 0x000000002aaaaaab,
  0x000000004ccccccd, 0x000000002aaaaaac,
  0x000000004cccccce, 0x0000000055555555,
  0x0000000077777777, 0x0000000077777777,
  0x0000000099999999, 0x00000000aaaa2aab,
  0x00000000cccc4ccd, 0x00000000aaaa2aac,
  0x00000000cccc4cce, 0x00000000aaaa2aad,
  0x00000000cccc4ccf, 0x00000000aaaa2aae,
  0x00000000cccc4cd0, 0x00000000aaaaaa2b,
  0x00000000cccccc4d, 0x00000000aaaaaa2c,
  0x00000000cccccc4e, 0x00000000aaaaaa2d,
  0x00000000cccccc4f, 0x00000000aaaaaa2e,
  0x00000000cccccc50, 0x00000000aaaaaa8b,
  0x00000000ccccccad, 0x00000000aaaaaaa8,
  0x00000000ccccccca, 0x00000000aaaaaaa9,
  0x00000000cccccccb, 0x00000000aaaaaaaa,
  0x00000000aaaaaaaa, 0x000000007ffffffd,
  0x0000000055555555, 0x000000007ffffffc,
  0x0000000055555554, 0x000000007ffffffb,
  0x0000000055555553, 0x000000007fffffdd,
  0x0000000055555535, 0x000000007fffff80,
  0x00000000555554d8, 0x000000007fffff7f,
  0x00000000555554d7, 0x000000007fffff7e,
  0x00000000555554d6, 0x000000007fff8000,
  0x000000005554d558, 0x000000007fff7fff,
  0x000000005554d557, 0x000000007fff7ffe,
  0x000000005554d556, 0x000000004cccccca,
  0x0000000022222222, 0x000000002aaaaaa8,
  0x0000000000000000, 0x0000000000000000,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x000000002aaaaaaa, 0x0000000000000003,
  0x000000002aaaaaab, 0x0000000000000004,
  0x000000002aaaaaac, 0x000000002aaaaaad,
  0x0000000055555555, 0x000000004ccccccf,
  0x0000000077777777, 0x000000007fff8003,
  0x00000000aaaa2aab, 0x000000007fff8004,
  0x00000000aaaa2aac, 0x000000007fff8005,
  0x00000000aaaa2aad, 0x000000007fff8006,
  0x00000000aaaa2aae, 0x000000007fffff83,
  0x00000000aaaaaa2b, 0x000000007fffff84,
  0x00000000aaaaaa2c, 0x000000007fffff85,
  0x00000000aaaaaa2d, 0x000000007fffff86,
  0x00000000aaaaaa2e, 0x000000007fffffe3,
  0x00000000aaaaaa8b, 0x0000000080000000,
  0x00000000aaaaaaa8, 0x0000000080000001,
  0x00000000aaaaaaa9, 0x0000000080000002,
  0x0000000080000002, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000004, 0x000000002aaaaaac,
  0x000000002aaaaaad, 0x000000004cccccce,
  0x000000004ccccccf, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8004, 0x000000007fff8004,
  0x000000007fff8005, 0x000000007fff8005,
  0x000000007fff8006, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff84, 0x000000007fffff84,
  0x000000007fffff85, 0x000000007fffff85,
  0x000000007fffff86, 0x000000007fffffe2,
  0x000000007fffffe3, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000001, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x000000002aaaaaab,
  0x000000002aaaaaac, 0x000000004ccccccd,
  0x000000004cccccce, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8004, 0x000000007fff8004,
  0x000000007fff8005, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff84, 0x000000007fffff84,
  0x000000007fffff85, 0x000000007fffffe1,
  0x000000007fffffe2, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffe0,
  0x000000007fffffdf, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000004ccccccd,
  0x000000004ccccccc, 0x000000002aaaaaab,
  0x000000002aaaaaaa, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000002aaaaaaa,
  0x000000002aaaaaab, 0x000000004ccccccc,
  0x000000004ccccccd, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8004, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff84, 0x000000007fffffe0,
  0x000000007fffffe1, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007fffffe1,
  0x000000007fffffe0, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000004cccccce,
  0x000000004ccccccd, 0x000000002aaaaaac,
  0x000000002aaaaaab, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000002aaaaaa9,
  0x000000002aaaaaaa, 0x000000004ccccccb,
  0x000000004ccccccc, 0x000000007fff7fff,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8003, 0x000000007fffff7f,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff83, 0x000000007fffffdf,
  0x000000007fffffe0, 0x000000007ffffffc,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffe, 0x00000000aaaaaaaa,
  0x0000000080000001, 0x00000000aaaaaaa9,
  0x0000000080000000, 0x00000000aaaaaaa8,
  0x000000007fffffff, 0x00000000aaaaaa8a,
  0x000000007fffffe1, 0x00000000aaaaaa2d,
  0x000000007fffff84, 0x00000000aaaaaa2c,
  0x000000007fffff83, 0x00000000aaaaaa2b,
  0x000000007fffff82, 0x00000000aaaa2aad,
  0x000000007fff8004, 0x00000000aaaa2aac,
  0x000000007fff8003, 0x00000000aaaa2aab,
  0x000000007fff8002, 0x0000000077777777,
  0x000000004cccccce, 0x0000000055555555,
  0x000000002aaaaaac, 0x000000002aaaaaad,
  0x0000000000000004, 0x000000002aaaaaac,
  0x0000000000000003, 0x000000002aaaaaab,
  0x0000000000000002, 0x000000002aaaaaaa,
  0x0000000000000001, 0x000000002aaaaaa9,
  0x0000000000000000, 0x0000000000000000,
  0x000000002aaaaaa9, 0x0000000022222222,
  0x000000004ccccccb, 0x000000005554d556,
  0x000000007fff7fff, 0x000000005554d557,
  0x000000007fff8000, 0x000000005554d558,
  0x000000007fff8001, 0x000000005554d559,
  0x000000007fff8002, 0x00000000555554d6,
  0x000000007fffff7f, 0x00000000555554d7,
  0x000000007fffff80, 0x00000000555554d8,
  0x000000007fffff81, 0x00000000555554d9,
  0x000000007fffff82, 0x0000000055555536,
  0x000000007fffffdf, 0x0000000055555553,
  0x000000007ffffffc, 0x0000000055555554,
  0x000000007ffffffd, 0x0000000055555555,
  0x0000000055555555, 0x00000000cccccccc,
  0x00000000aaaaaaaa, 0x00000000cccccccb,
  0x00000000aaaaaaa9, 0x00000000ccccccca,
  0x00000000aaaaaaa8, 0x00000000ccccccac,
  0x00000000aaaaaa8a, 0x00000000cccccc4f,
  0x00000000aaaaaa2d, 0x00000000cccccc4e,
  0x00000000aaaaaa2c, 0x00000000cccccc4d,
  0x00000000aaaaaa2b, 0x00000000cccc4ccf,
  0x00000000aaaa2aad, 0x00000000cccc4cce,
  0x00000000aaaa2aac, 0x00000000cccc4ccd,
  0x00000000aaaa2aab, 0x0000000099999999,
  0x0000000077777777, 0x0000000077777777,
  0x0000000055555555, 0x000000004ccccccf,
  0x000000002aaaaaad, 0x000000004cccccce,
  0x000000002aaaaaac, 0x000000004ccccccd,
  0x000000002aaaaaab, 0x000000004ccccccc,
  0x000000002aaaaaaa, 0x000000004ccccccb,
  0x000000002aaaaaa9, 0x0000000022222222,
  0x0000000000000000, 0x0000000000000000,
  0x0000000022222222, 0x000000003332b334,
  0x000000005554d556, 0x000000003332b335,
  0x000000005554d557, 0x000000003332b336,
  0x000000005554d558, 0x000000003332b337,
  0x000000005554d559, 0x00000000333332b4,
  0x00000000555554d6, 0x00000000333332b5,
  0x00000000555554d7, 0x00000000333332b6,
  0x00000000555554d8, 0x00000000333332b7,
  0x00000000555554d9, 0x0000000033333314,
  0x0000000055555536, 0x0000000033333331,
  0x0000000055555553, 0x0000000033333332,
  0x0000000055555554, 0x0000000033333333,
  0x0000000033333333, 0x00000000ffff8000,
  0x00000000cccccccc, 0x00000000ffff7fff,
  0x00000000cccccccb, 0x00000000ffff7ffe,
  0x00000000ccccccca, 0x00000000ffff7fe0,
  0x00000000ccccccac, 0x00000000ffff7f83,
  0x00000000cccccc4f, 0x00000000ffff7f82,
  0x00000000cccccc4e, 0x00000000ffff7f81,
  0x00000000cccccc4d, 0x00000000ffff0003,
  0x00000000cccc4ccf, 0x00000000ffff0002,
  0x00000000cccc4cce, 0x00000000ffff0001,
  0x00000000cccc4ccd, 0x00000000cccc4ccd,
  0x0000000099999999, 0x00000000aaaa2aab,
  0x0000000077777777, 0x000000007fff8003,
  0x000000004ccccccf, 0x000000007fff8002,
  0x000000004cccccce, 0x000000007fff8001,
  0x000000004ccccccd, 0x000000007fff8000,
  0x000000004ccccccc, 0x000000007fff7fff,
  0x000000004ccccccb, 0x000000005554d556,
  0x0000000022222222, 0x000000003332b334,
  0x0000000000000000, 0x0000000000000000,
  0x000000003332b334, 0x0000000000000001,
  0x000000003332b335, 0x0000000000000002,
  0x000000003332b336, 0x0000000000000003,
  0x000000003332b337, 0x0000000000007f80,
  0x00000000333332b4, 0x0000000000007f81,
  0x00000000333332b5, 0x0000000000007f82,
  0x00000000333332b6, 0x0000000000007f83,
  0x00000000333332b7, 0x0000000000007fe0,
  0x0000000033333314, 0x0000000000007ffd,
  0x0000000033333331, 0x0000000000007ffe,
  0x0000000033333332, 0x0000000000007fff,
  0x0000000000007fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff7fff,
  0x00000000ffff7ffe, 0x00000000ffff7fe1,
  0x00000000ffff7fe0, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000ffff0003,
  0x00000000ffff0002, 0x00000000ffff0002,
  0x00000000ffff0001, 0x00000000cccc4cce,
  0x00000000cccc4ccd, 0x00000000aaaa2aac,
  0x00000000aaaa2aab, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000005554d557,
  0x000000005554d556, 0x000000003332b335,
  0x000000003332b334, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x0000000000007f82,
  0x0000000000007f83, 0x0000000000007fdf,
  0x0000000000007fe0, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffe, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff7fe2,
  0x00000000ffff7fe1, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff0005,
  0x00000000ffff0004, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000ffff0003,
  0x00000000ffff0002, 0x00000000cccc4ccf,
  0x00000000cccc4cce, 0x00000000aaaa2aad,
  0x00000000aaaa2aac, 0x000000007fff8005,
  0x000000007fff8004, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000005554d558,
  0x000000005554d557, 0x000000003332b336,
  0x000000003332b335, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f82, 0x0000000000007fde,
  0x0000000000007fdf, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffd, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff7fe3,
  0x00000000ffff7fe2, 0x00000000ffff7f86,
  0x00000000ffff7f85, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff0006,
  0x00000000ffff0005, 0x00000000ffff0005,
  0x00000000ffff0004, 0x00000000ffff0004,
  0x00000000ffff0003, 0x00000000cccc4cd0,
  0x00000000cccc4ccf, 0x00000000aaaa2aae,
  0x00000000aaaa2aad, 0x000000007fff8006,
  0x000000007fff8005, 0x000000007fff8005,
  0x000000007fff8004, 0x000000007fff8004,
  0x000000007fff8003, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000005554d559,
  0x000000005554d558, 0x000000003332b337,
  0x000000003332b336, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000007f7d,
  0x0000000000007f7e, 0x0000000000007f7e,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f81, 0x0000000000007fdd,
  0x0000000000007fde, 0x0000000000007ffa,
  0x0000000000007ffb, 0x0000000000007ffb,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffc, 0x00000000ffffff80,
  0x00000000ffff8003, 0x00000000ffffff7f,
  0x00000000ffff8002, 0x00000000ffffff7e,
  0x00000000ffff8001, 0x00000000ffffff60,
  0x00000000ffff7fe3, 0x00000000ffffff03,
  0x00000000ffff7f86, 0x00000000ffffff02,
  0x00000000ffff7f85, 0x00000000ffffff01,
  0x00000000ffff7f84, 0x00000000ffff7f83,
  0x00000000ffff0006, 0x00000000ffff7f82,
  0x00000000ffff0005, 0x00000000ffff7f81,
  0x00000000ffff0004, 0x00000000cccccc4d,
  0x00000000cccc4cd0, 0x00000000aaaaaa2b,
  0x00000000aaaa2aae, 0x000000007fffff83,
  0x000000007fff8006, 0x000000007fffff82,
  0x000000007fff8005, 0x000000007fffff81,
  0x000000007fff8004, 0x000000007fffff80,
  0x000000007fff8003, 0x000000007fffff7f,
  0x000000007fff8002, 0x00000000555554d6,
  0x000000005554d559, 0x00000000333332b4,
  0x000000003332b337, 0x0000000000007f80,
  0x0000000000000003, 0x0000000000007f7f,
  0x0000000000000002, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7d, 0x0000000000000001,
  0x0000000000007f7e, 0x0000000000000002,
  0x0000000000007f7f, 0x0000000000000003,
  0x0000000000007f80, 0x0000000000000060,
  0x0000000000007fdd, 0x000000000000007d,
  0x0000000000007ffa, 0x000000000000007e,
  0x0000000000007ffb, 0x000000000000007f,
  0x000000000000007f, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff7f,
  0x00000000ffffff7e, 0x00000000ffffff61,
  0x00000000ffffff60, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffffff03,
  0x00000000ffffff02, 0x00000000ffffff02,
  0x00000000ffffff01, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000ffff7f82,
  0x00000000ffff7f81, 0x00000000cccccc4e,
  0x00000000cccccc4d, 0x00000000aaaaaa2c,
  0x00000000aaaaaa2b, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x00000000555554d7,
  0x00000000555554d6, 0x00000000333332b5,
  0x00000000333332b4, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000003, 0x000000000000005f,
  0x0000000000000060, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007e, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff62,
  0x00000000ffffff61, 0x00000000ffffff05,
  0x00000000ffffff04, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffffff03,
  0x00000000ffffff02, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000ffff7f83,
  0x00000000ffff7f82, 0x00000000cccccc4f,
  0x00000000cccccc4e, 0x00000000aaaaaa2d,
  0x00000000aaaaaa2c, 0x000000007fffff85,
  0x000000007fffff84, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x00000000555554d8,
  0x00000000555554d7, 0x00000000333332b6,
  0x00000000333332b5, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x000000000000005e,
  0x000000000000005f, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007d, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff63,
  0x00000000ffffff62, 0x00000000ffffff06,
  0x00000000ffffff05, 0x00000000ffffff05,
  0x00000000ffffff04, 0x00000000ffffff04,
  0x00000000ffffff03, 0x00000000ffff7f86,
  0x00000000ffff7f85, 0x00000000ffff7f85,
  0x00000000ffff7f84, 0x00000000ffff7f84,
  0x00000000ffff7f83, 0x00000000cccccc50,
  0x00000000cccccc4f, 0x00000000aaaaaa2e,
  0x00000000aaaaaa2d, 0x000000007fffff86,
  0x000000007fffff85, 0x000000007fffff85,
  0x000000007fffff84, 0x000000007fffff84,
  0x000000007fffff83, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x00000000555554d9,
  0x00000000555554d8, 0x00000000333332b7,
  0x00000000333332b6, 0x0000000000007f83,
  0x0000000000007f82, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x000000000000005d,
  0x000000000000005e, 0x000000000000007a,
  0x000000000000007b, 0x000000000000007b,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007c, 0x00000000ffffffe0,
  0x00000000ffffff83, 0x00000000ffffffdf,
  0x00000000ffffff82, 0x00000000ffffffde,
  0x00000000ffffff81, 0x00000000ffffffc0,
  0x00000000ffffff63, 0x00000000ffffff63,
  0x00000000ffffff06, 0x00000000ffffff62,
  0x00000000ffffff05, 0x00000000ffffff61,
  0x00000000ffffff04, 0x00000000ffff7fe3,
  0x00000000ffff7f86, 0x00000000ffff7fe2,
  0x00000000ffff7f85, 0x00000000ffff7fe1,
  0x00000000ffff7f84, 0x00000000ccccccad,
  0x00000000cccccc50, 0x00000000aaaaaa8b,
  0x00000000aaaaaa2e, 0x000000007fffffe3,
  0x000000007fffff86, 0x000000007fffffe2,
  0x000000007fffff85, 0x000000007fffffe1,
  0x000000007fffff84, 0x000000007fffffe0,
  0x000000007fffff83, 0x000000007fffffdf,
  0x000000007fffff82, 0x0000000055555536,
  0x00000000555554d9, 0x0000000033333314,
  0x00000000333332b7, 0x0000000000007fe0,
  0x0000000000007f83, 0x0000000000007fdf,
  0x0000000000007f82, 0x0000000000007fde,
  0x0000000000007f81, 0x0000000000007fdd,
  0x0000000000007f80, 0x0000000000000060,
  0x0000000000000003, 0x000000000000005f,
  0x0000000000000002, 0x000000000000005e,
  0x0000000000000001, 0x000000000000005d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000005d, 0x000000000000001d,
  0x000000000000007a, 0x000000000000001e,
  0x000000000000007b, 0x000000000000001f,
  0x000000000000001f, 0x00000000fffffffd,
  0x00000000ffffffe0, 0x00000000fffffffc,
  0x00000000ffffffdf, 0x00000000fffffffb,
  0x00000000ffffffde, 0x00000000ffffffdd,
  0x00000000ffffffc0, 0x00000000ffffff80,
  0x00000000ffffff63, 0x00000000ffffff7f,
  0x00000000ffffff62, 0x00000000ffffff7e,
  0x00000000ffffff61, 0x00000000ffff8000,
  0x00000000ffff7fe3, 0x00000000ffff7fff,
  0x00000000ffff7fe2, 0x00000000ffff7ffe,
  0x00000000ffff7fe1, 0x00000000ccccccca,
  0x00000000ccccccad, 0x00000000aaaaaaa8,
  0x00000000aaaaaa8b, 0x0000000080000000,
  0x000000007fffffe3, 0x000000007fffffff,
  0x000000007fffffe2, 0x000000007ffffffe,
  0x000000007fffffe1, 0x000000007ffffffd,
  0x000000007fffffe0, 0x000000007ffffffc,
  0x000000007fffffdf, 0x0000000055555553,
  0x0000000055555536, 0x0000000033333331,
  0x0000000033333314, 0x0000000000007ffd,
  0x0000000000007fe0, 0x0000000000007ffc,
  0x0000000000007fdf, 0x0000000000007ffb,
  0x0000000000007fde, 0x0000000000007ffa,
  0x0000000000007fdd, 0x000000000000007d,
  0x0000000000000060, 0x000000000000007c,
  0x000000000000005f, 0x000000000000007b,
  0x000000000000005e, 0x000000000000007a,
  0x000000000000005d, 0x000000000000001d,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000001d, 0x0000000000000001,
  0x000000000000001e, 0x0000000000000002,
  0x0000000000000002, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000ffffffde,
  0x00000000ffffffdd, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffffff7f,
  0x00000000ffffff7e, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000ffff7fff,
  0x00000000ffff7ffe, 0x00000000cccccccb,
  0x00000000ccccccca, 0x00000000aaaaaaa9,
  0x00000000aaaaaaa8, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x0000000055555554,
  0x0000000055555553, 0x0000000033333332,
  0x0000000033333331, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffb,
  0x0000000000007ffa, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007b,
  0x000000000000007a, 0x000000000000001e,
  0x000000000000001d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x00000000ffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000ffffffdf,
  0x00000000ffffffde, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff80,
  0x00000000ffffff7f, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8000,
  0x00000000ffff7fff, 0x00000000cccccccc,
  0x00000000cccccccb, 0x00000000aaaaaaaa,
  0x00000000aaaaaaa9, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x0000000055555555,
  0x0000000055555554, 0x0000000033333333,
  0x0000000033333332, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000001f,
  0x000000000000001e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_uabdl2_2D = 961;

#endif  // VIXL_SIM_UABDL2_2D_TRACE_AARCH64_H_
