/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdk/vdkdnd.h>


VDKDnDEntry::VDKDnDEntry(VDKObject* object, VDKDnD* dnd, GtkWidget* widget):
    object(object),dnd(dnd),widget(widget)
{
}

/*
*/
VDKDnD::VDKDnD(VDKForm* owner,
            GtkTargetEntry* target_table,
            guint n_entries):
            VDKRawObject(owner),
            target_table(target_table),
            n_entries(n_entries),
            DragSource("DragSource",this,NULL),
	    DragPoint("DragPoint",this,VDKPoint(-1,-1))
{
}

/*
*/
VDKDnD::~VDKDnD()
{
// free sources and targets tables entries
VDKDnDIterator ls(sources);
for(;ls;ls++)
    delete ls.current();
VDKDnDIterator lt(targets);
for(;lt;lt++)
    delete lt.current();
}
/*
*/
void
VDKDnD::AddSource(VDKObject* source)
{
// sets source
GtkWidget* src_widget = NULL;
if(!src_widget)
    {
    VDKCustom* custom = dynamic_cast<VDKCustom*>(source);
    src_widget = custom ? custom->CustomWidget() : NULL;
    }
/*
if(!src_widget)
    {
    VDKCustom* checkbutton = dynamic_cast<VDKCustom*>(source);
    src_widget = checkbutton ? GTK_BIN(checkbutton->Widget())->child : NULL;
    }
*/
if(!src_widget)
    src_widget = source->Widget();

gtk_drag_source_set(
                   src_widget,
                   (GdkModifierType)(GDK_BUTTON1_MASK | GDK_BUTTON3_MASK),
		   target_table, n_entries,
		   GdkDragAction(GDK_ACTION_COPY |GDK_ACTION_MOVE)
                   );

VDKDnDEntry *entry = new VDKDnDEntry(source,this,src_widget);
sources.add(entry);
gtk_signal_connect (GTK_OBJECT (src_widget), "drag_data_get",
  		    GTK_SIGNAL_FUNC (VDKDnD::source_drag_data_get),
                    entry);

}
/*
*/
void
VDKDnD::AddTarget(VDKObject* target)
{
GtkWidget* src_widget = NULL;
src_widget = target->WrappedWidget();
// sets target
gtk_drag_dest_set (src_widget,
                    GTK_DEST_DEFAULT_ALL,
   		    target_table, n_entries,
                    GdkDragAction(GDK_ACTION_COPY | GDK_ACTION_MOVE) );
VDKDnDEntry *entry = new VDKDnDEntry(target,this,src_widget);
targets.add(entry);
// connect target to drop signal
gtk_signal_connect (GTK_OBJECT (src_widget), "drag_drop",
		      GTK_SIGNAL_FUNC (VDKDnD::drag_drop), entry);
gtk_signal_connect (GTK_OBJECT (src_widget), "drag_leave",
		      GTK_SIGNAL_FUNC (VDKDnD::drag_leave), entry);
gtk_signal_connect (GTK_OBJECT (src_widget), "drag_motion",
		      GTK_SIGNAL_FUNC (VDKDnD::drag_motion), entry);
}

/*
*/
gboolean
VDKDnD::drag_drop(GtkWidget	*widget,
               GdkDragContext *context,
               gint x,
               gint y,
               guint time,
               gpointer data)
{
  g_return_val_if_fail(widget != NULL, FALSE);
  g_return_val_if_fail(data != NULL, FALSE);
  VDKDnDEntry* targetdata = reinterpret_cast<VDKDnDEntry*>(data);
  if (context && context->targets)
    {
    targetdata->dnd->DragPoint(VDKPoint(x,y));
    targetdata->object->SignalEmit(dnd_dropped_signal);
    targetdata->object->SignalEmit("dnd_dropped");
    return TRUE;
    }
  return FALSE;
}

/*
*/
void
VDKDnD::source_drag_data_get(GtkWidget *widget,
                             GdkDragContext     *context,
                           	 GtkSelectionData   *selection_data,
                             guint               info,
                             guint               time,
                             gpointer            data)
{
    g_return_if_fail(widget != NULL);
    g_return_if_fail(data != NULL);
    VDKDnDEntry* sourcedata = reinterpret_cast<VDKDnDEntry*>(data);
    if (context && context->targets)
        {
        sourcedata->object->SignalEmit(dnd_get_data_signal);
        sourcedata->object->SignalEmit("dnd_get_data");
        gtk_drag_finish (context, FALSE, FALSE, time);
        sourcedata->dnd->DragSource(sourcedata->object);
        }
}
/*
*/
gboolean
VDKDnD::drag_motion	   (GtkWidget	       *widget,
			    GdkDragContext     *context,
			    gint                x,
			    gint                y,
			    guint               time,
                        gpointer data)
{
    g_return_val_if_fail(widget != NULL,FALSE);
    g_return_val_if_fail(data != NULL, FALSE);
    g_return_val_if_fail(context != NULL, FALSE);
    VDKDnDEntry* targetdata = reinterpret_cast<VDKDnDEntry*>(data);
    GtkWidget *source_widget;
    source_widget = gtk_drag_get_source_widget (context);
    // look on the source table to find source object
    targetdata->dnd->DragSource(NULL);
    VDKDnDIterator li(targetdata->dnd->sources);
    for(;li;li++)
        {
        if(li.current()->widget == source_widget)
	    {
            targetdata->dnd->DragSource(li.current()->object);
	    targetdata->dnd->DragPoint(VDKPoint(x,y));		
	    }	
	}
    targetdata->object->SignalEmit(dnd_drag_motion_signal);
    targetdata->object->SignalEmit("dnd_drag_motion");
    return TRUE;
}

void
VDKDnD::drag_leave  (GtkWidget	*widget,
                            GdkDragContext  *context,
                            guint  time,
                            gpointer data)
{
  g_return_if_fail(widget != NULL);
  g_return_if_fail(data != NULL);
  VDKDnDEntry* targetdata = reinterpret_cast<VDKDnDEntry*>(data);
  if (context && context->targets)
    {
    targetdata->object->SignalEmit(dnd_drag_leave_signal);
    targetdata->object->SignalEmit("dnd_drag_leave");
    }
}

/*
 */
void
VDKDnD::SetIcon(VDKObject* widget, VDKRawPixmap* pixmap)
{
  VDKDnDIterator li(sources);
  for(;li;li++)
    {
      if(li.current()->object == widget)
	{
	  gtk_drag_source_set_icon (li.current()->widget,
			  gtk_widget_get_colormap(li.current()->widget),
			  *pixmap, pixmap->Mask());
	  break;
	}
    }
}

/*
 */
void
VDKDnD::RemoveSource(VDKObject* source)
{
  int t = 0;
  VDKDnDIterator li(sources);
  for(;li;li++,t++)
    {
      if(li.current()->object == source)
	{
	  gtk_drag_source_unset(li.current()->widget);
	  break;
	}
    }
  if(t < sources.size())
    sources.remove(sources[t]);
}

/*
 */
void
VDKDnD::RemoveTarget(VDKObject* target)
{
  int t = 0;
  VDKDnDIterator li(targets);
  for(;li;li++,t++)
    {
      if(li.current()->object == target)
	{
	  gtk_drag_dest_unset(li.current()->widget);
	  break;
	}
    }
  if(t < targets.size())
    targets.remove(targets[t]);
}
