"""QNAP QSW library constants."""

from typing import Final

API_ANOMALY: Final[str] = "anomaly"
API_AUTHORIZATION: Final[str] = "Authorization"
API_BUILD_NUMBER: Final[str] = "buildNumber"
API_CHIP_ID: Final[str] = "ChipId"
API_CI_BRANCH: Final[str] = "ci_branch"
API_CI_COMMIT: Final[str] = "ci_commit"
API_CI_PIPELINE: Final[str] = "ci_pipeline"
API_COMMAND: Final[str] = "command"
API_COMMIT_CPSS: Final[str] = "commit_cpss"
API_COMMIT_ISS: Final[str] = "commit_iss"
API_DATE: Final[str] = "date"
API_DESCRIPTION: Final[str] = "description"
API_DONE: Final[str] = "done"
API_DOWNLOAD_SIZE: Final[str] = "downloadSize"
API_DOWNLOAD_URL: Final[str] = "downloadURL"
API_ERROR_CODE: Final[str] = "error_code"
API_ERROR_MESSAGE: Final[str] = "error_message"
API_FAN1_SPEED: Final[str] = "Fan1Speed"
API_FAN2_SPEED: Final[str] = "Fan2Speed"
API_FCS_ERRORS: Final[str] = "FCSErrors"
API_FIRMWARE_URL: Final[str] = "firmwareURL"
API_FIRMWARE_SIZE: Final[str] = "firmwareSize"
API_FULL_DUPLEX: Final[str] = "FullDuplexStatus"
API_KEY: Final[str] = "key"
API_LINK: Final[str] = "Link"
API_LIVE: Final[str] = "live"
API_MAC_ADDR: Final[str] = "MacAddr"
API_MAX_PORT_CHANNELS: Final[str] = "MaxPortChannels"
API_MAX_PORTS_PER_PORT_CHANNEL: Final[str] = "MaxPortsPerPortChannel"
API_MAX_SWITCH_TEMP: Final[str] = "MaxSwitchTemp"
API_MESSAGE: Final[str] = "message"
API_MODEL: Final[str] = "Model"
API_NEWER: Final[str] = "newer"
API_NONE: Final[str] = "None"
API_NUMBER: Final[str] = "number"
API_PASSWORD: Final[str] = "password"
API_QSW_ID: Final[str] = "QSW_ID"
API_QSW_LANG: Final[str] = "QSW_LANG"
API_PATH: Final[str] = "api"
API_PATH_V1: Final[str] = "api/v1"
API_PRODUCT: Final[str] = "Product"
API_PROGRESS: Final[str] = "progress"
API_PORT_NUM: Final[str] = "PortNum"
API_PUB_DATE: Final[str] = "pubDate"
API_REBOOT: Final[str] = "reboot"
API_RESULT: Final[str] = "result"
API_RX_ERRORS: Final[str] = "RxErrors"
API_RX_OCTETS: Final[str] = "RxOctets"
API_SERIAL: Final[str] = "SerialNumber"
API_SPEED: Final[str] = "Speed"
API_START_INDEX: Final[str] = "StartIndex"
API_STATUS: Final[str] = "Status"
API_SWITCH_TEMP: Final[str] = "SwitchTemp"
API_TRUNK_NUM: Final[str] = "TrunkNum"
API_TX_OCTETS: Final[str] = "TxOctets"
API_UPTIME: Final[str] = "UpTime"
API_USERNAME: Final[str] = "username"
API_VAL: Final[str] = "val"
API_VERSION: Final[str] = "version"

API_ERROR_PARSING_FAILED: Final[int] = 6

HTTP_CALL_TIMEOUT: Final[int] = 20
HTTP_MAX_REQUESTS: Final[int] = 6

QSD_ANOMALY: Final[str] = "anomaly"
QSD_BUILD_NUMBER: Final[str] = "build-number"
QSD_CHIP_ID: Final[str] = "chip-id"
QSD_CI_BRANCH: Final[str] = "ci-branch"
QSD_CI_COMMIT: Final[str] = "ci-commit"
QSD_CI_PIPELINE: Final[str] = "ci-pipeline"
QSD_COMMIT_CPSS: Final[str] = "commit-cpss"
QSD_COMMIT_ISS: Final[str] = "commit-iss"
QSD_DATE: Final[str] = "date"
QSD_DATETIME: Final[str] = "datetime"
QSD_DESCRIPTION: Final[str] = "description"
QSD_DOWNLOAD_URLS: Final[str] = "download-urls"
QSD_FAN1_SPEED: Final[str] = "fan1-speed"
QSD_FAN2_SPEED: Final[str] = "fan2-speed"
QSD_FCS_ERRORS: Final[str] = "fcs-errors"
QSD_FIRMWARE: Final[str] = "firmware"
QSD_FIRMWARE_CHECK: Final[str] = "firmware-check"
QSD_FIRMWARE_CONDITION: Final[str] = "firmware-condition"
QSD_FIRMWARE_INFO: Final[str] = "firmware-info"
QSD_FULL_DUPLEX: Final[str] = "full-duplex"
QSD_ID: Final[str] = "id"
QSD_LACP_PORT_NUM: Final[str] = "lacp-port-num"
QSD_LACP_PORTS: Final[str] = "lacp-ports"
QSD_LINK: Final[str] = "link"
QSD_MAC: Final[str] = "mac"
QSD_MAX_CHANNEL_PORTS: Final[str] = "max-channel-ports"
QSD_MAX_CHANNELS: Final[str] = "max-channels"
QSD_MESSAGE: Final[str] = "message"
QSD_MODEL: Final[str] = "model"
QSD_NEWER: Final[str] = "newer"
QSD_NUMBER: Final[str] = "number"
QSD_PORT_NUM: Final[str] = "port-num"
QSD_PORTS: Final[str] = "ports"
QSD_PORTS_STATISTICS: Final[str] = "ports-statistics"
QSD_PORTS_STATUS: Final[str] = "ports-status"
QSD_PRODUCT: Final[str] = "product"
QSD_PUB_DATE: Final[str] = "pub-date"
QSD_RX_ERRORS: Final[str] = "rx-errors"
QSD_RX_OCTETS: Final[str] = "rx-octets"
QSD_RX_SPEED: Final[str] = "rx-speed"
QSD_TX_OCTETS: Final[str] = "tx-octets"
QSD_TX_SPEED: Final[str] = "tx-speed"
QSD_SERIAL: Final[str] = "serial"
QSD_SPEED: Final[str] = "speed"
QSD_START_ID: Final[str] = "start-id"
QSD_START_INDEX: Final[str] = "start-index"
QSD_SYSTEM_BOARD: Final[str] = "system-board"
QSD_SYSTEM_SENSOR: Final[str] = "system-sensor"
QSD_SYSTEM_TIME: Final[str] = "system-time"
QSD_TEMP: Final[str] = "temperature"
QSD_TEMP_MAX: Final[str] = "max-temperature"
QSD_UPTIME_SECONDS: Final[str] = "uptime-seconds"
QSD_UPTIME_TIMESTAMP: Final[str] = "uptime-timestamp"
QSD_TRUNK_NUM: Final[str] = "trunk-num"
QSD_VERSION: Final[str] = "version"

RAW_FIRMWARE_CHECK: Final[str] = "firmware-check"
RAW_FIRMWARE_CONDITION: Final[str] = "firmware-condition"
RAW_FIRMWARE_INFO: Final[str] = "firmware-info"
RAW_LACP_INFO: Final[str] = "lacp-info"
RAW_PORTS_STATISTICS: Final[str] = "ports-statistics"
RAW_PORTS_STATUS: Final[str] = "ports-status"
RAW_SYSTEM_BOARD: Final[str] = "system-board"
RAW_SYSTEM_SENSOR: Final[str] = "system-sensor"
RAW_SYSTEM_TIME: Final[str] = "system-time"
