# Error - The DOSBox image disk was not found
# USAGE: error_dosbox_disk_image_no_found $disk_image
error_dosbox_disk_image_no_found() {
	local disk_image
	disk_image="$1"

	local messages_language message
	messages_language=$(messages_language)
	case "$messages_language" in
		('fr')
			message='Lʼimage de disque suivante nʼa pas été trouvée : %s\n'
		;;
		('en'|*)
			message='The following disk image could not be found: %s\n'
		;;
	esac
	print_message 'error' "$message" \
		"$disk_image"
}

# Error - The DOSBox image disk type is invalid.
# USAGE: error_dosbox_disk_image_type_invalid $disk_image_path $disk_image_type
error_dosbox_disk_image_type_invalid() {
	local disk_image_path disk_image_type
	disk_image_path=$1
	disk_image_type=$2

	local messages_language message
	messages_language=$(messages_language)
	case "$messages_language" in
		('fr')
			message='Lʼimage de disque "%s" a un type invalide : %s\n'
			message="$message"'Seuls les types suivants sont acceptés :\n'
		;;
		('en'|*)
			message='The disk image "%s" is assigned an invalid type: %s\n'
			message="$message"'Only the following types are accepted:\n'
		;;
	esac
	print_message 'error' "$message" \
		"$disk_image_path" \
		"$disk_image_type"
	printf -- '- %s\n' 'cdrom' 'iso' >/dev/stderr
}

