/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import org.broad.igv.ui.util.Packable;
import org.broad.igv.ui.util.UIUtilities;

import javax.swing.*;
import java.awt.*;

/**
 * A panel class specific to the IGV main window.  Lays out its components in a very specific way so that
 * children (i.e. name, attribute, and data panels) from all instances align vertically
 */
public class IGVPanel extends JPanel {

    public static int X_SPACING_BETWEEN_COMPONENTS = 10;

    private String viewName = "IGVPanel";

    public int getViewportHeight() {

        Container parent = getParent();
        return parent == null ? 0 : parent.getHeight();
    }

    /**
     * Scrollpane height
     *
     * @return
     */
    public int getScrollPaneHeight() {

        int height = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            height = ((JViewport) parent).getParent().getHeight();
        } else {
            height = parent.getHeight();
        }

        return height;
    }

    public int getViewportWidth() {

        int width = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            width = (int) ((JViewport) parent).getViewSize().getWidth();
        } else {
            width = parent.getWidth();
        }

        return width;
    }


    public JViewport getViewport() {

        JViewport viewport = null;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            viewport = ((JViewport) parent);
        }
        return viewport;
    }

    public JScrollPane getScrollPane() {

        JScrollPane scollpane = null;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            scollpane = (JScrollPane) ((JViewport) parent).getParent();
        }
        return scollpane;
    }

    public void setHeight(int height) {

        if (height < 0) {
            height = 0;
        }

        // First resize itself
        final Dimension dimension = new Dimension(getWidth(), height);
        setSize(dimension);
        setPreferredSize(dimension);

        // Then resize its children
        Component[] children = getComponents();
        for (final Component child : children) {

            final Dimension childDimension =
                    new Dimension(child.getWidth(), height);

            UIUtilities.invokeOnEventThread(new Runnable() {

                public void run() {
                    child.setSize(childDimension);
                    child.setPreferredSize(childDimension);
                }
            });
        }
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void packView() {

        UIUtilities.invokeOnEventThread(new Runnable() {

            public void run() {

                Integer attributePanelEnd = null;
                int width = 0;

                // Pack the attribute panels
                Component[] children = getComponents();
                for (final Component child : children) {
                    if (child instanceof Packable) {
                        ((Packable) child).packComponent();

                        if (attributePanelEnd == null) {
                            int x = child.getX();
                            width = child.getWidth();
                            attributePanelEnd = new Integer(x + width);
                        }
                    }
                }

                // Change Track and Header panel X location
                if (attributePanelEnd != null) {

                    children = getComponents();
                    for (final Component child : children) {

                        if (child instanceof DataPanel ||
                                child instanceof HeaderPanel) {

                            if (width > 0) {
                                attributePanelEnd += X_SPACING_BETWEEN_COMPONENTS;
                            }
                            child.setLocation((attributePanelEnd), child.getY());
                        }
                    }
                }

            }
        });
    }
}
