/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xmlresume.filter;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.xml.utils.StringVector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class TargetFilter
extends XMLFilterImpl {
    Stack elements;
    String excludedElement;
    StringVector targets;
    XMLReader parent;
    DefaultHandler dh;
    Locator locator;
    Hashtable availableTargets = null;
    private static final int ERROR = 10;
    private static final int WARN = 5;
    private static final int DEBUG = 1;
    int debugLevel = 10;
    public static final String TARGETS_ATTR = "targets";
    public static final String OR_OP_CHARS = "|,";
    public static final String AND_OP_CHARS = "+";

    public TargetFilter(XMLReader parent, Iterator targets) {
        super(parent);
        this.parent = parent;
        parent.setContentHandler(this);
        parent.setErrorHandler(this);
        parent.setDTDHandler(this);
        parent.setEntityResolver(this);
        this.elements = new Stack();
        this.targets = new StringVector();
        this.availableTargets = new Hashtable();
        while (targets.hasNext()) {
            this.targets.push((String)targets.next());
        }
    }

    public TargetFilter(XMLReader parent, Iterator targets, int debugLevel) {
        this(parent, targets);
        this.debugLevel = debugLevel;
    }

    public void parse(File f, DefaultHandler dh) throws SAXException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (dh == null) {
            throw new IllegalArgumentException("DefaultHandler cannot be null");
        }
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource input = new InputSource(uri);
        this.dh = dh;
        this.setContentHandler(dh);
        this.setErrorHandler(dh);
        this.setDTDHandler(dh);
        this.setEntityResolver(dh);
        this.parent.parse(input);
    }

    public void startDocument() throws SAXException {
        this.debug("Received startdocument event");
        this.dh.startDocument();
    }

    public void endDocument() throws SAXException {
        if (!this.elements.isEmpty()) {
            if (!this.elements.isEmpty()) {
                throw new SAXException("Element " + (String)this.elements.pop() + " was not closed");
            }
        }
        String s = "\n\n<!-- AVAILABLE TARGETS:";
        Enumeration e = this.availableTargets.elements();
        while (e.hasMoreElements()) {
            s = s + " " + (String)e.nextElement();
        }
        s = s + " -->\n<!-- ACCEPTED TARGETS:";
        int i = 0;
        while (i < this.targets.size()) {
            s = s + " " + this.targets.elementAt(i);
            ++i;
        }
        s = s + " -->\n";
        this.dh.characters(s.toCharArray(), 0, s.length());
        this.dh.endDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String targetList = attributes.getValue(TARGETS_ATTR);
        boolean accept = false;
        if (targetList != null && !targetList.equals("")) {
            StringTokenizer orTok = new StringTokenizer(targetList, OR_OP_CHARS);
            while (orTok.hasMoreTokens()) {
                boolean acceptAndClause = true;
                StringTokenizer andTok = new StringTokenizer(orTok.nextToken(), AND_OP_CHARS);
                while (andTok.hasMoreTokens()) {
                    String s = andTok.nextToken();
                    this.availableTargets.put(s, s);
                    acceptAndClause = acceptAndClause && this.targets.containsIgnoreCase(s);
                    this.debug("string='" + s + "', acceptAndClause=" + acceptAndClause);
                }
                boolean bl = accept = accept || acceptAndClause;
            }
            if (this.excludedElement == null && !accept) {
                this.excludedElement = qName;
            }
        }
        if (this.excludedElement == null) {
            this.elements.push(qName);
            AttributesImpl attrsMinusTargets = new AttributesImpl(attributes);
            int targetsIdx = attrsMinusTargets.getIndex(TARGETS_ATTR);
            if (targetsIdx != -1) {
                attrsMinusTargets.removeAttribute(targetsIdx);
            }
            this.dh.startElement(uri, localName, qName, attrsMinusTargets);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.excludedElement != null) {
            if (qName.equals(this.excludedElement)) {
                this.excludedElement = null;
            }
            return;
        }
        if (this.elements.isEmpty()) {
            throw new SAXParseException("Element " + qName + " has no corresponding open tag", this.locator);
        }
        String openTag = (String)this.elements.pop();
        if (!qName.equals(openTag)) {
            throw new SAXException("Closing element " + qName + "is mismatched with open element " + openTag);
        }
        this.dh.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        if (this.excludedElement == null) {
            if (this.elements.isEmpty()) {
                this.dh.warning(new SAXParseException("Data appears outside tags: \n" + data + "\n\tThey will be ignored.", this.locator));
            } else {
                this.dh.characters(ch, start, length);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.excludedElement == null) {
            this.dh.ignorableWhitespace(ch, start, length);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.debug("Received notationDecl Event:\n\tname: " + name + "\n\tpublicId: " + publicId + " \n\tsystemId: " + systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.debug("Received unparsedEntityDecl Event:\n\tname: " + name + "\n\tpublicId: " + publicId + "\n\tsystemId: " + systemId + "\n\tnotationName: " + notationName);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.dh != null) {
            this.dh.setDocumentLocator(locator);
        }
    }

    private void debug(String msg) {
        this.debug(msg, 1);
    }

    private void debug(String msg, int severity) {
        if (severity >= this.debugLevel) {
            System.err.println(msg);
        }
    }
}

