#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import sys
from winswitch.util.simple_logger import set_log_filename, set_log_dir, set_log_to_file, set_log_to_tty, all_to_file


def usage():
	print("Usage: %s" % sys.argv[0])
	print("")
	print("  -h   --help            Usage information")
	print("  -l   --log-to-file     Log messages to file")
	print("  --version              Print version information and exit")
	set_log_to_file(False)
	set_log_to_tty(False)
	from winswitch.objects.common import add_argv_usage
	from winswitch.objects.global_settings import GlobalSettings
	add_argv_usage(GlobalSettings(skip_detection=True))
	print("")

def stdout():
	set_log_to_file(False)
	set_log_to_tty(True)


def parse_args():
	args = sys.argv
	if sys.stdout.isatty() and not ("-l" in args or "--log-to-file" in args):
		stdout()
	else:
		all_to_file()
	if "-h" in args or "--help" in args:
		usage()
		return	False
	if "--version" in sys.argv:
		import winswitch.globals			#ensure it is imported from the top level class
		assert winswitch.globals.USERNAME	#ensures that the line above doesn't trigger a pydev warning
		from winswitch.util.version_info import print_version_info
		print_version_info()
		return	False
	return	True

def main():
	from winswitch.util.paths import CLIENT_DIR, CLIENT_LOG
	set_log_dir(CLIENT_DIR)
	set_log_filename(CLIENT_LOG)
	if not parse_args():
		return
	from winswitch.client.client import main
	code = main()
	sys.exit(code)

if __name__ == "__main__":
	main()
