'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) spinint.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS spinint iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
spinint \- Create and manipulate a integer spinner widget
.SH SYNOPSIS
\fBspinint\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- Spinner <- Spinint
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBexportSelection\fR
\fBforeground\fR	\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR
\fBinsertBorderWidth\fR	\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR
\fBjustify\fR	\fBrelief\fR	\fBselectBackground\fR	\fBselectBorderWidth\fR
\fBselectForeground\fR	\fBtextVariable\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBshow\fR	\fBstate\fR
.fi
.LP
See the "entry" manual entry for details on the associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBcommand\fR	\fBchildSitePos\fR	\fBfixed\fR	\fBfocusCommand\fR
\fBinvalid\fR	\fBtextBackground\fR	\fBtextFont\fR	\fBvalidate\fR
\fBwidth\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBarroworient\fR	\fBdecrement\fR	\fBincrement\fR	\fBrepeatDelay\fR
\fBrepeatInterval\fR
.fi
.LP
See the "spinner" widget manual entry for details on the above 
inherited options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBrange\fR
Class:	\fBRange\fR
Command-Line Switch:	\fB-range\fR
.fi
.IP
Specifies a two element list of minimum and maximum integer values.  The
default is no range, {{} {}}.
.LP
.nf
Name:	\fBstep\fR
Class:	\fBStep\fR
Command-Line Switch:	\fB-step\fR
.fi
.IP
Specifies the increment/decrement value.  The default is 1.
.LP
.nf
Name:	\fBwrap\fR
Class:	\fBWrap\fR
Command-Line Switch:	\fB-wrap\fR
.fi
.IP
Specifies whether to wrap the spinner value upon reaching the minimum
or maximum value in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBspinint\fR command creates a spinint widget.  The spinint allows
"spinning" of integer values within a specified range with wrap support.
The spinner arrows may be drawn horizontally or vertically.
.DE

.SH "METHODS"
.PP
The \fBspinint\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for spinint widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBdelete\fR	\fBget\fR	\fBicursor\fR	\fBindex\fR	
\fBinsert\fR	\fBpeek\fR	\fBscan\fR	\fBselection\fR
\fBxview\fR	
.fi
.LP
See the "entry" manual entry for details on the associated methods.
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBchildsite\fR	\fBclear\fR
.fi
.LP
See the "entryfield" manual entry for details on the associated methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBspinint\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBspinint\fR
command.
.TP
\fIpathName \fBdown\fR
Decrement the spinner value by the value given in the step option.
.TP
\fIpathName \fBup\fR
Increment the spinner value by the value given in the step option.

.SH "COMPONENTS"
.IP
See the "Spinner" widget manual entry for details on the integer spinner
component items.

.SH EXAMPLE
.DS
 option add *textBackground white
 
 spinint .si -labeltext "Temperature" -labelpos w \\
    -fixed yes -width 5 -range {32 212}

 pack .si -pady 10
.DE
.SH AUTHOR
Sue Yockey
.SH KEYWORDS
spinint, widget
