/*
 * Path.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "Path.h"
#include "Scene.h"
#include "SFNode.h"
#include "MFNode.h"
#include "Proto.h"
#include "Field.h"

Path::Path(const int *path, int len, Scene *scene)
{
    Node	*node, *parent = NULL;
    int		 field = -1, parentField = -1;

    _field = -1;
    _path = NULL;
    _len = len;

    node = scene->getRoot();

    if (len > 0) {
	_path = new int[_len];
	memcpy(_path, path, _len * sizeof(int));
	for (int i = 0; i < _len;) {
	    field = path[i++];
    	    FieldValue  *value = node->getField(field);
            // shorten path for inlined nodes
            if (node->getType() == NODE_INLINE) {
                _len = i;
                _field = field;
                break;
            }
	    if (i < _len) {
               if (path[i] == -1)
                   _len = i;

	    } else {
		_field = field;
		break;
	    }

	    parent = node;
	    parentField = field;
	    if (value->getType() == SFNODE) {
		node = ((SFNode *) value)->getValue(); i++;
	    } else if (value->getType() == MFNODE) {
		node = ((MFNode *) value)->getValue(path[i++]);
	    } else {
                fprintf(stderr, "strange type in path: %s depth %d field %d\n",
                        typeEnumToString(value->getType()), i, field);
		assert(0);
	    }
            if (node != NULL)
	        _nodes.append(node);
	}
    }
    _node = node;
    _parent = parent;
    _parentField = parentField;
}

Path::~Path()
{
    delete [] _path;
}

#if 0
void
Path::dump() const
{
    Scene   *scene = _node->getScene();

    int	    len = _path.size();

    swDebugf("scene");
    Node *node = scene->getRoot();
    for (int i = 0; i < len;) {
	swDebugf(".%s", (const char *) node->getProto()->getField(_path[i])->getName());
    	FieldValue  *value = node->getField(_path[i++]);
      if (i >= len) break;
	if (value->getType() == SFNODE) {
	    node = ((SFNode *) value)->getValue();  i++;
	} else if (value->getType() == MFNODE) {
	    node = ((MFNode *) value)->getValue(_path[i++]);
	}
	if (node) swDebugf(".%s", (const char *) node->getProto()->getName());
    }
    swDebugf("\n");
}
#endif
