/*
 * NodeSuperShape.h
 *
 * Copyright (C) 1999 Stephen F. White, 2004 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_SUPER_SHAPE_H
#define _NODE_SUPER_SHAPE_H

#ifndef _MESH_BASED_NODE_H
#include "MeshBasedNode.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class Mesh;

class ProtoSuperShape : public Proto {
public:
		    ProtoSuperShape(Scene *scene);
    virtual Node   *create(Scene *scene);
    FieldIndex      ua;
    FieldIndex      ub;
    FieldIndex      um;
    FieldIndex      un1;
    FieldIndex      un2;
    FieldIndex      un3;
    FieldIndex      va;
    FieldIndex      vb;
    FieldIndex      vm;
    FieldIndex      vn1;
    FieldIndex      vn2;
    FieldIndex      vn3;
    FieldIndex      border;
    FieldIndex      creaseAngle;
    FieldIndex      texCoord;
    FieldIndex      uTessellation;
    FieldIndex      vTessellation;    
};

class NodeSuperShape : public MeshBasedNode {
public:
		    NodeSuperShape(Scene *scene, Proto *proto);
		    ~NodeSuperShape();
    virtual int	    getType() const { return NODE_SUPER_SHAPE; }
    virtual Node   *copy() const { return new NodeSuperShape(*this); }
    virtual int	    getNodeClass() const { return PARAMETRIC_GEOMETRY_NODE; }

    virtual void    setField(int index, FieldValue *value);

    virtual bool    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    virtual Node   *toNurbs(int uTess,  int vTess, int uDegree, int vDegree);

    fieldMacros(SFFloat, ua,            ProtoSuperShape)
    fieldMacros(SFFloat, ub,            ProtoSuperShape)
    fieldMacros(SFFloat, um,            ProtoSuperShape)
    fieldMacros(SFFloat, un1,           ProtoSuperShape)
    fieldMacros(SFFloat, un2,           ProtoSuperShape)
    fieldMacros(SFFloat, un3,           ProtoSuperShape)
    fieldMacros(SFFloat, va,            ProtoSuperShape)
    fieldMacros(SFFloat, vb,            ProtoSuperShape)
    fieldMacros(SFFloat, vm,            ProtoSuperShape)
    fieldMacros(SFFloat, vn1,           ProtoSuperShape)
    fieldMacros(SFFloat, vn2,           ProtoSuperShape)
    fieldMacros(SFFloat, vn3,           ProtoSuperShape)
    fieldMacros(SFFloat, border,        ProtoSuperShape)
    fieldMacros(SFFloat, creaseAngle,   ProtoSuperShape)
    fieldMacros(SFNode,  texCoord,      ProtoSuperShape)
    fieldMacros(SFInt32, uTessellation, ProtoSuperShape)
    fieldMacros(SFInt32, vTessellation, ProtoSuperShape)
protected:
    void	    createMesh();
    float           superellipse1xy(float angle1);
    float           superellipse1z(float angle1);
    float           superellipse2x(float angle2);
    float           superellipse2y(float angle2);
};

#endif // _NODE_SUPER_SHAPE_H
