/*
 * NodeAudioClip.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_AUDIOCLIP_H
#define _NODE_AUDIOCLIP_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoAudioClip : public Proto {
public:
		    ProtoAudioClip(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex description;
    FieldIndex loop;
    FieldIndex pitch;
    FieldIndex startTime;
    FieldIndex stopTime;
    FieldIndex url;
};

class NodeAudioClip : public Node {
public:
		    NodeAudioClip(Scene *scene, Proto *proto);

    virtual Node   *copy() const { return new NodeAudioClip(*this); }
    virtual int	    getType() const { return NODE_AUDIO_CLIP; }
    virtual int	    getNodeClass() const 
                       { 
                       return SOUND_SOURCE_NODE | URL_NODE; 
                       }

    virtual bool    isInvalidChildNode(void) { return true; }

    fieldMacros(SFString, description, ProtoAudioClip)
    fieldMacros(SFBool,   loop,        ProtoAudioClip)
    fieldMacros(SFFloat,  pitch,       ProtoAudioClip)
    fieldMacros(SFTime,   startTime,   ProtoAudioClip)
    fieldMacros(SFTime,   stopTime,    ProtoAudioClip)
    fieldMacros(MFString, url,         ProtoAudioClip)
};

#endif // _NODE_AUDIOCLIP_H
