
// tcalcmain.cpp
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King

#include "tcalc.h"
#include <qapplication.h>
#include <qvariant.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <q3listbox.h>
#include <q3groupbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <q3popupmenu.h>
#include <q3toolbar.h>
#include <qdialog.h>

void thresholdCalculator_help();

int main( int argc, char ** argv )
{
  QApplication a(argc,argv);
  thresholdCalculator tc;
  if (argc > 0) {
     if (strcmp(argv[argc-1], "-h")==0) {
        thresholdCalculator_help();
        exit(0);
     }
     for (int i = 1; i <= (argc-1); i++) {
         if (strcmp(argv[i], "-v")==0) {
            i++;
            tc.gnvar = atol(argv[i]);
            continue;
         }
         if (strcmp(argv[i], "-k")==0) {
            i++;
            tc.gnconj = atol(argv[i]);
            continue;
         }
         if (strcmp(argv[i], "-e")==0) {
            i++;
            tc.gPValExtent = atof(argv[i]); 
            continue;
         }
         if (strcmp(argv[i], "-c")==0) {
            i++;
            tc.gClusterThreshold = atof(argv[i]);
            continue;
         }
         if (strcmp(argv[i], "-w1")==0) {
            i++;
            tc.gdfw1 = atof(argv[i]);
            continue;
         }
         if (strcmp(argv[i], "-w2")==0) {
            i++;
            tc.gdfw2 = atof(argv[i]);
            continue;
         }       
     }
  }
  QFont font( "SansSerif", 10, 0 );
  font.setStyleHint( QFont::SansSerif );
  a.setFont( font );
  tc.setFont( font );
  a.setMainWidget(&tc);
  tc.show();
                                                                                                                   
  a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
  return a.exec();
}

void
thresholdCalculator_help()
{
  printf("\nVoxBo thresholdCalculator (v%s)\n",vbversion.c_str());
  printf("summary: ");
  printf(" calculates Bonferroni and Gaussian t or F threshold values \n");
  printf("                                                                  \n");
  printf("usage:\n");
  printf("          vbtcalc [flags]                                    \n" );
  printf("flags:\n");
  printf("          -v   set number of variables (default is 1)  \n");
  printf("          -k   set number of conjunctions (default is 1) \n");
  printf("          -e   set the p value extent (default is .05)                           \n");
  printf("          -c   set cluster threshold (default is .001)  \n");
  printf("          -w1  set dfw1 (default is inf)  \n");
  printf("          -w2  set dfw2 (default is inf)  \n");
  printf("          -h   help/usage screen appears \n");
  printf("\n");
}

