/*
                                 V3D Texture
 */

#ifndef V3DTEX_H
#define V3DTEX_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/*
 *	Texture format codes.
 */
#define V3D_TEX_FORMAT_RGB		0
#define V3D_TEX_FORMAT_RGBA		1
#define V3D_TEX_FORMAT_LUMINANCE	2

/*
 *	Texture reference structure:
 */
typedef struct {

	char *name;		/* Reference name (any arbitary name)
				 * must be first member of this struct.
				 */
	char *filename;		/* Full path file name. */

	double priority;	/* Texture memory residency priority, valid
				 * values from 0.0 to 1.0 (1.0 is highest
				 * priority).
				 */

	void **data;            /* Array of GL id's for each texture. */
	int total_frames;	/* Number of textures (size of member data. */

	int width, height;	/* Size of each frame in pixels. */

	int dimensions;		/* 1, 2, or 3. */

} v3d_texture_ref_struct;

extern void V3DTextureSelectFrame(v3d_texture_ref_struct *t, int frame_num);
extern void V3DTextureSelect(v3d_texture_ref_struct *t);
extern v3d_texture_ref_struct *V3DTextureLoadFromFile2D(
	const char *path,	/* Filename containing texture data. */
	const char *name,	/* Name of texture for referancing. */
	int dest_fmt,		/* Destination data format. */
	void *client_data,
	int (*progress_cb)(void *, int, int)
);
extern v3d_texture_ref_struct *V3DTextureLoadFromData1D(
        const void *data,	/* Texture data. */
        const char *name,	/* Name of texture for referancing. */
        int width,
        int bits_per_pixel,	/* Actual bits per pixel or data. */
        int dest_fmt,		/* One of V3D_TEX_FORMAT_*. */
        void *client_data,
	int (*progress_cb)(void *, int, int)
);
extern v3d_texture_ref_struct *V3DTextureLoadFromData2D(
        const void *data,       /* Texture data. */
        const char *name,       /* Name of texture for referancing. */
        int width, int height,
        int bits_per_pixel,     /* Actual bits per pixel or data. */
        int dest_fmt,           /* One of V3D_TEX_FORMAT_*. */
        void *client_data,
        int (*progress_cb)(void *, int, int)
);
extern void V3DTexturePriority(v3d_texture_ref_struct *t, double priority);
extern void V3DTextureDestroy(v3d_texture_ref_struct *t);


#ifdef __cplusplus
}  
#endif /* __cplusplus */

#endif	/* V3DTEX_H */
