/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef BOX_H
#define BOX_H

#include <visu_extension.h>
#include <visu_tools.h>

/**
 * initExtensionBox
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the %listInitExtensionFunc to
 * be called automatically by the initOpenGLExtensions() at V_Sim
 * startup.
 *
 * Returns: a pointer to the OpenGLExtension it created or
 * NULL otherwise.
 */
OpenGLExtension* initExtensionBox();

/**
 * EXT_BOX_ID:
 *
 * The id used to identify this extension, see
 * OpenGLExtensionRebuild_list() for instance.
 */
#define EXT_BOX_ID "Box"

/**
 * boxSet_RGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter box_color.
 *
 * Returns: TRUE if boxDraw() should be called.
 */
gboolean boxSet_RGBValues(float rgb[3], int mask);
/**
 * boxSet_lineWidth:
 * @width: value of the desired box line width.
 *
 * Method used to change the value of the parameter box_line_width.
 *
 * Returns: TRUE if boxDraw() should be called.
 */
gboolean boxSet_lineWidth(float width);
/**
 * boxSet_isOn:
 * @value: 1 if box must be drawn, 0 otherwise.
 *
 * Method used to change the value of the parameter box_is_on.
 *
 * Returns: TRUE if boxDraw() should be called.
 */
gboolean boxSet_isOn(int value);
/**
 * boxSet_lineStipple:
 * @stipple: a pattern for line stipple in OpenGL.
 *
 * Method used to change the value of the parameter box_line_stipple
 * (main part).
 *
 * Returns: TRUE if boxDraw() should be called.
 */
gboolean boxSet_lineStipple(guint16 stipple);
/**
 * boxSet_expandStipple:
 * @stipple: a pattern for line stipple in OpenGL.
 *
 * Method used to change the value of the parameter box_line_stipple
 * (expanded part).
 *
 * Returns: TRUE if boxDraw() should be called.
 */
gboolean boxSet_expandStipple(guint16 stipple);

/**
 * boxGet_RGBValues:
 *
 * Read the colour components of box (in [0;1]). 
 *
 * Returns: all the colour values of the current box line.
 */
float* boxGet_RGBValues();
/**
 * boxGet_isOn:
 *
 * Read if the box is drawn or not.
 *
 * Returns: 1 if a box is drawn, 0 otherwise.
 */
int boxGet_isOn();
/**
 * boxGet_lineWidth:
 *
 * Read the line width used for box.
 *
 * Returns: the value of current box line width.
 */
float boxGet_lineWidth();
/**
 * boxGet_lineStipple:
 *
 * Read the line stipple pattern used for box (main part).
 *
 * Returns: the value of current box line pattern.
 */
guint16 boxGet_lineStipple();
/**
 * boxGet_expandStipple:
 *
 * Read the line stipple pattern used for box (expanded part).
 *
 * Returns: the value of current box line pattern.
 */
guint16 boxGet_expandStipple();
/**
 * boxDraw:
 * @data: a #VisuData object.
 *
 * This method create a compile list that draw a box for the given @data.
 */
void boxDraw(VisuData *data);

#endif
