#!/bin/sh
#-*- mode: Tcl;time-stamp-start:"TimeStamp[ 	]+\\\\?[\"<]+";-*-
# the next line restarts using wish \
exec wish $0 -- $@
set TimeStamp "2006-07-03 22:14:03 poser"
#
# Copyright (C) 2005, 2006 William J. Poser (billposer@alum.mit.edu)
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# A copy of the GNU General Public License is contained in the
# procedure "License" in this file.
# If it is not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# or go to the web page:  http://www.gnu.org/licenses/gpl.txt.

set Version "3.9.4";
encoding system utf-8
set DebugP 0;				# General debugging?
package require tablelist
package require msgcat
proc _ {s} {return [::msgcat::mc $s]};	# Define shorthand for gettext
set NonBinPath [file join /usr share uni2ascii];
fconfigure stdout -encoding utf-8

#set ColorSpecs(AsciiOptionEven,Background)	"\#E9C8AC"
set ColorSpecs(AsciiOptionEven,Background)	"\#d7c7ff"
set ColorSpecs(AsciiOptionOdd,Background)	"\#ffbb9f"
set ColorSpecs(BalloonHelp,Background)		white
set ColorSpecs(BalloonHelp,Foreground)		blue
set ColorSpecs(Button,Background)		"\#8BD664"
set ColorSpecs(Button,Foreground)		black
set ColorSpecs(Button,ActiveBackground)		LightBlue
set ColorSpecs(Button,ActiveForeground)		red
set ColorSpecs(CheckButton,ActiveForeground)	red
set ColorSpecs(CheckButton,ActiveBackground)	LightBlue
set ColorSpecs(CheckButton,Select)	red
#set ColorSpecs(Default,Background)		"\#DEDEFF"
set ColorSpecs(Default,Background)		"\#aff3b1"
set ColorSpecs(DefaultActive,Background)	"\#d4e4fe";
set ColorSpecs(Entry,Background)	"navajo white"
set ColorSpecs(Entry,DisabledBackground)		blue
set ColorSpecs(LabelText,Foreground)		"\#d4e4fe";
set ColorSpecs(ListHeader,Background)	"\#CBD7FF"
set ColorSpecs(ListHeader,Foreground)	black
set ColorSpecs(ListHeader,ActiveBackground)	"\#8f89fe";
set ColorSpecs(ListHeader,ActiveForeground)	black
set ColorSpecs(MainFrame,Background)		grey15
set ColorSpecs(Menu,ActiveBackground)	        salmon;
set ColorSpecs(Menu,ActiveForeground)	        maroon
set ColorSpecs(Menu,Background)			azure3
set ColorSpecs(Menu,Foreground)			black
set ColorSpecs(Menu,Select)			coral
set ColorSpecs(Menubar,ActiveBackground)	RoyalBlue2
set ColorSpecs(Menubar,ActiveForeground)	red
set ColorSpecs(Menubar,Background)	 	"\#c36176";
set ColorSpecs(Menubar,Foreground)		"\#fee4a9";
set ColorSpecs(Messages,Background) 		NavajoWhite
set ColorSpecs(Messages,Foreground) 		"\#000000";
set ColorSpecs(RadioButton,Background) "\#A0A0FF"
set ColorSpecs(RadioButton,ActiveForeground)	red
set ColorSpecs(RadioButton,ActiveBackground)	LightBlue
set ColorSpecs(RadioButton,SelectedBackground) red
set ColorSpecs(RadioButton,Select)	red
set ColorSpecs(UserTextEntry,Background)	"\#ffaf80"
set ColorSpecs(UserTextEntry,Foreground)	black
set ColorSpecs(TableList,SelectBackground)	"\#FFCFBF"
set ColorSpecs(TableList,SelectForeground)	black

option add *Background $ColorSpecs(Default,Background)
option add *Balloonhelp*background $ColorSpecs(BalloonHelp,Background) 80
option add *Balloonhelp*foreground $ColorSpecs(BalloonHelp,Foreground) 80
option add *Button.Background  $ColorSpecs(Button,Background)
option add *Button.Foreground  $ColorSpecs(Button,Foreground)
option add *Menu.Background $ColorSpecs(Menu,Background)
option add *Menu.Foreground $ColorSpecs(Menu,Foreground)
option add *Menu.activeBackground $ColorSpecs(Menu,ActiveBackground)
option add *Menu.activeForeground $ColorSpecs(Menu,ActiveForeground)
option add *Menu.SelectBackground purple
option add *Radiobutton.activeBackground  $ColorSpecs(RadioButton,ActiveBackground)
option add *Radiobutton.activeForeground  $ColorSpecs(RadioButton,ActiveForeground)
option add *Radiobutton.selectColor  $ColorSpecs(RadioButton,Select) 80

#option add *Checkbutton*background lightblue
option add *Checkbutton.activeBackground  $ColorSpecs(CheckButton,ActiveBackground)
option add *Checkbutton.activeForeground  $ColorSpecs(CheckButton,ActiveForeground)
option add *Checkbutton.selectColor  $ColorSpecs(CheckButton,Select)

option add *Text.Font MainFont 100
option add *Menu.Font MenuFont 100

option add *Balloonhelpinfo.wrapLength 3i  widgetDefault
option add *Balloonhelp.info.justify left widgetDefault

font create BalloonHelpFont -family lucida -size 12
font create MenuFont -family courier -size 12
font create MainFont -family courier -size 13

set MSG .mf.msg

#For debugging messages
proc dmsg {msg} {
    if {$::DebugP} {
	puts $msg;
	flush stdout;
    }
}

proc ShowMessage {msg} {
    if {[winfo exists $::MSG]} {
	$::MSG configure -state normal;
	$::MSG delete 1.0 end;
	$::MSG insert 1.0 $msg;
	$::MSG configure -state disabled;
	return
    }
    puts stderr $msg;
 }

 proc ClearMessage {} {
      $::MSG configure -state normal
      $::MSG delete 1.0 end;
      $::MSG configure -state disabled
}

#Portability
#Figure out what system we are running on
if {[string equal $tcl_platform(platform) windows]} {
    set SystemInfo(System) MSWindows;
    dmsg "Running under MS Windows";
} elseif {[string equal $tcl_platform(platform) unix]} {
    if {[string equal $tcl_platform(os) Darwin]} {
	set SystemInfo(System) MacOSX;
	dmsg "Running under Mac OS X";
    } else {
	set SystemInfo(System) Unix;
	dmsg "Running under Unix";
    }
}

if {[string match $SystemInfo(System) MSWindows]} {
    set NonBinPath [file dirname [info script]];
}

if {[info exists ::env(TMP)]} {
    set TempDir $::env(TMP);
} elseif {[info exists ::env(TEMP)]} {
    set TempDir $::env(TEMP);
} else {
    if { $SystemInfo(System)== "MSWindows"} {
	set TempDir "C:\tmp";
    } else {
	set TempDir "/tmp";
    }
}
set ResultFile [file join $TempDir "a2u.log"]

proc SetupEvents {sys} {
    switch $sys {
	Unix {
	    event add <<B3>> <ButtonPress-3>
	    event add <<B3Release>> <ButtonRelease-3>
	}
	MacOSX {
	    event add <<B3>> <Control-ButtonPress-1>
	    event add <<B3Release>> <Control-ButtonRelease-1>
	}
	MSWindows {
	    event add <<B3>> <ButtonPress-3>
	    event add <<B3Release>> <ButtonRelease-3>
	}
    }
}

proc DetermineGraphicsSystem {} {
    global SystemInfo

    if {[string match X11*  [winfo server .]]} {
	set SystemInfo(AquaP) 0
	set SystemInfo(WindowSystem) X11
    } else {
	if {[string match $SystemInfo(System) "MSWindows"]} {
	    set SystemInfo(AquaP) 0;
	    set SystemInfo(WindowSystem) MSWindows;
	}
	if {[string match $SystemInfo(System) "MacOSX"]} {
	    set SystemInfo(AquaP) 1
	    set SystemInfo(WindowSystem) Aqua
	}
    }
}

DetermineGraphicsSystem
SetupEvents $SystemInfo(System)

#Determines which program to use
# 1 = ascii2uni
# 0 = uni2ascii
set WhichWay 0
#Daughter program options the user may set
set HexUpperCaseP 1
set PreserveNewlinesP 1
set PreserveSpaceP 1
set ConvertAsciiP 0
set AddSpaceP 0
set InputPureP 0
set WhichConversion 7
set ConvertStyleP 0
set ConvertEnclosedP 0
set StripDiacriticsP 0
set ConvertApproximateP 0
set ExpandToAsciiP 0

set BalloonHelpP 1

set DefaultBrowser dillo
set BrowserList [list firefox mozilla epiphany galeon konqueror dillo netscape]
set BrowserPIDS [list];

proc ShutDown {} {
    global BrowserPIDS;
    #Shutdown child browsers
    foreach pid $BrowserPIDS {
	catch {exec kill $pid};
    }
    exit 0;
}

proc ShowWebPage {url} {
    global BrowserPIDS;
    global SystemInfo
    if {[string equal $SystemInfo(System) MacOSX]} {
	lappend BrowserPIDS [exec osascript -e "\"open location $url\""]
	return 
    }
    set BrowserFound 0;
    foreach Browser $::BrowserList {
	if { [string length [auto_execok $Browser]]} {
	    set BrowserFound 1;
	    break ;
	} else {
	    ShowMessage [format \
	     [_ "The browser %s is not available on this machine or not in your path."]\
		 $Browser];
	}
    }
    if {$BrowserFound} {
	lappend BrowserPIDS [exec $Browser $url &]
    } else {
	ShowMessage [_ "No browser on the browser list was located."]
    }
}

proc new_dialog_create {class {win "auto"}} {
    if {$win == "auto"} {
        set count 0
        set win ".ndialog[incr count]"
        while {[winfo exists $win]} {
            set win ".ndialog[incr count]"
        }
    }
    toplevel $win -class $class;
    frame $win.info
    pack $win.info -expand yes -fill both -padx 4 -pady 4
    wm title $win $class
    wm group $win .

    after idle [format {
        update idletasks
        wm minsize %s [winfo reqwidth %s] [winfo reqheight %s]
    } $win $win $win]

    return $win
}

# The following code is taken from the Efftcl library by Mark Harrison and
# Michael McLennan, copyrighted by Mark Harrison and Lucent Technologies, available
# from http://www.awprofessional.com/content/images/0201634740/sourcecode/efftcl.zip.
# As the authors explicitly give permission to "steal the code for your own applications"
# the relevant portions are included here so as not to require the user to install
# to install the library. If you install the library, remove the following and
# uncomment the line "#package require Efftcl" by deleting the crosshatch.

#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

proc dialog_info {win} {
    return "$win.info"
}

proc dialog_controls {win} {
    return "$win.controls"
}

proc dialog_wait {win varName} {
    dialog_safeguard $win

    set x [expr [winfo rootx .]+50]
    set y [expr [winfo rooty .]+50]
    wm geometry $win "+$x+$y"

    wm deiconify $win
    grab set $win

    vwait $varName

    grab release $win
    wm withdraw $win
}

bind modalDialog <ButtonPress> {
    wm deiconify %W
    raise %W
}
proc dialog_safeguard {win} {
    if {[lsearch [bindtags $win] modalDialog] < 0} {
        bindtags $win [linsert [bindtags $win] 0 modalDialog]
    }
}

proc CreateTextDisplay {title width height {bg "\#e6b483"} {fg "\#000080"} } {
    set top [new_dialog_create Textdisplay]
    wm title $top $title
    set info [dialog_info $top]
    scrollbar $info.sbar -command "$info.text yview" 
    pack $info.sbar -side right -fill y
    text $info.text -height $height -width $width -font MainFont -wrap word -yscrollcommand "$info.sbar set"  -background $bg -foreground $fg -exportselection 1;
    pack $info.text -side left -expand yes -fill both
    $info.text configure -state disabled
    bind $info.sbar <<B3>> "ScrollbarMoveBigIncrement $info.sbar 0.2 %x %y"
    return $top
}

proc PopupDown {n} {
    global HelpPopups;
    if {[info exists HelpPopups($n)]} {
	if {[winfo exists $HelpPopups($n)]} {
	    destroy $HelpPopups($n);
	    return 1;
	}
    }
    return 0;
}

proc AppendToTextDisplay {top mesg} {
    set info [dialog_info $top]
    $info.text configure -state normal
    $info.text insert end $mesg
    $info.text configure -state disabled
}

set linkNum 0;
proc AppendLinkToTextDisplay {top mesg LinkCode} {
    global linkNum
    set info [dialog_info $top]
    $info.text configure -state normal
    set tag "link[incr linkNum]"
    bind $info.text <ButtonPress> break
    $info.text insert end $mesg [list body $tag]
    $info.text tag configure $tag -foreground red -underline 1
    $info.text tag bind $tag <Enter> \
        "$info.text tag configure $tag -foreground blue"
    $info.text tag bind $tag <Leave> \
        "$info.text tag configure $tag -foreground red"
    $info.text tag bind $tag <ButtonPress> \
        "$LinkCode"
    $info.text configure -state disabled
}

proc ExplainEquivalences {} {
    global Version;
    if {[PopupDown ExplainEquivalences] ==1} {return}
    set po [CreateTextDisplay [_ "Equivalences"] 72 12]
    set ::HelpPopups(ExplainEquivalences) $po
    AppendToTextDisplay $po "U+00A0  no break space                              0x20  space\n"
    AppendToTextDisplay $po "U+00AB  left-pointing double angle quotation mark   0x22  double quote\n"
    AppendToTextDisplay $po "U+00AD  soft hyphen                                 0x2D  minus\n"
    AppendToTextDisplay $po "U+00BB  right-pointing double angle quotation mark  0x22  double quote\n"
    AppendToTextDisplay $po "U+1361  ethiopic word space                         0x20  space\n"
    AppendToTextDisplay $po "U+1680  ogham space                                 0x20  space\n"
    AppendToTextDisplay $po "U+2000  en quad                                     0x20  space\n"
    AppendToTextDisplay $po "U+2001  em quad                                     0x20  space\n"
    AppendToTextDisplay $po "U+2002  en space                                    0x20  space\n"
    AppendToTextDisplay $po "U+2003  em space                                    0x20  space\n"
    AppendToTextDisplay $po "U+2004  three-per-em space                          0x20  space\n"
    AppendToTextDisplay $po "U+2005  four-per-em space                           0x20  space\n"
    AppendToTextDisplay $po "U+2006  six-per-em space                            0x20  space\n"
    AppendToTextDisplay $po "U+2007  figure space                                0x20  space\n"
    AppendToTextDisplay $po "U+2008  punctuation space                           0x20  space\n"
    AppendToTextDisplay $po "U+2009  thin space                                  0x20  space\n"
    AppendToTextDisplay $po "U+200A  hair space                                  0x20  space\n"
    AppendToTextDisplay $po "U+200B  zero-width space                            0x20  space\n"
    AppendToTextDisplay $po "U+2010  hyphen                                      0x2D  minus\n"
    AppendToTextDisplay $po "U+2011  non-breaking hyphen                         0x2D  minus\n"
    AppendToTextDisplay $po "U+2012  figure dash                                 0x2D  minus\n"
    AppendToTextDisplay $po "U+2013  en dash                                     0x2D  minus\n"
    AppendToTextDisplay $po "U+2014  em dash                                     0x2D  minus\n"
    AppendToTextDisplay $po "U+2018  left single quotation mark                  0x60  left single quote\n"
    AppendToTextDisplay $po "U+2019  right single quotation mark                 0x27  right or neutral single quote\n"
    AppendToTextDisplay $po "U+201A  single low-9 quotation mark                 0x60  left single quote\n"
    AppendToTextDisplay $po "U+201B  single high-reversed-9 quotation mark       0x60  left single quote\n"
    AppendToTextDisplay $po "U+201C  left double quotation mark                  0x22  double quote\n"
    AppendToTextDisplay $po "U+201D  right double quotation mark                 0x22  double quote\n"
    AppendToTextDisplay $po "U+201E  double low-9 quotation mark                 0x22  double quote\n"
    AppendToTextDisplay $po "U+201F  double high-reversed-9 quotation mark       0x22  double quote\n"
    AppendToTextDisplay $po "U+2039  single left-pointing angle quotation mark   0x60  left single quote\n"
    AppendToTextDisplay $po "U+203A  single right-pointing angle quotation mark  0x27  right or neutral single quote\n"
    AppendToTextDisplay $po "U+204E  low asterisk                                0x2A  asterisk\n"
    AppendToTextDisplay $po "U+2212  minus sign                                  0x2D  minus\n"
    AppendToTextDisplay $po "U+2217  asterisk operator                           0x2A  asterisk\n"
    AppendToTextDisplay $po "U+222A  union symbol                                0x55  capital U\n"
    AppendToTextDisplay $po "U+2731  heavy asterisk                              0x2A  asterisk\n"
    AppendToTextDisplay $po "U+275D  heavy double turned comma quotation mark    0x22  double quote\n"
    AppendToTextDisplay $po "U+275E  heavy double comma quotation mark           0x22  double quote\n"
    AppendToTextDisplay $po "U+3000  ideographic space                           0x20  space\n"
    AppendToTextDisplay $po "U+FE60  small ampersand                             0x26  ampersand\n"
    AppendToTextDisplay $po "U+FE61  small asterisk                              0x2A  asterisk\n"
    AppendToTextDisplay $po "U+FE62  small plus sign                             0x2B  plus sign\n";
}

proc ExplainExpansions {} {
    global Version;
    if {[PopupDown ExplainExpansions] ==1} {return}
    set po [CreateTextDisplay [_ "Expansions"] 72 12]
    set ::HelpPopups(ExplainExpansions) $po
    AppendToTextDisplay $po "If this option is chosen, certain characters are expanded to sequences of approximately equivalent plain ASCII characters. The expansions are:\n"
    AppendToTextDisplay $po "\tU+00A9 \u00A9\tCOPYRIGHT SYMBOL         \t\u2192 (c)\n"
    AppendToTextDisplay $po "\tU+00DF \u00DF\tSMALL LETTER SHARP S     \t\u2192 ss\n"
    AppendToTextDisplay $po "\tU+00C6 \u00C6\tCAPITAL LETTER ASH       \t\u2192 AE\n"
    AppendToTextDisplay $po "\tU+00E6 \u00E6\tSMALL LETTER ASH         \t\u2192 ae\n"
    AppendToTextDisplay $po "\tU+01F1 \u01F1\tCAPITAL LETTER DZ        \t\u2192 DZ\n"
    AppendToTextDisplay $po "\tU+01F3 \u01F3\tSMALLL LETTER DZ         \t\u2192 dz\n"
    AppendToTextDisplay $po "\tU+02A6 \u02A6\tSMALLL LETTER TS DIGRAPH \t\u2192 ts\n"
    AppendToTextDisplay $po "\tU+2026 \u2026\tHORIZONTAL ELLIPSIS      \t\u2192 ...\n"
    AppendToTextDisplay $po "\tU+2190 \u2190\tLEFTWARDS ARROW          \t\u2192 <-\n"
    AppendToTextDisplay $po "\tU+2192 \u2192\tRIGHTWARDS ARROW         \t\u2192 ->\n"
    AppendToTextDisplay $po "\tU+21D0 \u21D0\tLEFTWARDS DOUBLE ARROW   \t\u2192 <=\n"
    AppendToTextDisplay $po "\tU+21D2 \u21D2\tRIGHTWARDS DOUBLE ARROW  \t\u2192 =>\n"
    AppendToTextDisplay $po "\tU+22EF \u22EF\tMIDLINE HORIZONTAL ELLIPSIS\t\u2192 ...\n"
}

proc About {} {
    global Version;
    if {[PopupDown About] ==1} {return}
    set AboutPopup [CreateTextDisplay [_ "About This Program"] 72 12]
    set ::HelpPopups(About) $AboutPopup;
    AppendToTextDisplay $AboutPopup [format [_ "This is U2A version %s. "] $Version];
    AppendToTextDisplay $AboutPopup [_ "It converts between Unicode and various textual representations of Unicode."];
    AppendToTextDisplay $AboutPopup [_ "You can obtain the latest version of U2A from: "];
    AppendLinkToTextDisplay $AboutPopup "http://billposer.org/Software/uni2ascii.html." {ShowWebPage http://billposer.org/Software/uni2ascii.html};
    AppendToTextDisplay $AboutPopup "\n\n";
    AppendToTextDisplay $AboutPopup "Copyright (C) 2005, 2006 William J. Poser (billposer@alum.mit.edu). ";
    AppendToTextDisplay $AboutPopup [_ "This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version."];
    AppendToTextDisplay $AboutPopup "\n\n";
    AppendToTextDisplay $AboutPopup [_ "This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"];
    AppendToTextDisplay $AboutPopup [_ "See the GNU General Public License for more details."];
    AppendToTextDisplay $AboutPopup "\n\n";
    AppendToTextDisplay $AboutPopup [_ "You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA."];
}


set BugReportPopup "";
proc BugReports {} {
    global Version;
    global tcl_platform;
    global BugReportPopup

    if {[PopupDown BugReports] ==1} {return}
    set BugReportPopup [CreateTextDisplay [_ "Bug Reports"] 50 21];
    set ::HelpPopups(BugReports) $BugReportPopup;
    AppendToTextDisplay $BugReportPopup [_ "Report bugs to: billposer@alum.mit.edu.\n"];
    AppendToTextDisplay $BugReportPopup [_ "Please include the following information:\n\n"];
    AppendToTextDisplay $BugReportPopup [_ "\tWhat version of U2A are you using?\n"];
    AppendToTextDisplay $BugReportPopup [format [_ "\t\t(This is version %s.)\n\n"] $Version];
    AppendToTextDisplay $BugReportPopup [_ "\tWhat operating system are you running?.\n"];
    set OS $tcl_platform(os);
    if {$OS == "Linux"} {set OS "GNU/Linux"};
    AppendToTextDisplay $BugReportPopup [format [_ "\t\t(This is %s  %s.)\n\n"] $OS  $tcl_platform(osVersion)];
    AppendToTextDisplay $BugReportPopup [_ "\tWhat window system are you using?.\n"];
    AppendToTextDisplay $BugReportPopup [format [_ "\t\t(This is %s.)\n\n"] $::SystemInfo(WindowSystem)]
    AppendToTextDisplay $BugReportPopup [_ "\tWhat version of tcl/tk are you using?.\n"];
    AppendToTextDisplay $BugReportPopup [format [_ "\t\t(This is version %s.)\n\n"] [info patchlevel]];
    AppendToTextDisplay $BugReportPopup [_ "Bug reports may be sent in any language that I can read without too much trouble or am trying to learn or improve. These include:\n\n"];
    AppendLinkToTextDisplay $BugReportPopup [_ "\tCatalan"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=cat};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tDakelh (Carrier)"] {ShowWebPage http://ydli.org}
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tDutch"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=nld};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tEnglish"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=eng};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tEsperanto"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=epo};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tFrench"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=fra};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tGerman"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=deu};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tItalian"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=ita};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tJapanese"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=jpn};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tKazakh"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=kaz};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tKorean"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=kor};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tLatin"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=lat};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tPortuguese"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=por};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tSpanish"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=spa};
    AppendToTextDisplay $BugReportPopup "\n";
    AppendLinkToTextDisplay $BugReportPopup [_ "\tTurkish"] {ShowWebPage http://www.ethnologue.com/show_language.asp?code=tur};
    AppendToTextDisplay $BugReportPopup "\n\n";
    AppendToTextDisplay $BugReportPopup [_ "Please note that in many cases although I can understand the language my ability to respond in it may be limited.\n"];
    AppendToTextDisplay $BugReportPopup "\n";
}

proc ShowGPL {} {
    if {[PopupDown ShowGPL] ==1} {return}
    set GPLPopup [CreateTextDisplay [_ "License"] 70 24]
    set ::HelpPopups(ShowGPL) $GPLPopup;
    AppendToTextDisplay $GPLPopup [format "%s%s" [format "%s\n\t%s\n" [_ "For this license in your language see:"] [_ "http://www.gnu.org/copyleft/gpl.html"]]  "\
\

		    GNU GENERAL PUBLIC LICENSE\

   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
\

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The \"Program\", below,
refers to any such program or work, and a \"work based on the Program\"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term \"modification\".)  Each licensee is addressed as \"you\".
\

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.
\

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.
\

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.
\

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:
\

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.
\

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.
\

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)
\

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.
\

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.
\

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.
\

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:
\

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,
\

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,
\

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)
\

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.
\

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.
\

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.
\

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.
\

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.
\

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.
\

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.
\

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.
\

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.
\

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.
\

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.
\

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and \"any
later version\", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.
\

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.
\

			    NO WARRANTY
\

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.
\

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES."]
}

set OtherPopups(HowTo) "";
proc HowTo {} {
    if {[PopupDown HowTo] ==1} {return}
    set po [CreateTextDisplay [_ "How to Use this Program"] 60 15]
    set ::HelpPopups(HowTo) $po;
    AppendToTextDisplay $po [_ "This program provides an interface to two programs that do the actual conversions between Unicode and ASCII. It assembles the necessary information and then runs the appropriate program. What you need to do is to provide information about what you want to do. When you are ready, press the 'Convert' button.\n\n"]
    AppendToTextDisplay $po [_ "The first thing that you need to indicate is the direction of the conversion: from Unicode to ASCII or from ASCII to Unicode.\n\n"]
    AppendToTextDisplay $po [_ "Next, select the file from which the input is to be read and specify the name of the file into which the result of the conversion should be put. You can type the filenames directly into the entry boxes or you can browse by pressing the 'Browse' buttons.\n\n"]
    AppendToTextDisplay $po [_ "Next specify the ASCII format that is used in the input text if you are converting from ASCII to Unicode, or the ASCII format that you want to use if you are converting from Unicode to ASCII. If you select a format with your left mouse button and then click your right mouse button, some additional information about that format will be displayed if there is any.\n\n"]
    AppendToTextDisplay $po [_ "Finally, make any changes that you wish to make in the character replacement options and miscellaneous options and press 'Convert'. If you have made all the necessary choices, U2A will execute the appropriate conversion program and report the result. If you have not yet provided all the necessary information you will be notified of what is missing.\n\n"]
    AppendToTextDisplay $po [format [_ "If you often have to do this same conversion, you may wish to create a shell script rather than using this graphical interface all the time. To assist you in this, the 'Show Command Line' command on the File menu displays the command that would be executed if the 'Convert' button were pressed. Note that the last part of the command line, '2> %s', sends the standard error output to a temporary file. You may not want to do this when running the programs yourself.\n\n"] $::ResultFile];
    AppendToTextDisplay $po [_ "If you become tired of the balloon help, you can disable it using the checkbox on the 'Help' menu."]
}

#The order in which the options are listed here is the order in which they will be
#displayed.
set OptionList {r x f e u v l a p b c g d h n m q y k i j o s t}
set AsciiOptions(a,example) "<U00E9>"
set AsciiOptions(a,description) "hexadecimal with prefix U in angle brackets"
set AsciiOptions(a,info) "This notation is used in POSIX locale specifications."
set AsciiOptions(b,example) "\\x00E9"
set AsciiOptions(b,description) "hexadecimal with prefix \\x"
set AsciiOptions(c,example) "\\x\{00E9\}"
set AsciiOptions(c,description) "hexadecimal in braces with prefix \\x"
set AsciiOptions(c,info) "This notation is used in Perl."
set AsciiOptions(d,example) "&\#0233;"
set AsciiOptions(d,description) "decimal numeric character reference"
set AsciiOptions(d,info)  "This notation is used in HTML"
set AsciiOptions(e,example) "U00E9"
set AsciiOptions(e,description) "hexadecimal with prefix U"
set AsciiOptions(f,example) "u00E9"
set AsciiOptions(f,description) "hexadecimal with prefix u"
set AsciiOptions(g,example) "X\'00E9\'"
set AsciiOptions(g,description) "hexadecimal in single quotes with prefix X"
set AsciiOptions(h,example) "&\#x00E9"
set AsciiOptions(h,description) "hexadecimal numeric character reference"
set AsciiOptions(h,info) "This notation is used in HTML."     
set AsciiOptions(i,example) "=C3=A9"
set AsciiOptions(i,description) "hexadecimal UTF-8 with =-sign prefix"
set AsciiOptions(i,info) "This is the Quoted Printable format defined in RFC2045"
set AsciiOptions(j,example) "%C3%A9"
set AsciiOptions(j,description) "hexadecimal UTF-8 with %-sign prefixes"
set AsciiOptions(j,info) "This is the Universal Resource Indicator notation defined in RFC2396."
set AsciiOptions(k,example) "\\303\\251"
set AsciiOptions(k,description) "octal UTF-8 with backslash prefixes"
set AsciiOptions(l,example) "\\u00E9 / \\U10001"
set AsciiOptions(l,description) "hexadecimal with prefix \\u within BMP, \\U outside"
set AsciiOptions(l,info) "This format is used in Tcl and Scheme source code."
set AsciiOptions(m,example) "\\\#xE9;"
set AsciiOptions(m,description) "hexadecimal with prefix backslash crosshatch x and suffix semi-colon"
set AsciiOptions(m,info) "This format is used in SGML."
set AsciiOptions(n,example) "\\\#233;"
set AsciiOptions(n,description) "decimal with prefix backslash crosshatch x and suffix semi-colon"
set AsciiOptions(n,info) "This format is used in SGML."
set AsciiOptions(o,example) "\\000\\000\\351"
set AsciiOptions(o,description) "The low three bytes in octal in big-endian order."
set AsciiOptions(s,info) "This format is one of three permitted in POSIX portable charmaps."
set AsciiOptions(p,example) "U+00E9"
set AsciiOptions(p,description) "hexadecimal with prefix U+"
set AsciiOptions(p,info) "This is the notation used by the Unicode Consortium"
set AsciiOptions(q,example) "&eacute;"
set AsciiOptions(q,description) "character entity;"
set AsciiOptions(q,info)  "This notation is used in HTML.\nSelecting this conversion in going from ASCII to Unicode\nmeans that only character entities will be converted to Unicode.\nSelecting this conversion in the direction from Unicode\nto ASCII means that character entities will be generated\nwhere possible. Where character entities do not exist,\nhexadecimal character references will be generated."
set AsciiOptions(r,example) "00E9"
set AsciiOptions(r,description) "raw hexadecimal number"
set AsciiOptions(s,example) "\\x00\\x00\\xE9"
set AsciiOptions(s,description) "The low three bytes in hexadecimal in big-endian order."
set AsciiOptions(s,info) "This format is one of three permitted in POSIX portable charmaps."
set AsciiOptions(t,example) "\\d000\\d000\\d233"
set AsciiOptions(t,description) "The low three bytes in decimal in big-endian order."
set AsciiOptions(t,info) "This format is one of three permitted in POSIX portable charmaps."
set AsciiOptions(u,example) "\\u00E9"
set AsciiOptions(u,description) "hexadecimal with prefix \\u"
set AsciiOptions(u,info) "This notation is used in Java and Python source code."
set AsciiOptions(v,example) "\\u00233"
set AsciiOptions(v,description) "decimal with prefix \\u"
set AsciiOptions(v,info) "This notation is used in Rich Text Format (RTF)."
set AsciiOptions(x,example) "0x00E9"
set AsciiOptions(x,description) "standard format hexadecimal number"
set AsciiOptions(y,example) ""
set AsciiOptions(y,description) "all three HTML formats"

set AsciiOptions(Example,info) "This column shows examples of the various types of notation.\nIn most cases the example is of the representation of the\nletter \u00E9 \"e with acute accent\". The exception is the\ncase in which the notation is different within the BMP and\noutside it. Here the first example is of \u00E9 and the second\nis of \"Linear B syllable E\"."
set AsciiOptions(Description,info) "This column contains a description of the notation."

trace add variable WhichWay write ToggleOptionsEnabled
proc ToggleOptionsEnabled {e o n} {
    upvar $e aup;
    if {$aup} {
	$::GENOPTIONS.tbl.ipt configure -state normal
	$::GENOPTIONS.tbl.hu configure -state disabled
	$::GENOPTIONS.tbl.pt configure -state disabled
	$::GENOPTIONS.tbl.nt configure -state disabled
	$::GENOPTIONS.tbl.wt configure -state disabled
	$::GENOPTIONS.tbl.at configure -state disabled
	$::DOWNOPTIONS.tbl.sty configure -state disabled
	$::DOWNOPTIONS.tbl.cir configure -state disabled
	$::DOWNOPTIONS.tbl.dia configure -state disabled
	$::DOWNOPTIONS.tbl.app configure -state disabled
	$::DOWNOPTIONS.tbl.exp configure -state disabled
    } else {
	$::GENOPTIONS.tbl.ipt configure -state disabled
	$::GENOPTIONS.tbl.hu configure -state normal
	$::GENOPTIONS.tbl.pt configure -state normal
	$::GENOPTIONS.tbl.nt configure -state normal
	$::GENOPTIONS.tbl.wt configure -state normal
	$::GENOPTIONS.tbl.at configure -state normal
	$::DOWNOPTIONS.tbl.sty configure -state normal
	$::DOWNOPTIONS.tbl.cir configure -state normal
	$::DOWNOPTIONS.tbl.dia configure -state normal
	$::DOWNOPTIONS.tbl.app configure -state normal
	$::DOWNOPTIONS.tbl.exp configure -state normal
    }
}

proc ProgramTimeDateStamp {} {
    set sts [split $::TimeStamp]
    return "[lindex $sts 0] [lindex $sts 1]"
}

#Set up balloon help
toplevel .balloonhelp -class Balloonhelp -background black -borderwidth 1 -relief flat
#label .balloonhelp.arrow -anchor nw -bitmap @arrow.xbm
#pack .balloonhelp.arrow -side left -fill y
label .balloonhelp.info -font BalloonHelpFont;
pack .balloonhelp.info -side left -fill y
wm overrideredirect .balloonhelp 1
wm withdraw .balloonhelp
set bhInfo(active) 1

proc balloonhelp_control {state} {
     global bhInfo
     if {$state} {
          set bhInfo(active) 1
     } else {
	balloonhelp_cancel
	set bhInfo(active) 0
     }
}

proc balloonhelp_for {win mesg} {
    global bhInfo
    set bhInfo($win) $mesg
    set ::bhOverlapP($win) 1; 
    bind $win <Enter> {+balloonhelp_pending %W}
    bind $win <Leave> {+balloonhelp_cancel}
}

proc balloonhelpd_for {win mesg} {
    global bhInfo
    set ::bhOverlapP($win) 0;
    set bhInfo($win) $mesg
    bind $win <Enter> {+balloonhelp_show %W}
    bind $win <Leave> {+wm withdraw .balloonhelp}
}

proc balloonhelp_pending {win} {
     global bhInfo
     balloonhelp_cancel
     set bhInfo(pending) [after 1000 [list balloonhelp_show $win]]
}

proc balloonhelp_cancel {} {
    global bhInfo
    if { [info exists bhInfo(pending)]} {
	after cancel $bhInfo(pending)
	unset bhInfo(pending)
    }
    wm withdraw .balloonhelp
}

proc balloonhelp_show {win} {
    global bhInfo;
    global bhOverlapP;
    if {$bhOverlapP($win)} {
	set Overlap 25;
    } else {
	set Overlap -10;
    }
    if {[winfo exists $win]} {
	if {$bhInfo(active)} {
	    .balloonhelp.info configure -text $bhInfo($win)
	    #Set abcissa
	    set MaxStringWidth 0;
	    foreach line [split $bhInfo($win) "\n"] {
		set StringWidth [font measure BalloonHelpFont -displayof .balloonhelp.info $line]
		if {$StringWidth > $MaxStringWidth} {
		    set MaxStringWidth $StringWidth;
		}
	    }
	    set ScreenWidth [winfo screenwidth $win]
	    set Width [winfo width $win];
	    set LeftEdge  [winfo rootx $win];
	    set RightEdge [expr $LeftEdge + $Width];
	    if {$ScreenWidth - $RightEdge < $MaxStringWidth} { 
		if {$LeftEdge > $MaxStringWidth} {
		    set x [expr $LeftEdge - $MaxStringWidth + $Overlap];
		} else {
		    if {$ScreenWidth - $MaxStringWidth > 0} {
			set x [expr $RightEdge - $MaxStringWidth];
		    } else {
			set x [expr $ScreenWidth - $MaxStringWidth];
		    }
		}
	    } else {
		set x [expr $RightEdge - $Overlap];
	    }
	    #Set ordinate
	    set Height [winfo height $win];
	    set TopEdge [winfo rooty $win];
#	    set y [expr $TopEdge + ($Height/2)];
	    set y [expr $TopEdge + int(($Height/1.5))];
	    wm geometry .balloonhelp +$x+$y
	    wm deiconify .balloonhelp
	    raise .balloonhelp
	}
    }
    if {[info exist bhInfo(pending)]} {
	unset bhInfo(pending)
    }
}

proc ToggleBalloonHelp {} {
    global BalloonHelpP;
    global BalloonHelpIndex;
    global m;

    if {$BalloonHelpP} {
	set BalloonHelpP 0;
	balloonhelp_control 0
	ShowMessage [_ "Irritating Balloon Help Disabled"];
	$m.configure entryconfigure $BalloonHelpIndex -label [_ "Show Balloon Help"];
    } else {
	set BalloonHelpP 1;
	balloonhelp_control 1
	ShowMessage [_ "Balloon Help Enabled"];
	$m.configure entryconfigure $BalloonHelpIndex -label [_ "Hide Irritating Balloon Help"];
    }
}

proc ConstructUACommandLine {ind} {
    set cl [list]
    lappend cl uni2ascii
    if {$::ConvertEnclosedP} {
	lappend cl "-c"
    }
    if {$::StripDiacriticsP} {
	lappend cl "-d"
    }
    if {$::ConvertApproximateP} {
	lappend cl "-e"
    }
    if {$::ConvertStyleP} {
	lappend cl "-f"
    }
    if {$::ExpandToAsciiP} {
	lappend cl "-x"
    }
    if {$::HexUpperCaseP == 0} {
	lappend cl "-l"
    }
    if {$::PreserveNewlinesP == 0} {
	lappend cl "-n"
    }
    if {$::PreserveSpaceP == 0} {
	lappend cl "-s"
    }
    if {$::ConvertAsciiP} {
	lappend cl "-p"
    }
    if {$::AddSpaceP} {
	lappend cl "-w"
    }
    set i [lindex $::OptionList $ind]
    lappend cl [format "\-%s" [string toupper $i]]
    if {[string equal $i "q"]} {
	lappend cl "-H"
    }
    return $cl
}

proc ConstructAUCommandLine {ind} {
    set cl [list]
    lappend cl ascii2uni
    if {$::InputPureP} {
	lappend cl "-p"
    }
    lappend cl [format "\-%s" [string toupper [lindex $::OptionList $ind]]]
    return $cl
}

proc ConstructCommandLine {ind inf outf} {
    if {$::WhichWay} {
	set cl [ConstructAUCommandLine $ind]
    } else {
	set cl [ConstructUACommandLine $ind]
    }
    lappend cl "<"
    lappend cl $inf;
    lappend cl ">"
    lappend cl $outf;
    lappend cl "2>"
    lappend cl $::ResultFile
    return $cl
} 

set PreviousIndex "";
proc ExecuteDaughter {ReallyP} {
    ClearMessage
    set index [$::AFORMATS.f.tl curselection]
    if {[string equal $index ""]} {
	if {[string equal $::PreviousIndex ""]} {
	    ShowMessage "No ASCII format has been selected."
	    return "";
	} else {
	    set index $::PreviousIndex;
	}
    } else {
	set ::PreviousIndex $index;
    }
    set inf [$::INPUT.ent get]
    if {[string equal $inf ""]} {
	ShowMessage "No input file has been specified."
	return "";
    }
    if {[file readable $inf] == 0} {
	ShowMessage "The specified input file is not readable."
	return ""
    }
    set outf [$::OUTPUT.ent get]
    if {[string equal $outf ""]} {
	ShowMessage "No output file has been specified."
	return "";
    }
    if {[file exist $outf] && ([file writable $outf] == 0)} {
	ShowMessage "The specified output file is not writable."
	return ""
    }
    set cl [ConstructCommandLine $index $inf $outf]
    if {$ReallyP} {
	set cl [linsert $cl 0 "exec"]
	set result [eval $cl];
	set rlist [GetResultInfo]
	set Converted [lindex $rlist 0]
	set msg [format "tokens converted: %d" $Converted]
	if {$::WhichWay} {		# Ascii to unicode
	    set MicrosoftStyle [lindex $rlist 2]
	    append msg [format " (Microsoft-style %d)" $MicrosoftStyle]
	    set Replaced  [lindex $rlist 1]
	    append msg [format "  replaced: %d" $Replaced]
	} else {
	    set TotalChars [lindex $rlist 1]
	    append msg [format " out of %d total characters" $TotalChars]
	}
	ShowMessage $msg
	return $result;
    } else {
	ShowMessage $cl;
    }
}

#Return a list of three values: number of tokens converted, number replaced, number
#of Microsoft-style non-standard HTML.
proc GetResultInfo {} {
    if {[catch {open $::ResultFile "r"} ResultHandle ] != 0} {
	ShowMessage [format [_ "Mysterious failure to open temporary file %s."] $::ResultFile];
	return "";
    }
    #Read first line of log
    if {[gets $ResultHandle line] <= 0} {
	return [list 0 0 0]
    }
    set rlist [split $line]
    lappend res [lindex $rlist 0]
    if {!$::WhichWay} {
	lappend res [lindex $line 5]
    }
    #Attempt to read second line of log, which will contain replacement count, if ascii2uni,
    #or the number of input characters, if uni2ascii.
    if {[gets $ResultHandle line] > 0} {
	lappend res [lindex $line 0]
    } else {
	lappend res 0
	if {$::WhichWay} {
	    lappend res 0
	}
	return $res
    }
    if {[gets $ResultHandle line] > 0} {
	lappend res [lindex $line 0]
    } else {
	if {$::WhichWay} {
	    lappend res 0
	}
    }
    return $res;
}

proc PopupInfo {o} {
    if {[info exist ::AsciiOptions($o,info)]} {
	set info $::AsciiOptions($o,info);
	if {[PopupDown $o] ==1} {return}
	set po [CreateTextDisplay $o 72 12]
	set ::HelpPopups($o) $po
	AppendToTextDisplay $po $info;
    }
}

proc CellInfo {} {
    set row [lindex  [split [$::AFORMATS.f.tl curcellselection] ","] 0]
    PopupInfo [lindex $::OptionList $row]
}

#If the filename passed as argument is a pathname
#leading to a file in the current working directory,
#return just the basename+extension. Otherwise
#return the argument.
proc MinimizeFileName {s} {
    set cwd [pwd];
    set sdir [file dirname $s]
    if {[string equal $cwd $sdir]} {
	return [file tail $s]
    } else {
	return $s;
    }
}

proc SelectInputFile {} {
    set InputFile [tk_getOpenFile];
    if {$InputFile == ""} {
	ShowMessage [_ "File selection aborted."]
    } else { 
	$::INPUT.ent delete 0 end
	$::INPUT.ent insert 0 [MinimizeFileName $InputFile]
    }
}

proc SelectOutputFile {} {
    set OutputFile [tk_getSaveFile -initialfile [_ "MinpairOutput"]];
    if {$OutputFile == ""} {
	ShowMessage [_ "File selection aborted."]
    } else { 
	$::OUTPUT.ent delete 0 end
	$::OUTPUT.ent insert 0 [MinimizeFileName $OutputFile]
    }
}

proc DescribeColumn {w c} {
    if {$c == 0} {
	PopupInfo Description;
    } else {
	PopupInfo Example;
    }
}

puts "u2a $Version";
puts "Copyright (C) 2005, 2006 William J. Poser.";
puts [_ "This program is free software; you can redistribute it
and/or modify it under the terms of version 2 of the GNU General
Public License as published by the Free Software Foundation."];

set m [menu .menubar -tearoff 0 -font MenuFont \
       -bg $ColorSpecs(Menubar,Background) \
       -fg $ColorSpecs(Menubar,Foreground) \
       -activebackground $ColorSpecs(Menubar,ActiveBackground)\
       -activeforeground $ColorSpecs(Menubar,ActiveForeground)]
set MenuBarItemCnt -1;
$m add cascade -label [_ "File"]   -menu [menu $m.file]
$m.file add command -label [_ "Show Command Line"] -command {ExecuteDaughter 0}
$m.file add command -label [_ "Quit"] -command ShutDown;
$m add cascade -label [_ "Help"]   -menu [menu $m.help]
$m.help add command -label "About" -command About
$m.help add checkbutton -label "Balloon Help" -variable BalloonHelpP \
    -onvalue 1 -offvalue 0 -command {balloonhelp_control $::BalloonHelpP} -indicatoron 1 \
    -selectcolor coral
$m.help add command -label "Bug Reports" -command BugReports
$m.help add command -label "How to Use this Program" -command HowTo
$m.help add command -label "License" -command ShowGPL
$m.help add command -label "Unicode Consortium Web Site" -command {ShowWebPage http://www.unicode.org}
. configure -menu .menubar

frame .mf -background $ColorSpecs(MainFrame,Background)
pack .mf

text $MSG -bg $ColorSpecs(Messages,Background) \
    -fg $ColorSpecs(Messages,Foreground) \
    -height 1 -width 60\
    -relief sunken -font MainFont -exportselection 1 -state disabled

balloonhelp_for $MSG "Messages from the program appear here."

set WHICHWAY .mf.whichway
frame $WHICHWAY -border 2 -relief ridge
frame $WHICHWAY.f -border 2 -relief ridge
label $WHICHWAY.f.tit -text "Direction of Conversion"
radiobutton $WHICHWAY.f.tou -variable WhichWay -value 1 -text "ASCII to Unicode"
radiobutton $WHICHWAY.f.toa -variable WhichWay -value 0 -text "Unicode to ASCII"
button $WHICHWAY.exe -text "Convert" -command {ExecuteDaughter 1} \
    -bg "\#FF9f8c" -fg black -activeforeground black -activebackground red
pack $WHICHWAY.f.tit -side top -expand 0 -fill none -padx 2 -pady {4 5} -anchor w
pack $WHICHWAY.f.tou -side left -expand 1 -fill both -padx {2 4} -pady 5
pack $WHICHWAY.f.toa -side left -expand 1 -fill both -padx {4 5} -pady 5
pack $WHICHWAY.f   -side left -expand 1 -fill both -padx {5  40} -pady {6 6}
pack $WHICHWAY.exe -side left -expand 1 -fill both -padx {40 10} -pady 6

set msg "Here is where you choose whether to convert from Unicode to an
ASCII representation or from an ASCII representation to Unicode."
balloonhelp_for $WHICHWAY $msg

set msg "When you have set everything up and are ready to
actually carry out the conversion, press this button."
balloonhelp_for $WHICHWAY.exe $msg

set GENOPTIONS .mf.f
frame $GENOPTIONS -border 2 -relief ridge
label $GENOPTIONS.tit -text "Miscellaneous Options"
frame $GENOPTIONS.tbl
checkbutton $GENOPTIONS.tbl.hu -variable HexUpperCaseP -text "Upper case hexadecimal numbers"
checkbutton $GENOPTIONS.tbl.pt -variable ConvertAsciiP  -offvalue 0 -onvalue 1 \
    -text "Convert ASCII characters"
checkbutton $GENOPTIONS.tbl.nt -variable PreserveNewlinesP  -offvalue 1 -onvalue 0 \
    -text "Convert linefeed characters"
checkbutton $GENOPTIONS.tbl.wt -variable PreserveSpaceP  -offvalue 1 -onvalue 0 \
    -text "Convert space characters"
checkbutton $GENOPTIONS.tbl.at -variable AddSpaceP -text "Add a space after each item"
checkbutton $GENOPTIONS.tbl.ipt -variable InputPureP -text "Input is pure"

set msg "Here is where you can set various options. Note that some options
apply only to uni2ascii and others only to ascii2uni. The options
that are not relevant to the current direction of conversion are
disabled and appear greyed out."
balloonhelp_for $GENOPTIONS $msg

set msg "Select this option if you want to use the upper case
letters A, B, C, D, E, and F in hexadecimal numbers,
where they represent the numbers 10, 11, 12, 13, 14, and 15.
For example, the letter \u00E9, e with acute accent, will
look like this in standard hexadecimal notation: 0x00E9 
If you do not select it, the letters a, b, c, d, e, and f
will be used in hexadecimal numbers, where they represent
the numbers 10, 11, 12, 13, 14, and 15.
For example, the letter \u00E9, e with acute accent, will
look like this in standard hexadecimal notation: 0x00e9 
This is usually an aesthetic choice, but some programs care
about case."
balloonhelp_for $GENOPTIONS.tbl.hu $msg

set msg "Select this option if you want to convert all
characters in the input, even ASCII characters (those
at codepoints less than 0x0080) to a textual
representation. For example, if the input contains
the letter \'a\', it will be converted to a textual
representation such as the standard hexadecimal 0x0061.
For example, the French word \u00e9\u0074\u00e9 \'summer\' will look like:
0x00E9 0x0074 0x00E9
(with spaces inserted to make it easier to parse).

If this option is selected ASCII characters other than
space (U+0020), tab (U+0009), and newline (U+000A) will
be converted. The conversion of space, tab, and newline
is controlled by other options.

Do not select this option if you want to preserve ASCII
characters (those at codepoints less than 0x0080) rather
than converting them to textual representation. If the input
text contains a mixture of ASCII and non-ASCII characters,
the output will contain a mixture of ASCII characters and
textual representations. For example, the French word \u00e9\u0074\u00e9 \'summer\'
will look like:
0x00E9 t 0x00E9
(with spaces inserted to make it easier to parse)."
balloonhelp_for $GENOPTIONS.tbl.pt $msg

set msg "Select this option if you wish to convert
linefeed characters (U+000A) to textual
representations. Note that unless you select
this option the space and tab characters will
not be converted even if you have chosen to
convert ASCII characters in general."
balloonhelp_for $GENOPTIONS.tbl.nt $msg

set msg "Select this option if you wish to convert the whitespace
characters space (U+0020), tab (U+0009), ethiopic word
space (U+1361), ogham space (U+1680), and ideographic
space (U+3000)  to textual representation. Note that
unless you select this option the space and tab characters
will not be converted even if you have chosen to
convert ASCII characters in general.

Do not select this option if you do not wish to convert
whitespace characters to textual representation.
If this option is not chosen, the characters space
(U+0020) and  tab (U+0009) will not be converted
even if other ASCII characters are.

The characters ethiopic word space (U+1361),
ogham space (U+1680), and ideographic space
(U+3000) will not be converted into their
textual representations but will be converted
to the ASCII space character (U+0020) in order
to make the output pure ASCII.

Leaving whitespace unconverted preserves word
boundaries and the like which is helpful if
you need to visually inspect the text."
balloonhelp_for $GENOPTIONS.tbl.wt $msg

set msg "Select this option to add a space after the ASCII representation
of each character. If you are converting Unicode to ASCII in order
to inspect it, it is generally easier to parse this way.
Typical output will look like this:
0x0074 0x0065 0x0078 0x0074
Leave this option unselected if you want the ASCII representations of
the Unicode to come one right after the other. Typical output
will look like this:
0x00740x00650x00780x0074"
balloonhelp_for $GENOPTIONS.tbl.at $msg

set msg "Select this option if the input text consists entirely
of escapes, separated by whitespace,  with no regular text.
For example, if the Unicode is represented by canonical
hexadecimal numbers, it might look like this:
0x0074 0x0065 0x0078 0x0074
After conversion it would look like this:
text

Leave this option unselected if the input text consists of a mixture
of escapes and regular text. For example, if the Unicode is
represented by canonical hexadecimal numbers, the input text
might look like this:
the symbol 0x0E3F represents the baht, the Thai unit of currency
After conversion it would look like this:
the symbol \u0E3F represents the baht, the Thai unit of currency."
balloonhelp_for $GENOPTIONS.tbl.ipt $msg


set OXP 4
set OYP 2
grid $GENOPTIONS.tbl.pt -row 0 -column 0 -sticky w -padx $OXP -pady $OYP
grid $GENOPTIONS.tbl.nt -row 0 -column 1 -sticky w -padx $OXP -pady $OYP
grid $GENOPTIONS.tbl.wt -row 0 -column 2 -sticky w -padx $OXP -pady $OYP
grid $GENOPTIONS.tbl.at -row 1 -column 0 -sticky w -padx $OXP -pady $OYP
grid $GENOPTIONS.tbl.hu -row 1 -column 1 -sticky w -padx $OXP -pady $OYP
grid $GENOPTIONS.tbl.ipt -row 1 -column 2 -sticky w -padx $OXP -pady $OYP
pack $GENOPTIONS.tit -side top -expand 0 -fill none  -padx 2 -pady {4 2} -anchor w
pack $GENOPTIONS.tbl -side top -expand 1 -fill both  -padx {6 2} -pady {4 6} -anchor w

set DOWNOPTIONS .mf.d
frame $DOWNOPTIONS -border 2 -relief ridge
label $DOWNOPTIONS.tit -text "Character Replacement Options"
frame $DOWNOPTIONS.tbl
checkbutton $DOWNOPTIONS.tbl.sty -text [_ "Stylistic Equivalents"] -variable ConvertStyleP \
    -indicatoron 0
checkbutton $DOWNOPTIONS.tbl.cir -text [_ "Remove Enclosures"]  -variable ConvertEnclosedP \
    -indicatoron 0
checkbutton $DOWNOPTIONS.tbl.dia -text [_ "Strip Diacritics"]   -variable StripDiacriticsP \
    -indicatoron 0
checkbutton $DOWNOPTIONS.tbl.app -text [_ "Approximate"] -variable ConvertApproximateP \
    -indicatoron 0
checkbutton $DOWNOPTIONS.tbl.exp -text [_ "Expand"] -variable ExpandToAsciiP \
    -indicatoron 0
pack $DOWNOPTIONS.tbl.sty $DOWNOPTIONS.tbl.dia  $DOWNOPTIONS.tbl.cir  $DOWNOPTIONS.tbl.app $DOWNOPTIONS.tbl.exp -side left -expand 1 -fill both -padx 6
pack $DOWNOPTIONS.tit -side top -expand 0 -fill none  -padx 2 -pady {4 2} -anchor w
pack $DOWNOPTIONS.tbl -side top -expand 1 -fill both  -padx 2 -pady {4 6}
bind $DOWNOPTIONS.tbl.app <<B3>> ExplainEquivalences
bind $DOWNOPTIONS.tbl.exp <<B3>> ExplainExpansions
set msg "If this option is chosen, characters differing from ASCII characters only
in style, such as bold, italic, full width, and fraktur characters,
are converted to the corresponding ASCII character. "
balloonhelp_for $DOWNOPTIONS.tbl.sty $msg
set msg "If this option is chosen, characters enclosed in circles or parentheses
are converted to their plain equivalents."
balloonhelp_for $DOWNOPTIONS.tbl.cir $msg
set msg "If this option is chosen, combining diacritics are deleted and characters
with intrinsic diacritics are replaced with their plain ASCII equivalents."
balloonhelp_for $DOWNOPTIONS.tbl.dia $msg
set msg "If this option is chosen, characters are replaced with approximate ASCII
equivalents. Right-click for the complete list."
balloonhelp_for $DOWNOPTIONS.tbl.app $msg
set msg "If this option is chosen, certain characters are expanded to sequences of
approximately equivalent plain ASCII characters. The expansions are:
\tU+00A9 \u00A9\tCOPYRIGHT SYMBOL          \t\u2192 (c)
\tU+00DF \u00DF \tSMALL LETTER SHARP S     \t\u2192 ss
\tU+00C6 \u00C6\tCAPITAL LETTER ASH        \t\u2192 AE
\tU+00E6 \u00E6 \tSMALL LETTER ASH         \t\u2192 ae
\tU+01F1 \u01F1\tCAPITAL LETTER DZ         \t\u2192 DZ
\tU+01F3 \u01F3\tSMALLL LETTER DZ          \t\u2192 dz
\tU+02A6 \u02A6 \tSMALLL LETTER TS DIGRAPH \t\u2192 ts
\tU+2026 \u2026 \tHORIZONTAL ELLIPSIS      \t\u2192 ...
\tU+2190 \u2190 \tLEFTWARDS ARROW          \t\u2192 <-
\tU+2192 \u2192 \tRIGHTWARDS ARROW         \t\u2192 ->
\tU+21D0 \u21D0 \tLEFTWARDS DOUBLE ARROW   \t\u2192 <=
\tU+21D2 \u21D2 \tRIGHTWARDS DOUBLE ARROW  \t\u2192 =>
\tU+22EF \u22EF \tMIDLINE HORIZONTAL ELLIPSIS\t\u2192 ..."
balloonhelp_for $DOWNOPTIONS.tbl.exp $msg

set AFORMATS .mf.aformats
frame $AFORMATS -border 2 -relief ridge
label $AFORMATS.tit -text "ASCII Format"
frame $AFORMATS.f
tablelist::tablelist $AFORMATS.f.tl -columns {0 "Description" 0 "Example"} \
    -stretch all -background white -width 60 -height 5 -yscrollcommand {$::AFORMATS.f.sb set} \
    -labelbackground $ColorSpecs(ListHeader,Background) \
    -labelforeground $ColorSpecs(ListHeader,Foreground) \
    -labelactivebackground $ColorSpecs(ListHeader,ActiveBackground) \
    -labelactiveforeground $ColorSpecs(ListHeader,ActiveForeground) \
    -labelcommand DescribeColumn \
    -selectbackground $ColorSpecs(TableList,SelectBackground) \
    -selectforeground $ColorSpecs(TableList,SelectForeground)
$AFORMATS.f.tl columnconfigure 0 -labelalign left
$AFORMATS.f.tl columnconfigure 1 -labelalign left
scrollbar $AFORMATS.f.sb -command {$::AFORMATS.f.tl yview} -activebackground red
pack $AFORMATS.tit -side top -expand 0 -fill none -padx 2 -pady {4 2} -anchor w
pack $AFORMATS.f.sb -side right -expand 0 -fill y    -anchor w
pack $AFORMATS.f.tl -side left  -expand 1 -fill both -anchor w
pack $AFORMATS.f   -side top -expand 1 -fill both -padx 2 -pady {2 4}
bind [$AFORMATS.f.tl bodytag] <<B3>> {+CellInfo}
set cnt 0
foreach o $OptionList {
    $AFORMATS.f.tl insert end \
	[list $AsciiOptions($o,description) $AsciiOptions($o,example)]
    if {$cnt % 2} {
	$AFORMATS.f.tl rowconfigure $cnt -background $ColorSpecs(AsciiOptionEven,Background)
    } else {
	$AFORMATS.f.tl rowconfigure $cnt -background $ColorSpecs(AsciiOptionOdd,Background)
    }
    incr cnt;
}

set msg "Here is where you select the kind of textual
representation that you want to convert to or from."
balloonhelp_for $AFORMATS $msg

set INPUT  .mf.inf
set OUTPUT .mf.ouf
set BPAD   .mf.bpad

#Name of input file
frame  $INPUT -relief ridge -border 1
label  $INPUT.title  -text [_ "Input File"]   -anchor w
set btxt [_ "Browse"]
set blen [string length $btxt];
button $INPUT.brb  -text $btxt -width $blen -anchor w -command SelectInputFile \
    -activeforeground $ColorSpecs(Button,ActiveForeground) \
    -activebackground $ColorSpecs(Button,ActiveBackground)
entry  $INPUT.ent  -foreground $::ColorSpecs(UserTextEntry,Foreground) \
    -background $ColorSpecs(UserTextEntry,Background)\
    -font MainFont -width 30

set ifypd 3
pack $INPUT.title -side top -expand y -fill x -anchor w -pady $ifypd
pack $INPUT.brb  -expand 0 -fill none -anchor w -side left -padx 4 -pady $ifypd
pack $INPUT.ent  -expand 1 -fill x  -anchor w -side left -pady $ifypd -padx 3
set bhmsg [_ "Specify the name of the input file.
You can type the name in the entry
box or choose it interactively by
pressing the Browse button."];
balloonhelp_for $INPUT $bhmsg;
balloonhelp_for $INPUT.title $bhmsg;
balloonhelp_for $INPUT.ent [_ "Input will be read from the file whose name is shown in\nthis entry box. You may enter its name directly or\npress the Browse button and use the file selection dialogue."];
balloonhelp_for $INPUT.brb [_ "Press this button to select the name of the input file."]

#Name of output file
frame  $OUTPUT -relief ridge -border 1
label  $OUTPUT.title  -text [_ "Output File"]   -anchor w
button $OUTPUT.brb  -text $btxt -width $blen -anchor w -command SelectOutputFile \
    -activeforeground $ColorSpecs(Button,ActiveForeground) \
    -activebackground $ColorSpecs(Button,ActiveBackground)
entry  $OUTPUT.ent -foreground $::ColorSpecs(UserTextEntry,Foreground) \
    -background $ColorSpecs(UserTextEntry,Background)\
    -font MainFont -width 30
set ofypd 3
pack $OUTPUT.title -side top -expand y -fill x -anchor w  -pady $ofypd
pack $OUTPUT.brb  -expand 0 -fill none -anchor w -side left -padx 4  -pady $ofypd
pack $OUTPUT.ent  -expand 1 -fill x  -anchor w -side left -pady $ofypd -padx 3
set bhmsg [_ "Specify the name of the output file.
You can type the name in the entry
box or choose it interactively by
pressing the Browse button."];
balloonhelp_for $OUTPUT $bhmsg;
balloonhelp_for $OUTPUT.title $bhmsg;
balloonhelp_for $OUTPUT.ent [_ "Output will be written to the file whose name is shown in\nthis entry box. You may enter its name directly or\npress the Browse button and use the file selection dialogue."];
balloonhelp_for $OUTPUT.brb [_ "Press this button to select the name of the output file."]

set XP 8
set YP 3
pack $MSG        -side top -expand 1 -fill both -padx $XP -pady $YP  -anchor w
pack $WHICHWAY   -side top -expand 1 -fill both -padx $XP -pady $YP  -anchor w
pack $INPUT      -side top -expand 1 -fill both -padx $XP -pady $YP  -anchor w
pack $OUTPUT     -side top -expand 1 -fill both -padx $XP -pady $YP  -anchor w
pack $AFORMATS   -side top -expand 1 -fill both -padx $XP -pady $YP -anchor w
pack $DOWNOPTIONS -side top -expand 1 -fill both -padx $XP -pady $YP -anchor w
pack $GENOPTIONS -side top -expand 1 -fill both -padx $XP -pady [list $YP 8] -anchor w
set WhichWay $WhichWay
wm title . [format [_ "Unicode/Ascii Converter %s \[%s\]"] $Version [ProgramTimeDateStamp]]
#If the default browser is on the list, remove it.
set di [lsearch -exact $BrowserList $DefaultBrowser]
if {$di >= 0} {
    set BrowserList [lreplace $BrowserList $di $di]
}
#Add the default browser to the beginning of the list.
set BrowserList [linsert $BrowserList 0 $DefaultBrowser];
