<?php

require( "lib/auth/" . $config["auth_provider"] . ".authpro.inc.php3" );

Function TWIGLogout( $realm = "TWIG" )
	{
	global $config_dir, $error, $mbox, $config, $img, $version, $vhosts, $SERVER_NAME;

	TWIGCheckAuth( $mbox, 1 );

	TWIGStoreLogin( "", "", 0, 1 );

	TWIGCleanSession();
	TWIGCleanContext();

	if( $config["auth_logout_redirect"] )
		{
		header( "Location: " . $config["auth_logout_redirect"] );
		}

	if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.header.inc.php3");}
	else {include($config_dir . "login.header.inc.php3");}

	if( $error["auth"] ) { TWIGPrintError( $error[auth] ); }

	if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.form.php3") ) {include($vhosts[$SERVER_NAME] . "login.form.php3");}
	else {include($config_dir . "login.form.php3");}

	if( isset( $vhosts[$SERVER_NAME] )&& is_readable($vhosts[$SERVER_NAME] . "login.footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.footer.inc.php3");}
	else {include($config_dir . "login.footer.inc.php3");}

	exit;
	}

// Forms-Based Authentication Method
Function TWIGAuth( $realm = "TWIG", $logout = "" )
	{
	global $config_dir, $session, $login, $error, $config, $login_username, $login_password, $mbox, $version, $img, $vhosts, $SERVER_NAME;

	if( $logout )
		{
		TWIGLogout( $realm );
		}
	else if( !isset( $login_username ) && !isset( $login["username"] ) )
		{
		if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.header.inc.php3");}
		else {include($config_dir . "login.header.inc.php3");}

		if( $error["auth"] ) { TWIGPrintError( $error[auth] ); }

		if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.form.php3") ) {include($vhosts[$SERVER_NAME] . "login.form.inc.php3");}
		else {include($config_dir . "login.form.php3");}

		if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.footer.inc.php3");}
		else {include($config_dir . "login.footer.inc.php3");}

		exit;
		}
	else
		{
		if( isset( $login_username ) )
			{
			$login["username"] = TWIGProcessGPCString($login_username);
			$login["password"] = TWIGProcessGPCString($login_password);
			}

		list($validuser,$mbox) = TWIGCheckAuth( $mbox );

		if( !$validuser ) 
			{
			if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.header.inc.php3");}
			else {include($config_dir . "login.header.inc.php3");}

//			if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
//			else {include($config_dir . "header.inc.php3");}

			TWIGPrintError( "Login failed - Probably a misspelled username or password, please try again." );

			if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.form.php3") ) {include($vhosts[$SERVER_NAME] . "login.form.inc.php3");}
			else {include($config_dir . "login.form.php3");}

//			if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "footer.inc.php3");}
//			else {include($config_dir . "footer.inc.php3");}

			if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "login.footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "login.footer.inc.php3");}
			else {include($config_dir . "login.footer.inc.php3");}

			exit;
			} 
		else
			{
			TWIGStoreLogin( $login["username"], $login["password"], $config["auth_timeout"] );

			return $mbox;
			}
		}
	}

?>
