/* iarray.c */
/*
   This program is free software; you can redistribute it and/or                                                        
   modify it under the terms of the GNU General Public License                                                          
   as published by the Free Software Foundation; either version                                                         
   2 of the License, or (at your option) any later version.                                                             
*/


#ifndef _IARRAY_H
#define _IARRAY_H

typedef struct _GIndexArray GIndexArray;
struct _GIndexArray
{
  gpointer *pdata;
  guint     len;
};


#define     g_index_array_index(array,index) (array->pdata)[index]
GIndexArray* g_index_array_new (void);
void      g_index_array_free (GIndexArray *array, gboolean free_seg);
void      g_index_array_free_all(GIndexArray *array);
void      g_index_array_set_size (GIndexArray *array, gint length);
gpointer  g_index_array_remove_index (GIndexArray *array, guint index);
gpointer  g_index_array_remove_index_fast (GIndexArray *array, guint index);
gboolean  g_index_array_remove (GIndexArray *array, gpointer data);
gboolean  g_index_array_remove_fast (GIndexArray *array, gpointer data);
void      g_index_array_add (GIndexArray *array, gpointer data);


void g_index_array_qsort (GIndexArray *farray, int (*compar)(const void *, const void *));
gpointer *g_index_array_bsearch(GIndexArray *farray, const void *key, int (*compar)(const void *, const void *));
gint g_index_array_bsearch_index(GIndexArray *farray, const void *key, int (*compar)(const void *, const void *));


void g_ptr_array_free_all(GPtrArray *array);
void g_ptr_array_free_items(GPtrArray *array);
void g_ptr_array_qsort (GPtrArray *farray, int (*compar)(const void *, const void *));

#endif
