/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

#ifndef __MICROSTRIP_H
#define __MICROSTRIP_H

#include "transcalc.h"
#include "units.h"
#include "convert.h"

/* type = 0 substrate param
   type = 1 component param
   type = 2 physical param
   type = 3 electrical param
*/

typedef struct _microstrip {
  gfloat er;               /* dielectric constant */
  gfloat mur;              /* mag. permeability */
  gfloat h;                /* height of substrate */
  gfloat ht;               /* height to the top of box */
  gfloat t;                /* thickness of top metal */
  gfloat sigma;            /* Conductivity of the metal */
  gfloat tand;             /* Dielectric Loss Tangent */
  gfloat rough;            /* Roughness of top metal */
  gfloat f;                /* Frequency of operation */
  gfloat w;                /* width of line */
  gfloat l;                /* length of line */
  gfloat Z0;               /* characteristic impedance */
  gfloat ang_l;            /* Electrical length in angle */
  gfloat er_eff;           /* Effective dielectric constant */
  gfloat mur_eff;          /* Effective mag. permeability */
  gfloat w_eff;            /* Effective width of line */
  gfloat atten_dielectric; /* Loss in dielectric (dB) */
  gfloat atten_cond;       /* Loss in conductors (dB) */
  gfloat skindepth;        /* Skin depth in mils */
} microstrip;

gfloat ereff (microstrip *);
gfloat mur_eff (microstrip *);
gfloat w_eff (microstrip *);
gfloat er_eff_freq (microstrip *);
gfloat alpha_c (microstrip *);
gfloat alpha_c_roughness (microstrip *);
gfloat alpha_dielectric (microstrip *);
gfloat char_impedance_ht (microstrip *);
gfloat char_impedance (microstrip *);
gfloat synth_width (microstrip *);
gfloat skin_depth (microstrip *);
void dispersion (microstrip *);
void error_mes (gchar *);
void get_microstrip_sub (trans_win *, microstrip *);
void get_microstrip_comp (trans_win *, microstrip *);
void get_microstrip_phys (trans_win *, microstrip *);
void get_microstrip_elec (trans_win *, microstrip *);
void analyze_microstrip (GtkWidget *, trans_win *);
void synthesize_microstrip (GtkWidget *, trans_win *);
void microstrip_win (GtkWidget *);

#ifndef DATADIR
#define DATADIR "."
#endif


extern void setup_transgui (int, GtkWidget *, trans_win *);
extern void setstatus (GtkWidget *, trans_win *);

#endif

