/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/


#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include <string.h>


void 
pack_image_in_box (GtkWidget *parent, gchar *filename)
{
  GtkWidget *pixmapwid;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  GdkImlibImage *image;
  gint width;
  gint height;



  gdk_imlib_init(); 

  /* Get gdk to use imlib's visual and colormap */
  gtk_widget_push_visual(gdk_imlib_get_visual());
  gtk_widget_push_colormap(gdk_imlib_get_colormap());

  /* Load the image */
  if((image = gdk_imlib_load_image(filename)) == NULL) {
    printf("Image load failed\n");
    exit(-1);
  }

  /* get the width and height of the image  */
  width = image->rgb_width;
  height = image->rgb_height;

  /* render the image */
  if(!gdk_imlib_render(image, width, height)) {
    printf("Image render failed!\n");
    exit(-1);
  }


  /* move the pimap and mask out of the structure, then free it */
  pixmap = gdk_imlib_move_image(image);
  mask = gdk_imlib_move_mask(image);
  gdk_imlib_destroy_image(image);


  pixmapwid = gtk_pixmap_new (pixmap, mask); 
  gtk_box_pack_start (GTK_BOX (parent), pixmapwid, FALSE, FALSE, 0); 
  gtk_widget_show (pixmapwid);


  gdk_imlib_free_pixmap(pixmap);
  gtk_widget_show (parent);
}
