/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* callback_general.c
 * General purpose callbacks
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "transcalc.h"

gint 
delete_event (GtkWidget *widget, GdkEvent *event,
		   gpointer data)
{
  /* If you return FALSE in the "delete_event" signal handler,
   * GTK will emit the "destroy" signal. Returning TRUE means
   * you don't want the window to be destroyed.
   * This is useful for popping up 'are you sure you want to quit?'
   * type dialogs. */

  return FALSE;
}

void 
destroy( GtkWidget *widget,
	      gpointer  data )
{
  gtk_main_quit();
}

void 
setstatus (GtkWidget *widget,
	   trans_win *parent)
	   /*		trans_gui *tg)*/
{
  gchar *textentry;

  /*allocate memory for textentry */
  if ((textentry = (char *) malloc(200*sizeof(char)))  == NULL){
    perror("help text error: malloc");
    return;
  }

  sprintf(textentry,"Parameters changed: Values may be inconsistent");
  statusint = INCONSISTENT;

  gtk_label_set_text (GTK_LABEL (parent->status), textentry);
  free(textentry);

}

