#   Copyright (C) 1987-2004 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Thu Feb 14 08:54:23 2002
#

set ecp_discard 0
set ecp_extbar 0
set ecp_fileVersion "-"

proc tkg_ecpTopLevel {w} {
  frame $w -relief raised -bd 2

  label $w.l -text "[m circ.topmod]:" -justify left
  listbox $w.lb -height 5 -yscrollcommand "$w.sb set"
  scrollbar $w.sb -command "$w.lb yview"

  bind $w.lb <ButtonRelease-1> "tkg_ecpChangeTop %W"

  pack $w.l -padx 3 -pady 3 -anchor w
  pack $w.lb $w.sb -side left -fill y -padx 3 -pady 3
}

proc tkg_ecpFlags {w} {
  global ecp_fileVersion

  frame $w -relief raised -bd 2
  label $w.ver -text "File Version: $ecp_fileVersion" -anchor w

  checkbutton $w.disc -text [m circ.discchg] -anchor w -variable ecp_discard
  checkbutton $w.extbar -text [m circ.extbar] -anchor w -variable ecp_extbar

  pack $w.ver $w.disc $w.extbar -fill both -anchor w -padx 5 -pady 2

  helpon $w.disc [m ho.circuit.discchg]
  helpon $w.extbar [m ho.circuit.extbar]
}

proc tkg_ecpAddScript {w} {
  global simScript_filter simScript_filetypes
  set file [tk_getOpenFile -defaultextension $simScript_filter -filetypes $simScript_filetypes -parent .edcirc]
  if { $file != "" } {
    $w insert end $file
  }
}

proc tkg_ecpDelScript {w} {
  set i [$w curselection]
  if { $i == "" } {
    errmsg [m circ.noscript]
  } {
    set f [$w get $i]
    set result [tk_messageBox -default no -type yesno -icon warning \
		    -message "[m circ.really1] '$f' [m circ.really2]?" ]
      if { $result == "yes" } { $w delete $i }
  }
}

proc tkg_ecpChangeTop {w} {
  set n [$w size]

  set j [$w curselection]

  #
  # Remove mark from old top-level
  #
  for { set i 0 } { $i < $n } { incr i } {
    set s [$w get $i]
    if { [string match "*+" $s] } {
      set s [string trim $s "()"]
      $w delete $i 
      $w insert $i [string trim $s "+"]
    }
  }

  set s [$w get $j]
  $w delete $j 
  $w insert $j "${s}+"
  
  $w selection set $j
  $w see $j

}

proc tkg_ecpScript {w} {
  frame $w -relief raised -bd 2

  label $w.l -text [m circ.iniscript]
  listbox $w.lb -width 40 -height 5 -yscrollcommand "$w.sb set"
  scrollbar $w.sb -command "$w.lb yview"

  button $w.add -text [m b.add] -command "tkg_ecpAddScript $w.lb"
  button $w.del -text [m b.delete] -command "tkg_ecpDelScript $w.lb"
  pack $w.l -anchor w -padx 5 -pady 5
  pack $w.lb $w.sb -side left -padx 3 -pady 3 -fill y
  pack $w.add $w.del -fill both -padx 5 -pady 5

}

#
# Send dialog box contents back to gate 
#
proc tkg_ecpConfirm {w} {
  gat_setCircProp -clearscripts
  set n [$w.script.lb size]
  for { set i 0 } { $i < $n } { incr i } {
    gat_setCircProp -script [$w.script.lb get $i]
  }


  #
  # Remove mark from old top-level
  #
  set n [$w.top.lb size]
  for { set i 0 } { $i < $n } { incr i } {
    set s [$w.top.lb get $i]
    if { [string match "*+" $s] } {
      set s [string trim $s "()"]
      gat_setCircProp -top $s
      tkg_blockListIdxSetRoot $i
    }
  }

  copyVar tkg_discardChanges ecp_discard 
  copyVar tkg_useExtBars ecp_extbar 
}

#
# Fill dialog box with current state
# 
proc tkg_ecpGetState {w} {
  lbCopy .sbar.blklst.f.list $w.top.lb
  set n [$w.top.lb size]
  for { set i 0 } { $i < $n } { incr i } {
    set s [$w.top.lb get $i]
    if { [string match "*+" $s] } {
      set s [string trim $s "()"]
      $w.top.lb delete $i 
      $w.top.lb insert $i $s
      $w.top.lb selection clear 0 end
      $w.top.lb selection set $i

      break
    }
  }
  for { set i 0 } { 1 } { incr i } {
    set f [gat_getCircProp -script $i]
    if { $f == "" } { break }
    $w.script.lb insert end $f
  }
}

proc tkg_editCircProp {} {
  set w .edcirc
  if { [catch { toplevel $w }] } { return }
  wm resizable $w 0 0
  wm title $w "TKGate: Circuit Properties"
  wm geometry $w [offsetgeometry . 50 50]
  wm transient $w .

  copyVar ecp_discard tkg_discardChanges
  copyVar ecp_extbar tkg_useExtBars

  tkg_ecpTopLevel $w.top
  tkg_ecpFlags $w.flags
  tkg_ecpScript $w.script
  okcancel $w.ok "tkg_ecpConfirm $w; destroy $w" "destroy $w"


  pack $w.ok -fill both -side bottom
  pack $w.script -fill both -side bottom
  pack $w.top -fill both -side left
  pack $w.flags -fill both -expand 1

  tkg_ecpGetState $w

  grab set $w
  tkwait window $w
  grab release $w
}

