/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2012
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tickr.h"

void import_params()
{
	GtkWidget	*dialog;
	FILE		*fp1, *fp2;
	char		*file_name;
	char		tmp[TMPSTR_SIZE + 1];
	int		c;

	gtk_window_set_keep_above(GTK_WINDOW(get_ticker_env()->win), FALSE);

	dialog = gtk_file_chooser_dialog_new("Import Preferences", GTK_WINDOW(get_ticker_env()->win),
			GTK_FILE_CHOOSER_ACTION_OPEN,
			/* esc_key_pressed() and force_quit_dialog() in ticker_otherwins.c return
			 * GTK_RESPONSE_CLOSE so we must use it here instead of GTK_RESPONSE_CANCEL */
			GTK_STOCK_CANCEL, GTK_RESPONSE_CLOSE,
			GTK_STOCK_OK, GTK_RESPONSE_OK,
			NULL);

	set_tickr_icon_to_dialog(GTK_WINDOW(dialog));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);

	g_signal_connect(G_OBJECT(dialog), "key-press-event", G_CALLBACK(esc_key_pressed), NULL);
	g_signal_connect(G_OBJECT(dialog), "delete_event", G_CALLBACK(force_quit_dialog), NULL);

	gtk_widget_show_all(dialog);

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {
		if ((file_name = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog))) != NULL) {
			if ((fp1 = g_fopen(file_name, "rb")) != NULL) {
				snprintf(tmp, TMPSTR_SIZE + 1,
					"Preferences are about to be imported from file: %s. "
					"Continue ?", file_name);
				if (question_win(tmp) == YES) {
					if ((fp2 = g_fopen(get_datafile_full_name_from_name(CONFIG_FILE),
						 	"wb")) != NULL) {
						while ((c = fgetc(fp1)) != (int)EOF)
							fputc((int)c, fp2);
						fclose(fp2);
						/* ????
						modify_params2();*/

						current_feed();
						get_ticker_env()->reload_rq = TRUE;
					} else
						warning(FALSE, 4, "Can't save Preferences to file ",
							file_name, ": ", strerror(errno));
				}
				fclose(fp1);
			} else
				warning(FALSE, 4, "Can't open ", file_name, ": ", strerror(errno));
			g_free(file_name);
		}
	}
	gtk_widget_destroy(dialog);
	check_main_win_always_on_top();
}

void export_params()
{
	GtkWidget	*dialog;
	FILE		*fp1, *fp2;
	char		*file_name = NULL;
	int		exit_status = !OK;
	char		tmp[TMPSTR_SIZE + 1];
	int		c;

	if ((fp1 = g_fopen(get_datafile_full_name_from_name(CONFIG_FILE), "rb")) == NULL) {
		save_to_config_file(get_params());
		if ((fp1 = g_fopen(get_datafile_full_name_from_name(CONFIG_FILE), "rb")) == NULL) {
			warning(FALSE, 4, "Can't open file ", get_datafile_full_name_from_name(CONFIG_FILE)
				, ": ", strerror(errno));
			return;
		}
	}

	gtk_window_set_keep_above(GTK_WINDOW(get_ticker_env()->win), FALSE);

	dialog = gtk_file_chooser_dialog_new("Export Preferences", GTK_WINDOW(get_ticker_env()->win),
			GTK_FILE_CHOOSER_ACTION_SAVE,
			/* esc_key_pressed() and force_quit_dialog() in ticker_otherwins.c return
			 * GTK_RESPONSE_CLOSE so we must use it here instead of GTK_RESPONSE_CANCEL */
			GTK_STOCK_CANCEL, GTK_RESPONSE_CLOSE,
			GTK_STOCK_OK, GTK_RESPONSE_OK,
			NULL);

	set_tickr_icon_to_dialog(GTK_WINDOW(dialog));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);

	g_signal_connect(G_OBJECT(dialog), "key-press-event", G_CALLBACK(esc_key_pressed), NULL);
	g_signal_connect(G_OBJECT(dialog), "delete_event", G_CALLBACK(force_quit_dialog), NULL);

	gtk_widget_show_all(dialog);

	/*gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), "~");*/
	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(dialog), CONFIG_FILE);
	gtk_file_chooser_set_do_overwrite_confirmation(GTK_FILE_CHOOSER(dialog), TRUE);

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {
		if ((file_name = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog))) != NULL) {
			if ((fp2 = g_fopen(file_name, "wb")) != NULL) {
				while ((c = fgetc(fp1)) != (int)EOF)
					fputc((int)c, fp2);
				fclose(fp2);
				exit_status = OK;
			} else
				warning(FALSE, 4, "Can't save Preferences to file ",
					file_name, ": ", strerror(errno));
		}
	}
	fclose(fp1);
	gtk_widget_destroy(dialog);
	if (exit_status == OK) {
		snprintf(tmp, TMPSTR_SIZE + 1,
			"\nPreferences have been exported to file: %s\n", file_name);
		info_win("", tmp, INFO, FALSE);
	}
	if (file_name != NULL)
		g_free(file_name);
	check_main_win_always_on_top();
}

#ifndef G_OS_WIN32
void online_help()
{
	char		tmp1[FILE_NAME_MAXLEN + 1];
	char		*help_url = SUPPORT_URL;
	char		*argv[3];
	GPid		pid;
	GError		*error = NULL;

	if (get_params()->open_link_cmd[0] == '\0') {
		/* TODO: should look for default browser */
		warning(FALSE, 2, "Can't launch Browser: no command is defined.\n",
			"Please set the 'Open in Browser' option in the Preferences window.");
		return;
	}
	fprintf(STD_OUT, "Spawning: %s %s\n", get_params()->open_link_cmd, help_url);
	str_n_cpy(tmp1, get_params()->open_link_cmd, FILE_NAME_MAXLEN);
	argv[0] = tmp1;
	argv[1] = help_url;
	argv[2] = NULL;
	if (!g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &pid, &error)) {
		warning(FALSE, 4, APP_NAME": Can't create process ", argv[0], " - ", error->message);
		info_win("", "Please check the 'Open in Browser' option in the Preferences window.",
			INFO_WARNING, FALSE);
	} else
		g_spawn_close_pid(pid);
}
#else
void online_help()
{
	char		*browser_cmd_p, browser_cmd[512], tmp[1024];
	unsigned int	i, count, start = 0, end = 0;
	char		link[] = SUPPORT_URL;
	char		*argv[3];
	GPid		pid;
	GError		*error = NULL;

	if ((browser_cmd_p = (char *)get_default_browser_from_win32registry()) != NULL) {
		/* Find 1st str in browser_cmd */
		str_n_cpy(tmp, browser_cmd_p, 511);
		for (i = 0, count = 0; i < strlen(tmp); i++) {
			if (tmp[i] == '"') {
				count++;
				if (count == 1)
					start = i + 1;
				else if (count == 2)
					end = i - 1;
			}
		}
		str_n_cpy(browser_cmd, tmp + start, MIN((end - start + 1), 511));
		/* Launch browser */
		fprintf(STD_OUT, "Spawning: %s %s\n", browser_cmd, link);
		argv[0] = browser_cmd;
		argv[1] = link;
		argv[2] = NULL;
		if (!g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH,
				NULL, NULL, &pid, &error))
			warning(FALSE, 4, APP_NAME": Can't create process ", argv[0],
				" - ", error->message);
		else
			g_spawn_close_pid(pid);
	}
}
#endif

/*
 * This func's prototype is in libetm / error.h.
 * This func is not defined in libetm but in app and it handles errors
 * from libetm and app.
 *
 * Max number of strings = N_STR_MAX, max string length = STR_MAXLEN.
 * Outstanding stuff (strings and chars) will be ignored.
 */
int big_error(int big_error_code, int n_str, ...)
{
#define N_STR_MAX	8
#define STR_MAXLEN	128

	char		error_str[32 + 32 + (N_STR_MAX * STR_MAXLEN) + 32 + 1];
	va_list	str;
	int		i;

	get_ticker_env()->suspend_rq = TRUE;

	error_str[0] = '\0';
	str_n_cpy(error_str, "CRITICAL ERROR: ", 32);
	if (big_error_code > LIBETM_LASTERRORCODE)
		str_n_cat(error_str, APP_NAME": ", 32);
	n_str = MIN(n_str, N_STR_MAX);
	va_start(str, n_str);
	for (i = 0; i < n_str ; i++)
		str_n_cat(error_str, va_arg(str, char *), STR_MAXLEN);
	va_end(str);
	str_n_cat(error_str, " - Will quit now", 32);

	if (STD_ERR != NULL) {
		fprintf(STD_ERR, "%s\n", error_str);
		fflush(NULL);
	}
	/* We want this win to always popup */
	get_params()->disable_popups = 'n';
	info_win(APP_NAME" - Critical error", error_str, INFO_ERROR, FALSE);
	if (get_resource()->fp != NULL)
		fclose(get_resource()->fp);
	free2(get_ticker_env());
	free2(get_resource());
	free2(get_params());
	exit(big_error_code);
}

/* Will popup and wait for INFO_WIN_WAIT_TIMEOUT ms if wait == TRUE, then close
 * otherwise, will block until an appropriate keyboard/mouse action happens. */
void warning(gboolean wait, int n_str, ...)
{
#define N_STR_MAX	8
#define STR_MAXLEN	128

	char		warning_str[N_STR_MAX * STR_MAXLEN + 1];
	va_list	str;
	int		i;

	warning_str[0] = '\0';
	n_str = MIN(n_str, N_STR_MAX);
	va_start(str, n_str);
	for (i = 0; i < n_str ; i++)
		str_n_cat(warning_str, va_arg(str, char *), STR_MAXLEN);
	va_end(str);

	fprintf(STD_ERR, "%s\n", warning_str);
	fflush(STD_ERR);
	if (!wait)
		info_win("", warning_str, INFO_WARNING, FALSE);
	else
		info_win_wait(warning_str, INFO_WIN_WAIT_TIMEOUT);
}

void dump_font_list()
{
#define NFAMMAX		1024
#define NFACEMAX	16

	PangoFontFamily		**font_fam;
	PangoFontFamily		*font_fam2[NFAMMAX];
	PangoFontFace		**font_face;
	PangoFontFace		*font_face2[NFACEMAX];
	PangoFontDescription	*font_desc;
	char			*font[NFAMMAX * NFACEMAX + 1], *tmp;
	int			n_fam, n_face, i, j, k, overflow, min;

	fprintf(STD_OUT, "List of available fonts on this system:\n");
	font_fam = font_fam2;
	font_face = font_face2;
	overflow = FALSE;
	k = 0;
	pango_font_map_list_families(pango_cairo_font_map_get_default(), &font_fam, &n_fam);
	if (n_fam >= NFAMMAX)
		overflow = TRUE;
	for (i = 0; i < n_fam && i < NFAMMAX; i++) {
		pango_font_family_list_faces(font_fam[i], &font_face, &n_face);
		if (n_face >= NFACEMAX)
			overflow = TRUE;
		for (j = 0; j < n_face && j < NFACEMAX; j++) {
			font_desc = pango_font_face_describe(font_face[j]);
			font[k++] = pango_font_description_to_string(font_desc);
			pango_font_description_free(font_desc);
		}
	}
	font[k] = NULL;
	/* Not sure if we must g_free() sth ? */
	/* Sort array (selection sort) */
	for (i = 0; i < k; i++) {
		min = i;
		for (j = i  + 1; j < k; j++) {
			if (strcmp(font[min], font[j]) > 0)
				min = j;
		}
		tmp = font[i];
		font[i] = font[min];
		font[min] = tmp;
	}
	for (i = 0; i < k; i++) {
		if (font[i] != NULL)
			fprintf(STD_OUT, "%s\n", font[i]);
		else
			break;
	}
	if (overflow)
		fprintf(STD_ERR,
			"In function dump_font_list(): need to allocate more space for array\n"
			"Can't dump full list (more than %d available fonts)\n", k);
	else
		fprintf(STD_OUT, "(%d available fonts)\n", k);
}
