
/******************************************************************************
* MODULE     : line_item.gen.h
* DESCRIPTION: A line in a paragraph consist of an array of line items.
*              A line item contains spacing and hyphenation information.
*              Furthermore, different types of line items exist,
*              in order to typeset brackets, scripts and large operators.
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <boxes.gen.h>
#include <env.gen.h>

#module line_item
#import boxes
#import env

#define OBSOLETE_ITEM          0
#define STD_ITEM               1
#define STRING_ITEM            2
#define LEFT_BRACKET_ITEM      3
#define MIDDLE_BRACKET_ITEM    4
#define RIGHT_BRACKET_ITEM     5
#define CONTROL_ITEM           6
#define FLOAT_ITEM             7

#define LEFT_SUB_ITEM          8
#define LEFT_SUP_ITEM          9
#define RIGHT_SUB_ITEM        10
#define RIGHT_SUP_ITEM        11
#define GLUE_LEFT_SUBS_ITEM   12
#define GLUE_RIGHT_SUBS_ITEM  13
#define GLUE_LEFT_ITEM        14
#define GLUE_RIGHT_ITEM       15
#define GLUE_BOTH_ITEM        16

extern int line_item_count;
class line_item;
class line_item_rep: public concrete_struct {
public:
  int        type;    // type of the line item
  box        b;       // the box
  space      spc;     // separation space
  int        penalty; // penalty for a linebreak after this line_item
  bool       limits;  // line items has limits
  language   lan;     // language for hyphenating strings
  tree       t;       // for control items

  line_item_rep (int type, box b, int penalty);
  line_item_rep (int type, box b, int penalty, language lan);
  line_item_rep (int type, box b, int penalty, tree t);
  ~line_item_rep ();
};

class line_item {
#import concrete_null (line_item, line_item_rep)
  line_item (int type, box b, int penalty);
  line_item (int type, box b, int penalty, language lan);
  line_item (int type, box b, int penalty, tree t);
  bool operator == (line_item item2);
  bool operator != (line_item item2);
};
#import code_concrete_null (line_item, line_item_rep)

ostream& operator << (ostream& out, line_item item);
#define no_tree_converter<line_item>
#import array(line_item)

#endmodule // line_item
