
/******************************************************************************
* MODULE     : format.gen.h
* DESCRIPTION: standard formats for placing material
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <formatter.gen.h>
#include <Format/line_item.gen.h>

#module format
#import formatter
#import line_item

struct format_none_rep: public format_rep {
  format_none_rep ():
    format_rep (FORMAT_NONE) {}
  format_none_rep (format_type ft):
    format_rep (ft) {}
  bool equal (format fm);
  operator tree ();
};

struct format_none {
#import extend_null (format, format_none, format_none_rep)
};
#import code_extend_null (format, format_none, format_none_rep)

struct format_width_rep: public format_rep {
  SI width;
  format_width_rep (SI width2): format_rep (FORMAT_WIDTH), width (width2)
  { ref_count= 1; }
  bool equal (format fm);
  operator tree ();
};

struct format_width {
#import extend_null (format, format_width, format_width_rep)
};
#import code_extend_null (format, format_width, format_width_rep)

struct format_cell_rep: public format_rep {
  SI  width;
  int vpos;
  SI  depth;
  SI  height;
  format_cell_rep (SI w2, int v2, SI d2, SI h2):
    format_rep (FORMAT_CELL),
    width (w2), vpos (v2), depth (d2), height (h2)
  { ref_count= 1; }
  bool equal (format fm);
  operator tree ();
};

struct format_cell {
#import extend (format, format_cell, format_cell_rep)
};
#import code_extend (format, format_cell, format_cell_rep)

struct format_vstream_rep: public format_rep {
  SI width;
  array<line_item> before;
  array<line_item> after;
  format_vstream_rep (SI w2, array<line_item> bef2, array<line_item> aft2):
    format_rep (FORMAT_VSTREAM), width (w2), before (bef2), after (aft2)
  { ref_count= 1; }
  bool equal (format fm);
  operator tree ();
};

struct format_vstream {
#import extend (format, format_vstream, format_vstream_rep)
};
#import code_extend (format, format_vstream, format_vstream_rep)

struct query_vstream_width_rep: public format_rep {
  array<line_item> before;
  array<line_item> after;
  query_vstream_width_rep (array<line_item> bef2, array<line_item> aft2):
    format_rep (QUERY_VSTREAM_WIDTH), before (bef2), after (aft2)
  { ref_count= 1; }
  bool equal (format fm);
  operator tree ();
};

struct query_vstream_width {
#import extend (format, query_vstream_width, query_vstream_width_rep)
};
#import code_extend (format, query_vstream_width, query_vstream_width_rep)

format make_format_vstream (SI w, array<line_item> bef, array<line_item> aft);
format make_query_vstream_width (array<line_item> bef, array<line_item> aft);

#endmodule // format
