
/******************************************************************************
* MODULE     : env_default.gen.cc
* DESCRIPTION: the environment variables and their default values
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <env.gen.h>

#module code_env_default
#import env

/******************************************************************************
* Important environment variables and actions
******************************************************************************/

string DPI ("dpi");
string SFACTOR ("shrinking factor");
string MAGNIFICATION ("magnification");

string PREAMBLE ("preamble");
string MODE ("mode");
string TEXT_LANGUAGE ("language");
string TEXT_FONT ("font");
string TEXT_FAMILY ("font family");
string TEXT_SHAPE ("font shape");
string TEXT_SERIES ("font series");
string MATH_LANGUAGE ("math language");
string MATH_FONT ("math font");
string MATH_FAMILY ("math font family");
string MATH_SHAPE ("math font shape");
string MATH_SERIES ("math font series");
string PROG_LANGUAGE ("prog language");
string PROG_FONT ("prog font");
string PROG_FAMILY ("prog font family");
string PROG_SHAPE ("prog font shape");
string PROG_SERIES ("prog font series");
string FONT_BASE_SIZE ("font base size");
string FONT_SIZE ("font size");
string INDEX_LEVEL ("index level");
string DISPLAY_STYLE ("formula style");
string MATH_CONDENSED ("math condensed");
string VERTICAL_POS ("vertical position");
string COLOR ("color");
string BACKGROUND_COLOR ("background color");
string THIS_SESSION ("this session");

string ATOM_DECORATIONS ("atom decorations");
string LINE_DECORATIONS ("line decorations");
string PAGE_DECORATIONS ("page decorations");
string XOFF_DECORATIONS ("xoff decorations");
string YOFF_DECORATIONS ("yoff decorations");

/******************************************************************************
* Environment variables for paragraphs
******************************************************************************/

string PAR_MODE ("paragraph mode");
string PAR_HYPHEN ("paragraph hyphenation");
string PAR_WIDTH ("paragraph width");
string PAR_LEFT ("left margin");
string PAR_RIGHT ("right margin");
string PAR_FIRST ("first indentation");
string PAR_NO_FIRST ("no first indentation");
string PAR_SEP ("interline space");
string PAR_HOR_SEP ("horizontal ink separation");
string PAR_LINE_SEP ("line stretch");
string PAR_PAR_SEP ("interparagraph space");
string PAR_FNOTE_SEP ("interfootnote space");
string PAR_COLUMNS ("nr columns");
string PAR_COLUMNS_SEP ("column separation");

/******************************************************************************
* Environment variables for pages
******************************************************************************/

string PAGE_MEDIUM ("page medium");
string PAGE_TYPE ("page type");
string PAGE_ORIENTATION ("page orientation");
string PAGE_BREAKING ("page breaking");
string PAGE_FLEXIBILITY ("page flexibility");
string PAGE_NR ("page number");
string PAGE_WIDTH ("page width");
string PAGE_HEIGHT ("page height");
string PAGE_ODD ("odd page margin");
string PAGE_EVEN ("even page margin");
string PAGE_RIGHT ("page right margin");
string PAGE_TOP ("page top margin");
string PAGE_BOT ("page bottom margin");
string PAGE_EXTEND ("page extend");
string PAGE_SHRINK ("page shrink");
string PAGE_HEAD_SEP ("page header separation");
string PAGE_FOOT_SEP ("page footer separation");
string PAGE_ODD_HEADER ("odd page header");
string PAGE_ODD_FOOTER ("odd page footer");
string PAGE_EVEN_HEADER ("even page header");
string PAGE_EVEN_FOOTER ("even page footer");
string PAGE_THIS_HEADER ("this page header");
string PAGE_THIS_FOOTER ("this page footer");
string PAGE_REDUCE_LEFT ("reduction page left margin");
string PAGE_REDUCE_RIGHT ("reduction page right margin");
string PAGE_REDUCE_TOP ("reduction page top margin");
string PAGE_REDUCE_BOT ("reduction page bottom margin");
string PAGE_SHOW_HF ("show header and footer");
string PAGE_FNOTE_SEP ("footnote separation");
string PAGE_FNOTE_BARLEN ("footnote bar length");
string PAGE_FLOAT_SEP ("float separation");
string PAGE_MNOTE_SEP ("marginal note separation");
string PAGE_MNOTE_WIDTH ("marginal note width");

/******************************************************************************
* Environment variables for tables
******************************************************************************/

string TABLE_WIDTH ("table width");
string TABLE_HEIGHT ("table height");
string TABLE_HMODE ("table hmode");
string TABLE_VMODE ("table vmode");
string TABLE_HALIGN ("table halign");
string TABLE_VALIGN ("table valign");
string TABLE_ROW_ORIGIN ("table row origin");
string TABLE_COL_ORIGIN ("table col origin");
string TABLE_LSEP ("table lsep");
string TABLE_RSEP ("table rsep");
string TABLE_BSEP ("table bsep");
string TABLE_TSEP ("table tsep");
string TABLE_LBORDER ("table lborder");
string TABLE_RBORDER ("table rborder");
string TABLE_BBORDER ("table bborder");
string TABLE_TBORDER ("table tborder");
string TABLE_HYPHEN ("table hyphen");
string TABLE_MIN_ROWS ("table min rows");
string TABLE_MIN_COLS ("table min cols");
string TABLE_MAX_ROWS ("table max rows");
string TABLE_MAX_COLS ("table max cols");

/******************************************************************************
* Environment variables for cells of tables
******************************************************************************/

string CELL_FORMAT ("cell format");
string CELL_DECORATION ("cell decoration");
string CELL_BACKGROUND ("cell background");
string CELL_ORIENTATION ("cell orientation");
string CELL_WIDTH ("cell width");
string CELL_HEIGHT ("cell height");
string CELL_HPART ("cell hpart");
string CELL_VPART ("cell vpart");
string CELL_HMODE ("cell hmode");
string CELL_VMODE ("cell vmode");
string CELL_HALIGN ("cell halign");
string CELL_VALIGN ("cell valign");
string CELL_LSEP ("cell lsep");
string CELL_RSEP ("cell rsep");
string CELL_BSEP ("cell bsep");
string CELL_TSEP ("cell tsep");
string CELL_LBORDER ("cell lborder");
string CELL_RBORDER ("cell rborder");
string CELL_BBORDER ("cell bborder");
string CELL_TBORDER ("cell tborder");
string CELL_VCORRECT ("cell vcorrect");
string CELL_HYPHEN ("cell hyphen");
string CELL_ROW_SPAN ("cell row span");
string CELL_COL_SPAN ("cell col span");
string CELL_ROW_NR ("cell row nr");
string CELL_COL_NR ("cell col nr");

/******************************************************************************
* Other variables
******************************************************************************/

string IDENTITY ("identity");
string TABULAR ("tabular");

/******************************************************************************
* Default values
******************************************************************************/

static hashmap<string,tree> default_env (UNINIT);

static void
initialize_default_env () {
  if (N(default_env) != 0) return;
  hashmap<string,tree>& env (default_env);

  tree identity_m (MACRO, "x", tree (ARGUMENT, "x"));
  tree tabular_m (MACRO, "x", tree (TABLE_FORMAT, tree (ARGUMENT, "x")));

  env (DPI)              = "600";       // resolution in dots per inch
  env (SFACTOR)          = "5";         // shrinking factor on screen
  env (MAGNIFICATION)    = "1";         // magnification (slides for instance)

  env (PREAMBLE)         = "false";     // preamble mode ?
  env (MODE)             = "text";      // typesetting mode
  env (TEXT_LANGUAGE)    = "english";   // the language
  env (TEXT_FONT)        = "roman";     // the font name in text mode
  env (TEXT_FAMILY)      = "rm";        // the font family in text mode
  env (TEXT_SERIES)      = "medium";    // the font series in text mode
  env (TEXT_SHAPE)       = "right";     // the font shape in text mode
  env (MATH_LANGUAGE)    = "texmath";   // the default mathematical language
  env (MATH_FONT)        = "roman";     // the font name in math mode
  env (MATH_FAMILY)      = "mr";        // the font family in math mode
  env (MATH_SERIES)      = "medium";    // the font series in math mode
  env (MATH_SHAPE)       = "normal";    // the font shape in math mode
  env (PROG_LANGUAGE)    = "?";         // the default programming language
  env (PROG_FONT)        = "roman";     // the font name in prog mode
  env (PROG_FAMILY)      = "tt";        // the font family in prog mode
  env (PROG_SERIES)      = "medium";    // the font series in prog mode
  env (PROG_SHAPE)       = "right";     // the font shape in prog mode
  env (FONT_BASE_SIZE)   = "10";        // the font base size
  env (FONT_SIZE)        = "1";         // the font size multiplier
  env (INDEX_LEVEL)      = "0";         // the index level (0, 1 or 2)
  env (DISPLAY_STYLE)    = "false";     // true if we are in display style
  env (MATH_CONDENSED)   = "false";     // ignore spaces between operators ?
  env (VERTICAL_POS)     = "0";         // used in fractions (-1, 0 or 1)
  env (COLOR)            = "black";     // the color
  env (BACKGROUND_COLOR) = "white";     // the background color
  env (THIS_SESSION)     = "?";         // computer algebra session name

  env (ATOM_DECORATIONS) = DECORATE_ATOMS; // dots, underln, hyperlinks?, etc.
  env (LINE_DECORATIONS) = DECORATE_LINES; // boxed pars, nested envs, etc.
  env (PAGE_DECORATIONS) = DECORATE_PAGES; // future headers, footers, etc.
  env (XOFF_DECORATIONS) = "0unit";        // hor. placement of decorations
  env (YOFF_DECORATIONS) = "0unit";        // vert. placement of decorations

  env (PAR_MODE)         = "justify";   // outline method
  env (PAR_HYPHEN)       = "normal";    // quality of hyphenation
  env (PAR_WIDTH)        = "15cm";      // width of paragraph
  env (PAR_LEFT)         = "0cm";       // left indentation
  env (PAR_RIGHT)        = "0cm";       // right indentation
  env (PAR_FIRST)        = "1.5fn";     // extra first indentation
  env (PAR_NO_FIRST)     = "false";     // no extra first indent. on next line
  env (PAR_SEP)          = "0.2fn";     // min. vert. spc. between ink
  env (PAR_HOR_SEP)      = "0.5fn";     // min. hor. spc. between ink
  env (PAR_LINE_SEP)     = "0.025fn*";  // extra (small) space between lines
  env (PAR_PAR_SEP)      = "0.5fn*";    // extra space between paragraphs
  env (PAR_FNOTE_SEP)    = "0.2fn";     // min space between diff footnotes
  env (PAR_COLUMNS)      = "1";         // number of columns
  env (PAR_COLUMNS_SEP)  = "2fn";       // separation between columns

  env (PAGE_MEDIUM)      = "papyrus";   // paper medium: paper, papyrus, auto
  env (PAGE_TYPE)        = "a4";        // paper type (-> width & height)
  env (PAGE_ORIENTATION) = "portrait";  // paper orientation
  env (PAGE_BREAKING)    = "optimal";   // quality of page breaking
  env (PAGE_FLEXIBILITY) = "1.0";       // flexibility factor of stretch
  env (PAGE_NR)          = "0";         // the page number
  env (PAGE_ODD)         = "30mm";      // left margin on odd pages
  env (PAGE_EVEN)        = "30mm";      // left margin on even pages
  env (PAGE_RIGHT)       = "30mm";      // right margin in auto mode
  env (PAGE_TOP)         = "30mm";      // top margin
  env (PAGE_BOT)         = "30mm";      // bottom margin
  env (PAGE_SHRINK)      = "1fn";       // emergency page length shrinking
  env (PAGE_BOT)         = "0fn";       // emergency page length extension
  env (PAGE_HEAD_SEP)    = "8mm";       // separation between header and text
  env (PAGE_FOOT_SEP)    = "8mm";       // separation between footer and text
  env (PAGE_ODD_HEADER)  = "";          // header on odd pages
  env (PAGE_ODD_FOOTER)  = "";          // footer on odd pages
  env (PAGE_EVEN_HEADER) = "";          // header on even pages
  env (PAGE_EVEN_FOOTER) = "";          // footer on even pages
  env (PAGE_REDUCE_LEFT) = "25mm";      // screen reduction of left margin
  env (PAGE_REDUCE_RIGHT)= "25mm";      // screen reduction of right margin
  env (PAGE_REDUCE_TOP)  = "15mm";      // screen reduction of top margin
  env (PAGE_REDUCE_BOT)  = "15mm";      // screen reduction of bottom margin
  env (PAGE_SHOW_HF)     = "false";     // show header and footer
  env (PAGE_FNOTE_SEP)   = "1.0fn";     // space between text & footnotes
  env (PAGE_FNOTE_BARLEN)= "7.5fn";     // length of footnote separating bar
  env (PAGE_FLOAT_SEP)   = "1.5fn";     // space between text & floats
  env (PAGE_MNOTE_SEP)   = "5mm";       // space between text & marginal notes
  env (PAGE_MNOTE_WIDTH) = "15mm";      // width of marginal notes

  env (TABLE_WIDTH)      = "";          // width of table
  env (TABLE_HEIGHT)     = "";          // height of table
  env (TABLE_HMODE)      = "";          // width determination mode
  env (TABLE_VMODE)      = "";          // height determination mode
  env (TABLE_HALIGN)     = "l";         // horizontal alignment
  env (TABLE_VALIGN)     = "f";         // vertical alignment (fraction height)
  env (TABLE_ROW_ORIGIN) = "0";         // row origin
  env (TABLE_COL_ORIGIN) = "0";         // column origin
  env (TABLE_LSEP)       = "0fn";       // left padding around table
  env (TABLE_RSEP)       = "0fn";       // right padding around table
  env (TABLE_BSEP)       = "0fn";       // bottom padding around table
  env (TABLE_TSEP)       = "0fn";       // top padding around table
  env (TABLE_LBORDER)    = "0ln";       // left table border width
  env (TABLE_RBORDER)    = "0ln";       // right table border width
  env (TABLE_BBORDER)    = "0ln";       // bottom table border width
  env (TABLE_TBORDER)    = "0ln";       // top table border width
  env (TABLE_HYPHEN)     = "n";         // vertical hyphenation
  env (TABLE_MIN_ROWS)   = "";          // suggested minimal number of rows
  env (TABLE_MIN_COLS)   = "";          // suggested minimal number of columns
  env (TABLE_MAX_ROWS)   = "";          // suggested maximal number of rows
  env (TABLE_MAX_COLS)   = "";          // suggested maximal number of columns

  env (CELL_DECORATION)  = "";          // decorating table of cell
  env (CELL_FORMAT)      = TABLE_FORMAT;// format of cell
  env (CELL_BACKGROUND)  = "";          // background color of cell
  env (CELL_ORIENTATION) = "portrait";  // orientation of cell  
  env (CELL_WIDTH)       = "";          // width of cell
  env (CELL_HEIGHT)      = "";          // height of cell
  env (CELL_HPART)       = "";          // take part of unused horizontal space
  env (CELL_VPART)       = "";          // take part of unused vertical space
  env (CELL_HMODE)       = "exact";     // width determination mode
  env (CELL_VMODE)       = "exact";     // height determination mode
  env (CELL_HALIGN)      = "l";         // horizontal alignment
  env (CELL_VALIGN)      = "B";         // vertical alignment
  env (CELL_LSEP)        = "0fn";       // left cell padding
  env (CELL_RSEP)        = "0fn";       // right cell padding
  env (CELL_BSEP)        = "0fn";       // bottom cell padding
  env (CELL_TSEP)        = "0fn";       // top cell padding
  env (CELL_LBORDER)     = "0ln";       // left cell border width
  env (CELL_RBORDER)     = "0ln";       // right cell border width
  env (CELL_BBORDER)     = "0ln";       // bottom cell border width
  env (CELL_TBORDER)     = "0ln";       // top cell border width
  env (CELL_VCORRECT)    = "a";         // vertical limits correction
  env (CELL_HYPHEN)      = "n";         // horizontal hyphenation
  env (CELL_ROW_SPAN)    = "1";         // row span of cell
  env (CELL_COL_SPAN)    = "1";         // column span of cell
  env (CELL_ROW_NR)      = "1";         // row coordinate of cell
  env (CELL_COL_NR)      = "1";         // column coordinate of cell

  env (IDENTITY)         = identity_m;  // identity macro
  env (TABULAR)          = tabular_m;   // tabular macro
}

#endmodule // code_env_default
