
/******************************************************************************
* MODULE     : tm_widget.gen.cc
* DESCRIPTION: Main current graphical interface for user applications
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <window.gen.h>
#include <widget.gen.h>
#include <tm_widget.gen.h>

#module code_tm_widget
#import window
#import widget
#import tm_widget

#define THIS widget (this)

extern int nr_windows;

/******************************************************************************
* Meta editor constructor and destructor
******************************************************************************/

static widget
make_icon_bar (display dis) {
  array<widget> I (4);
  array<string> I_name (4);
  I[0]= glue_widget (dis, FALSE, FALSE, 3*PIXEL);
  I[1]= horizontal_array (dis, array<widget> (0));
  I[2]= glue_widget (dis, TRUE, FALSE);
  I[3]= glue_widget (dis, FALSE, FALSE, 3*PIXEL);
  I_name[1]= "menu";
  return horizontal_array (dis, I, I_name);
}

static widget
make_icon_bars (display dis, widget bar1, widget bar2, widget bar3) {
  int i=0, nr= (nil(bar1)?0:1) + (nil(bar2)?0:1) + (nil(bar3)?0:1);
  array<widget> K (2*nr+1);
  array<string> K_name (2*nr+1);
  if (nr>0) K[i++]= separator_widget (dis, PIXEL, 2*PIXEL);
  if (!nil (bar1)) {
    K_name[i]= "main";
    K[i++]   = bar1;
    if (nr>1) K[i++]= separator_widget (dis, 2*PIXEL, 2*PIXEL);
  }
  if (!nil (bar2)) {
    K_name[i]= "context";
    K[i++]   = bar2;
    if (!nil (bar3)) K[i++]= separator_widget (dis, 2*PIXEL, 2*PIXEL);
  }
  if (!nil (bar3)) {
    K_name[i]= "user";
    K[i++]   = bar3;
  }
  K[i++]= glue_widget (dis, TRUE, FALSE, 0, 2*PIXEL);
  return vertical_list (dis, K, K_name);
}

tm_widget_rep::tm_widget_rep (server_rep* sv2, display dis):
  basic_widget_rep (dis, 1), sv (sv2),
  cmd_mode (FALSE), text_ptr (NULL)
{
  // setup menu bar
  array<widget> M (2);
  array<string> M_name (2);
  M[0]= horizontal_array (dis, array<widget> (0));
  M[1]= glue_widget (dis, TRUE, FALSE);
  M_name[0]= "menu";
  widget menu_bar= horizontal_array (dis, M, M_name);

  // setup icon bars
  icon_bar  [0]= make_icon_bar (dis);
  icon_bar  [1]= make_icon_bar (dis);
  icon_bar  [2]= make_icon_bar (dis);
  icon_flag [0]= TRUE;
  icon_flag [1]= TRUE;
  icon_flag [2]= FALSE;
  widget icon_bars= make_icon_bars (dis, icon_bar[0], icon_bar[1], widget());

  // setup footer
  array<widget> F (3);
  array<string> F_name (3);
  F[0]= text_widget (dis, "Welcome to TeXmacs!", FALSE, "english");
  F[1]= glue_widget (dis, TRUE, FALSE);
  F[2]= text_widget (dis, "TeXmacs#" * TEXMACS_VERSION, FALSE, "english");
  F_name[0]= "left";
  F_name[1]= "middle";
  F_name[2]= "right";
  widget footer= horizontal_array (dis, F, F_name, 1);
  left  = text_widget (dis, "");
  middle= text_widget (dis, "");
  right = text_widget (dis, "");

  // setup main
  array<widget> V (4);
  array<string> V_name (4);
  V[0]= menu_bar;
  V[1]= icon_bars;
  V[2]= canvas_widget (glue_widget (dis));
  V[3]= footer;
  V_name[0]= "header";
  V_name[1]= "icons";
  V_name[2]= "canvas";
  V_name[3]= "footer";
  a[0]= vertical_list (dis, V, V_name);
}

tm_widget_rep::~tm_widget_rep () {}

widget_rep*
tm_widget_rep::get_this () {
  return this;
}

tm_widget_rep::operator tree () {
  return tree (TUPLE, "TeXmacs window", (tree) a[0]);
}

void
tm_widget_rep::set_window_name (string s) {
  win->set_name (s);
}

void
tm_widget_rep::set_main_menu (widget w) {
  SI ww1= 600*PIXEL, hh1=18*PIXEL, ww2=600*PIXEL, hh2=18*PIXEL;
  w << get_size (ww1, hh1);
  THIS ["header"] ["menu"] << get_size (ww2, hh2);
  THIS ["header"] << set_widget ("menu", w);
  if (attached ()) {
    if (hh1 == hh2) THIS ["header"] << emit_update ();
    else THIS << emit_update ();
  }
}

void
tm_widget_rep::set_icon_menu (int which, widget w) {
  if ((which<0) || (which>2)) return;

  SI ww1= 600*PIXEL, hh1=21*PIXEL, ww2=600*PIXEL, hh2=21*PIXEL;
  w << get_size (ww1, hh1);
  icon_bar [which] ["menu"] << get_size (ww2, hh2);
  icon_bar [which] << set_widget ("menu", w);
  bool global_update= (hh1 != hh2);

  if (icon_flag [which]) {
    widget the_bar;
    switch (which) {
    case 0:
      the_bar= THIS ["icons"] ["main"];
      break;
    case 1:
      the_bar= THIS ["icons"] ["context"];
      break;
    case 2:
      the_bar= THIS ["icons"] ["user"];
      break;
    default:
      return;
    }

    if (attached ()) {
      if (global_update) THIS << emit_update ();
      else the_bar << emit_update ();
    }
  }
}

void
tm_widget_rep::set_icon_flag (int which, bool on) {
  if ((which<0) || (which>2)) return;
  if (icon_flag[which] == on) return;
  icon_flag[which]= on;
  widget icon_bars=
    make_icon_bars (dis,
		    icon_flag[0]? icon_bar[0]: widget (),
		    icon_flag[1]? icon_bar[1]: widget (),
		    icon_flag[2]? icon_bar[2]: widget ());
  THIS << set_widget ("icons", icon_bars);
  if (attached ()) THIS << emit_update ();
}

bool
tm_widget_rep::get_icon_flag (int which) {
  return icon_flag [which];
}

/******************************************************************************
* The footer and executing commands on the bottom line
******************************************************************************/

void
tm_widget_rep::set_left_footer (string s) {
  if (!cmd_mode) {
    widget tw= text_widget (dis, s, FALSE, "english");
    THIS ["footer"] << set_widget ("left", tw);
    THIS ["footer"] << emit_update ();
  }
}

void
tm_widget_rep::set_right_footer (string s) {
  if (!cmd_mode) {
    widget tw= text_widget (dis, s, FALSE, "english");
    THIS ["footer"] << set_widget ("right", tw);
    THIS ["footer"] << emit_update ();
  }
}

class ia_command_rep: public command_rep {
  tm_widget_rep* man;
public:
  ia_command_rep (tm_widget_rep* man2): man (man2) {}
  void apply () { man->interactive_return (); }
  ostream& print (ostream& out) { return out << "tm_widget_rep command"; }
};

void
tm_widget_rep::swap_mode () {
  widget temp;
  temp= left;
  THIS ["footer"] << get_widget ("left", left);
  THIS ["footer"] << set_widget ("left", temp);
  temp= middle;
  THIS ["footer"] << get_widget ("middle", middle);
  THIS ["footer"] << set_widget ("middle", temp);
  temp= right;
  THIS ["footer"] << get_widget ("right", right);
  THIS ["footer"] << set_widget ("right", temp);
  cmd_mode= !cmd_mode;
}

void
tm_widget_rep::interactive (string name, string& s, command cmd) {
  if (cmd_mode) { s= "cancel"; return; }
  call_back= cmd;
  swap_mode ();
  widget tw= text_widget (dis, name, FALSE, "english");
  THIS ["footer"] << set_widget ("left", tw);
  THIS ["footer"] << set_widget ("middle",
		       input_text_widget (dis, new ia_command_rep (this)));
  THIS ["footer"] << emit_update ();
  THIS ["canvas"] << emit_keyboard_focus (FALSE);
  THIS ["footer|middle"] << emit_keyboard_focus (TRUE);
  text_ptr= &s;
}

void
tm_widget_rep::interactive_return () {
  THIS ["footer|middle"] << get_input_string (*text_ptr);
  THIS ["footer|middle"] << emit_keyboard_focus (FALSE);
  text_ptr= NULL;
  THIS ["canvas"] << emit_keyboard_focus (TRUE);
  swap_mode ();
  THIS ["footer"] << emit_update ();
  call_back ();
}

/******************************************************************************
* Handling other events
******************************************************************************/

void
tm_widget_rep::handle_get_size (get_size_event ev) {
  if (ev->mode == 0) {
    ev->w= (800-24) * PIXEL; // (800-32) * PIXEL;
    ev->h= (600-28) * PIXEL;
  }
  else if (ev->mode == 1) {
    ev->w= 8000 * PIXEL;
    ev->h= 6000 * PIXEL;
  }
  else basic_widget_rep::handle_get_size (ev);
}

void
tm_widget_rep::handle_get_widget (get_widget_event ev) {
  a[0] << ev;
}

void
tm_widget_rep::handle_set_widget (set_widget_event ev) {
  a[0] << ev;
}

void
tm_widget_rep::handle_set_string (set_string_event ev) {
  if (ev->which == "left footer") { set_left_footer (ev->s); return; }
  if (ev->which == "right footer") { set_right_footer (ev->s); return; }
  fatal_error ("Could not set string attribute " * ev->which);
}

void
tm_widget_rep::handle_keypress (keypress_event ev) {
  if (cmd_mode) THIS ["footer|middle"] << ev;
  else THIS ["canvas"] << ev;
}

void
tm_widget_rep::handle_mouse (mouse_event ev) {
  basic_widget_rep::handle_mouse (ev);
}

void
tm_widget_rep::handle_keyboard_focus (keyboard_focus_event ev) {
  if (cmd_mode) THIS ["footer|middle"] << ev;
  else THIS ["canvas"] << ev;
}

void
tm_widget_rep::handle_resize (resize_event ev) {
  THIS ["footer|middle"] << ev;
  THIS ["canvas"] << ev;
}

void
tm_widget_rep::handle_destroy (destroy_event ev) {
  tree prg= tuple ("safely-quit-TeXmacs");
  if (nr_windows > 1) prg = tuple ("kill-window");
  sv->exec_delayed (prg);
}

void
tm_widget_rep::handle_alarm (alarm_event ev) {
  if (ev->message == "auto save") sv->auto_save ();
  if (ev->message == "banner") sv->advance_banner ();
}

/******************************************************************************
* Handling standard events
******************************************************************************/

bool
tm_widget_rep::handle (event ev) {
  switch (ev->type) {
  case SET_STRING_EVENT:
    handle_set_string ((set_string_event&) ev);
    return TRUE;
  default:
    return basic_widget_rep::handle (ev);
  }
}

#endmodule // code_tm_widget
