
/******************************************************************************
* MODULE     : timer.gen.h
* DESCRIPTION: timers
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <basic.gen.h>
#include <tm_configure.gen.h>

#module timer
#import basic
#import tm_configure

#os sun
#include <sys/types.h>
#os all

#ifdef USE_GET_TIME_OF_DAY
#include <sys/time.h>
#else
#include <sys/timeb.h>
#os sun
extern "C" {
  extern int ftime __P ((struct timeb *__timebuf));
};
#os all
#endif

time_t texmacs_time ();

struct timer_rep: public concrete_struct {
  time_t begin;
  time_t cumul;

  timer_rep ();
  void   start ();
  void   restart ();
  time_t watch ();
  time_t stop ();
};

class timer {
#import concrete (timer, timer_rep)
  timer ();
};
#import code_concrete (timer, timer_rep)

#endmodule // timer
