
/******************************************************************************
* MODULE     : dir.gen.h
* DESCRIPTION: manipulation of directories
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>

#module dir
#import tree
#import array (string)

void merge_sort (array<string>& a);

array<string> read_directory (string name, bool& error_flag);
string complete_name (array<string> a, string start);
tree   directory_tree (string name, bool& error_flag, bool only_dirs=FALSE);
string make_path (tree dir_tree, bool inner=FALSE);

bool is_regular (string name);
bool is_directory (string name);
bool is_symbolic_link (string name);
bool is_newer (string which, string than);

string working_directory ();
string home_directory ();
void   change_directory (string name);
string merge_paths (string p1, string p2);

extern int default_dpi;
void   make_tex_tfm (string fn_name);
void   make_tex_pk (string fn_name, int dpi, int design_dpi, string where);
string get_tfm_path ();
string get_pk_path ();
void   reset_tfm_path (bool rehash= TRUE);
void   reset_pk_path (bool rehash= TRUE);
bool   use_ec_fonts ();
bool   tex_file_exists (string fn_name);

void   install_tex ();
void   install_texmacs ();

#endmodule // dir
