
/******************************************************************************
* MODULE     : command.gen.h
* DESCRIPTION: Abstract dynamic commands
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tree.gen.h>

#module command
#import tree

extern int command_count;
class command_rep: public abstract_struct {
public:
  inline command_rep () { DEBUG(command_count++); }
  inline virtual ~command_rep () { DEBUG(command_count--); }
  inline virtual ostream& print (ostream& out);
  virtual void apply () = 0;
};

class command {
public:
#import abstract_null (command, command_rep)
  command (void (*routine) (void));
  inline void   operator () (void);
  inline friend ostream& operator << (ostream& out, command cmd);
};
#import code_abstract_null (command, command_rep)

inline ostream& command_rep::print (ostream& out) { return out << "command"; }
inline void     command::operator () (void) { rep->apply(); }
inline ostream& operator << (ostream& out, command cmd) {
  if (nil(cmd)) return out << "(null)"; else return cmd->print(out); }

#endmodule // command
