
/******************************************************************************
* MODULE     : gg_array_string.h
* DESCRIPTION: fixed size arrays with reference counting and
*              pointer copying
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#ifndef _GG_ARRAY_STRING
#define _GG_ARRAY_STRING
#include "gg_string.h"

class array_rep_string {
  int ref_count;
  int n;
  string* a;

public:
  inline array_rep_string (): ref_count (1), n(0), a(NULL) {}
         array_rep_string (int n);
  inline ~array_rep_string () { if (n!=0) delete[] a; }
  inline friend int N ();
         bool contains (string s);
  friend class array_string;
  friend inline int N (array_string a);
  friend inline array_string copy (array_string a);
};

class array_string {
array_rep_string* rep;

public:
  inline array_string (array_rep_string* rep2);
  inline array_string (const array_string& x);
  inline ~array_string ();
  inline array_rep_string* operator -> ();
  inline array_string& operator = (array_string x);
  inline array_string (int n=0): rep (new array_rep_string(n)) {}
  array_string (string *a, int n);
  inline string& operator [] (int i) { return rep->a[i]; }
  void resize (int n2);
};

inline array_string::array_string (array_rep_string* rep2): rep(rep2) {}
inline array_string::array_string (const array_string& x): rep(x.rep) {
  rep->ref_count++; }
inline array_string::~array_string () {
  if ((--rep->ref_count)==0) delete rep; }
inline array_rep_string* array_string::operator -> () { return rep; }
inline array_string& array_string::operator = (array_string x) {
  x.rep->ref_count++;
  if ((--rep->ref_count)==0) delete rep;
  rep=x.rep;
  return *this;
}

inline int N (array_string a) { return a->n; }
inline array_string copy (array_string a) { return array_string (a->a, a->n); }

ostream& operator << (ostream& out, array_string a);
array_string& operator << (array_string& a, string x);
array_string& operator << (array_string& a, array_string b);
bool operator == (array_string a, array_string b);
bool operator != (array_string a, array_string b);

#endif
