
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : main-menu.scm
;; DESCRIPTION : the default main menu of TeXmacs
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The File menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define print-menu
  '(("preview with ghostview" "C-F4" (preview-with-ghostview))
    ---
    ("print all" "F4" (print))
    ("print page selection" "E-F4"
      (interactive '("First page:" "Last page:") 'print-pages))
    ("print all to file" "S-F4"
      (choose-file "Print all to file" "postscript" 'print-to-file))
    ("print page selection to file" "E-S-F4"
      (interactive '("First page:" "Last page:")
		   'choose-file-and-print-page-selection))
    ---
    ("setup printer" "E-C-F4"
      (interactive
        '("Printing command:" "Paper type:" "Printer dpi:")
	'setup-printer))))

(define file-menu
  '(("new" "E-F2" (new-buffer))
    ("load" "F2" (choose-file "Load file" "" 'load-buffer))
    ("save" "F3" (save-buffer))
    ("save as" "S-F3" (choose-file "Save TeXmacs file" "TeXmacs" 'save-buffer))
    ("revert buffer" "C-F2" (revert-buffer))
    ---
    (-> "print" (link print-menu))
    (-> "import"
	("verbatim"
	 (choose-file "Load verbatim file" "" 'load-verbatim-buffer))
	("html" (choose-file "Load html file" "html" 'load-html-buffer))
	("LaTeX" (choose-file "Load LaTeX file" "latex" 'load-latex-buffer))
	("scheme"
	 (choose-file "Load scheme file" "scheme" 'load-scheme-buffer)))
    (-> "export"
	("verbatim"
	 (choose-file "Save verbatim file" "" 'save-verbatim-buffer))
	("LaTeX" (choose-file "Save LaTeX file" "latex" 'save-latex-buffer))
	("scheme"
	 (choose-file "Save scheme file" "scheme" 'save-scheme-buffer))
	("postscript"
	 (choose-file "File postscript file" "postscript" 'export-postscript)))
    ---
    ("open new window" "E-S-F2" (open-window))
    ("clone window" "E-C-F2" (clone-window))
    ("load in new window" "S-F2"
      (choose-file "Load file" "" 'load-in-new-window))
    ---
    ("close buffer" "C-x k" (kill-buffer))
    ("close window" (kill-window))
    ("close TeXmacs" "C-x C-c" (safely-quit-TeXmacs))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Edit menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define edit-menu
  '(("copy" "E-c" (copy "primary"))
    ("cut" "E-x" (cut "primary"))
    ("paste" "E-p" (paste "primary"))
    ("move" "E-v" (move))
    ("clear" "E-r" (selection-clear "primary"))
    ("cancel" "C-g" (selection-cancel))
    ---
    ("search" "C-s" (search-start #t))
    ("replace" "C-="
      (interactive '("Replace:" "Replace by:") 'replace-start-forward))
    ("spell" "E-$" (spell-start))
    ("undo" "E-[" (undo))
    ("redo" "E-]" (redo))
    ---
    (-> "import"
	("TeXmacs" (selection-set-import "TeXmacs"))
	("LaTeX" (selection-set-import "latex"))
	("html" (selection-set-import "html"))
	("scheme" (selection-set-import "scheme"))
	("verbatim" (selection-set-import "verbatim")))
    (-> "export"
	("TeXmacs" (selection-set-export "TeXmacs"))
	("LaTeX" (selection-set-export "latex"))
	("scheme" (selection-set-export "scheme"))
	("verbatim" (selection-set-export "verbatim")))
    (-> "copy to"
	("primary" "E-1 c" (copy "primary"))
	("secondary" "E-2 c" (copy "secondary"))
	("ternary" "E-3 c" (copy "ternary"))
	---
	("other" "E-0 c" (interactive '("Copy to:") 'copy)))
    (-> "cut to"
	("primary" "E-1 x" (cut "primary"))
	("secondary" "E-2 x" (cut "secondary"))
	("ternary" "E-3 x" (cut "ternary"))
	---
	("other" "E-0 x" (interactive '("Cut to:") 'cut)))
    (-> "paste from"
	("primary" "E-1 p" (paste "primary"))
	("secondary" "E-2 p" (paste "secondary"))
	("ternary" "E-3 p" (paste "ternary"))
	---
	("other" "E-0 p" (interactive '("Paste from:") 'paste)))
    (-> "clear selection"
	("primary" "E-1 r" (selection-clear "primary"))
	("secondary" "E-2 r" (selection-clear "secondary"))
	("ternary" "E-3 r" (selection-clear "ternary"))
	---
	("other" "E-0 r"
	 (interactive '("Clear selection:") 'selection-clear)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Insert menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define session-menu '()) ;; each computer algebra system appends its own entry

(define text-mode-insert-menu
  '((if (style-has? "maketitle")
	(-> "title"
	    ("title" (make-inactive-apply-arg "title"))
	    ("author" (make-inactive-apply-arg "author"))
	    ("address" (make-inactive-apply-arg "address"))
	    ("make title" (make-section "maketitle"))
	    ---
	    ("abstract" (make-big-expand "abstract"))))
    (if (style-has? "book-style")
	(-> "chapter"
	    ("chapter" "E-s 0" (make-section-arg "chapter"))
	    ("appendix" (make-section-arg "appendix"))
	    ("prologue" (make-section "prologue"))
	    ("epilogue" (make-section "epilogue"))))
    (if (style-has? "section")
	(-> "section"
	    ("section" "E-s 1" (make-section-arg "section"))
	    ("subsection" "E-s 2" (make-section-arg "subsection"))
	    ("subsubsection" "E-s 3" (make-section-arg "subsubsection"))
	    (if (style-has? "paragraph")
		---
		("paragraph" "E-s 4" (make-section-arg "paragraph"))
		("subparagraph" "E-s 5" (make-section-arg "subparagraph")))))
    (if (style-has? "basic-style")
	(-> "environment"
	    (if (style-has? "theorem-style")
		("theorem" (make-big-expand "theorem"))
		("proposition" (make-big-expand "proposition"))
		("lemma" (make-big-expand "lemma"))
		("corollary" (make-big-expand "corollary"))
		("proof" (make-big-expand "proof"))
		("axiom" (make-big-expand "axiom"))
		("definition" (make-big-expand "definition"))
		---
		("remark" (make-big-expand "remark"))
		("note" (make-big-expand "note"))
		("example" (make-big-expand "example"))
		("exercise" (make-big-expand "exercise"))
		("warning" (make-big-expand "warning"))
		---)
	    ("verbatim" (make-big-expand "verbatim"))
	    ("code" (make-big-expand "code"))
	    ("quote" (make-big-expand "quote"))
	    ("quotation" (make-big-expand "quotation"))
	    ("verse" (make-big-expand "verse"))))
    (if (style-has? "automatic-style")
	(-> "automatic"
	    ("table of contents" (make-aux "table-of-contents" "toc"))
	    ("bibliography" (interactive
	      '("Bibliography style:" "Bibliography file:") 'make-bib))
	    ("index" (make-aux "the-index" "idx"))
	    ("glossary" (make-aux "the-glossary" "gly"))
;;	    ("list of figures" (make-aux "list-of-figures" "lof"))
;;	    ("list of tables" (make-aux "list-of-tables" "lot"))
	    ))
    (-> "mathematics"
	("formula" "$" (make-with "mode" "math"))
	(if (style-has? "basic-style")
	    ("equation"
	     (begin (make-big-expand "equation*") (temp-proof-fix)))
	    ("equations"
	     (begin (make-expand-arg "eqnarray*") (temp-proof-fix)))
	    ("numbered equation"
	     (begin (make-big-expand "equation") (temp-proof-fix)))))
    (if (style-has? "program-style")
	(-> "session"
	    (link session-menu)
	    ---
	    ("other" (interactive
              '("Session type:" "Session name:") 'make-session))))
    (if (style-has? "basic-style")
	---)
    (if (style-has? "list-style")
	(if (or (inside-list?) (inside-description?))
	    ("new item" "E-N" (make-item)))
	(-> "itemize"
	    ("default" "E-I" (make-list "itemize"))
	    ---
	    ("minus" (make-list "itemize-minus"))
	    ("dot" (make-list "itemize-dot"))
	    ("arrow" (make-list "itemize-arrow")))
        (-> "enumerate"
	    ("default" "E-E" (make-list "enumerate"))
	    ---
	    ("1, 2, 3, ..." (make-list "enumerate-numeric"))
	    ("i, ii, iii, ..." (make-list "enumerate-roman"))
	    ("I, II, III, ..." (make-list "enumerate-Roman"))
	    ("a, b, c, ..." (make-list "enumerate-alpha"))
	    ("A, B, C, ..." (make-list "enumerate-Alpha")))
	(-> "description"
	    ("default"  (make-list "description"))))
    (-> "table" (link insert-table-menu))))

(define symbol-menu
  '((-> "large opening bracket" (tile 8 (link left-delimiter-menu)))
    (-> "large separator" (tile 8 (link middle-delimiter-menu)))
    (-> "large closing bracket" (tile 8 (link right-delimiter-menu)))
    (-> "big operator"
	(tile 8 (link big-operator-menu)))
    ---
    (-> "binary operation"
	(tile 8 (link binary-operation-menu)))
    (-> "binary relation"
	(tile 8 (link binary-relation-menu-1))
	---
	(tile 8 (link binary-relation-menu-2)))
    (-> "arrow"
	(tile 9 (link horizontal-arrow-menu))
	---
	(tile 8 (link vertical-arrow-menu))
	---
	(tile 6 (link long-arrow-menu)))
    (-> "negation"
	("general negation" "/" (key-press "/"))
	---
	(tile 6 (link negation-menu)))
    ---
    (-> "greek letter"
	(tile 8 (link lower-greek-menu))
	---
	(tile 8 (link upper-greek-menu)))
    (-> "miscellaneous"
	(tile 8 (link miscellaneous-symbol-menu))
        ---
	(tile 6 (link dots-menu)))))

(define math-mode-insert-menu
  '(("fraction" "E-F" (make-fraction))
    ("square root" "E-S" (make-sqrt))
    ("n-th root" "E-R" (make-var-sqrt))
    ("negation" "E-N" (make-neg))
    ("tree" "E-A" (make-tree))
    ("text" "E-$" (make-with "mode" "text"))
    ---
    (-> "script"
	("left subscript" "E-L _" (make-script #f #f))
	("left superscript" "E-L ^" (make-script #t #f))
	("right subscript" "_" (make-script #f #t))
	("right superscript" "^" (make-script #t #t))
	("script below" (make-below))
	("script above" (make-above)))
    (-> "accent#above"
	("tilda" "E-~" (make-wide "~"))
	("hat" "E-^" (make-wide "^"))
	("bar" "E-B" (make-wide "<bar>"))
	("vector" "E-V" (make-wide "<vect>"))
	("check" "E-C" (make-wide "<check>"))
	("breve" "E-U" (make-wide "<breve>"))
	("acute" "E-\'" (make-wide "<acute>"))
	("grave" "E-`" (make-wide "<grave>")))
    (-> "accent#below"
	("tilda" (make-wide-under "~"))
	("hat" (make-wide-under "^"))
	("bar" (make-wide-under "<bar>"))
	("vector" (make-wide-under "<vect>"))
	("check" (make-wide-under "<check>"))
	("breve" (make-wide-under "<breve>"))
	("acute" (make-wide-under "<acute>"))
	("grave" (make-wide-under "<grave>")))
    (-> "table" (link insert-table-menu))
    (-> "symbol" (link symbol-menu))))

(define insert-table-menu
  '((if (in-text?)
	("small table" (make-expand-arity "small-table" 2))
	("big table" (make-expand-arity "big-table" 2))
	---)
    ("plain tabular" "E-t N t" (make-expand-arg "tabular"))
    ("centered tabular" "E-t N T" (make-expand-arg "tabular*"))
    ("plain block" "E-t N b" (make-expand-arg "block"))
    ("centered block" "E-t N B" (make-expand-arg "block*"))
    (if (in-math?)
	---
	("matrix" "E-t N m" (make-expand-arg "matrix"))
	("determinant" "E-t N d" (make-expand-arg "det"))
	("choice" "E-t N c" (make-expand-arg "choice")))))

(define insert-link-menu
  '(("label" "E-!" (make-inactive-label))
    ("reference" "E-?" (make-inactive-reference))
    ("page reference" (make-inactive-pageref))
    ---
    ("include" "E-i i" (choose-file "Include file" "" 'make-include))
    ("hyperlink" "E-i >" (make-inactive-hyperlink))
    ("action" "E-i *" (make-inactive-action))
    ---
    (-> "citation"
	("visible" (make-inactive-apply-arg "cite"))
	("invisible" (make-inactive-apply-arg "nocite")))
    (-> "index entry"
	("main" (make-inactive-apply-arg "index"))
	("sub" (make-inactive-apply-args "subindex" 2))
	("subsub" (make-inactive-apply-args "subsubindex" 3))
	("complex" (make-inactive-apply-args "index-complex" 4))
	---
	("interjection" (make-inactive-apply-args "index-line" 2)))
    (-> "glossary entry"
	("regular" (make-inactive-apply-arg "glossary"))
	("explained" (make-inactive-apply-args "glossary-explain" 2))
	("duplicate" (make-inactive-apply-arg "glossary-dup"))
	---
	("interjection" (make-inactive-apply-arg "glossary-line")))))

(define insert-image-menu
  '((if (in-text?)
	("small figure" (make-expand-arity "small-figure" 2))
	("big figure" (make-expand-arity "big-figure" 2))
	---)
    ("link image" (choose-file "Load image" "image" 'make-link-image))
    ("insert image" (choose-file "Load image" "image" 'make-inline-image))))

(define insert-page-insertion-menu
  '(("footnote" (make-big-expand "footnote"))
    ---
    ("floating object" (make-insertion "float"))
    ("floating figure" (begin (make-insertion "float")
			      (make-expand-arity "big-figure" 2)))
    ("floating table" (begin (make-insertion "float")
			     (make-expand-arity "big-table" 2)))))

(define position-float-menu
  '((-> "allow"
	("top" (position-insertion "t" #t))
	("here" (position-insertion "h" #t))
	("bottom" (position-insertion "b" #t))
	("other pages" (position-insertion "f" #f)))
    (-> "disallow"
	("top" (position-insertion "t" #f))
	("here" (position-insertion "h" #f))
	("bottom" (position-insertion "b" #f))
	("other pages" (position-insertion "f" #t)))))

(define insert-menu
  '((if (equal? (get-env "mode") "text")
	(link text-mode-insert-menu)
	---)
    (if (equal? (get-env "mode") "math")
	(link math-mode-insert-menu)
	---)
    (-> "space"
	("rigid" (interactive
	  '("Horizontal space:" "Base level:" "Top level:") 'make-var-space))
	(-> "horizontal"
	    ("stretchable" (interactive '("Horizontal space:") 'make-hspace))
	    ("rigid" (interactive '("Horizontal space:") 'make-space))
	    ("tab" (make-htab "5mm")))
	(-> "vertical before"
	    ("small skip" (make-vspace-before "0.5fn"))
	    ("medium skip" (make-vspace-before "1fn"))
	    ("big skip" (make-vspace-before "2fn"))
	    ("other" (interactive '("Vertical space:") 'make-vspace-before)))
	(-> "vertical after"
	    ("small skip" (make-vspace-after "0.5fn"))
	    ("medium skip" (make-vspace-after "1fn"))
	    ("big skip" (make-vspace-after "2fn"))
	    ("other" (interactive '("Vertical space:") 'make-vspace-after))))
    (-> "break"
	("line break" "E-:" (make-format "line break"))
	("new line" "E-;" (make-format "new line"))
	("no line break" "E-/" (make-format "no line break"))
	("page break" (make-page-break))
	("new page" (make-new-page))
	("no page break before" (make-format "no page break before"))
	("no page break after" (make-format "no page break after")))
    (-> "indentation flag"
	("disable indentation before" (make-format "no first indentation"))
	("enable indentation before" (make-format "enable first indentation"))
	---
	("disable indentation after" (make-format "no indentation after"))
	("enable indentation after" (make-format "enable indentation after")))
    (if (and (style-has? "float-style"))
	(if (not (inside? "float"))
	    (-> "page insertion" (link insert-page-insertion-menu)))
	(if (inside? "float")
	    (-> "position float" (link position-float-menu))))
    ---
    (-> "link" (link insert-link-menu))
    (-> "specific"
	("html" (make-inactive-specific "html"))
	("latex" (make-inactive-specific "latex"))
	("tex" (make-inactive-specific "tex"))
	("texmacs" (make-inactive-specific "texmacs")))
    (-> "executable"
	(-> "arithmetic"
	    ("plus" "E-e +" (make-inactive-plus))
	    ("minus" "E-e -" (make-inactive-minus))
	    ("times" "E-e *" (make-inactive-times))
	    ("over" "E-e /" (make-inactive-over))
	    ("div" "E-e d" (make-inactive-div))
	    ("mod" "E-e m" (make-inactive-mod)))
	(-> "text"
	    ("merge" "E-e ;" (make-inactive-merge))
	    ("length" "E-e l" (make-inactive-length))
	    ("range" "E-e ," (make-inactive-range))
	    ("number" "E-e #" (make-inactive-number))
	    ("date" "E-e @" (make-inactive-date))
	    ("formatted date" "E-e E-@" (make-inactive-date))
	    ("translate" "E-e t" (make-inactive-translate)))
	(-> "tuple"
	    ("tuple?" "E-e q" (make-inactive-is-tuple))
	    ("merge" "E-e ;" (make-inactive-merge))
	    ("length" "E-e l" (make-inactive-length))
	    ("range" "E-e ," (make-inactive-range))
	    ("look up" "E-e [" (make-inactive-look-up)))
	(-> "condition"
	    ("not" "E-e !" (make-inactive-not))
	    ("and" "E-e &" (make-inactive-and))
	    ("or" "E-e |" (make-inactive-or))
	    ("exclusive or" "E-e ^" (make-inactive-xor))
	    ---
	    ("equal" "E-e =" (make-inactive-equal))
	    ("not equal" "E-e E-=" (make-inactive-equal))
	    ("less" "E-e <" (make-inactive-less))
	    ("less or equal" "E-e E-<" (make-inactive-lesseq))
	    ("greater" "E-e >" (make-inactive-greater))
	    ("greater or equal" "E-e E->" (make-inactive-greatereq)))
	(-> "programming"
	    ("if" "E-e ?" (make-inactive-if))
	    ("case" "E-e c" (make-inactive-case))
	    ;; ("for" "E-e f" (make-inactive-for))
	    ("while" "E-e w" (make-inactive-while))
	    ;; ("extern" "E-e e" (make-inactive-extern))
	    ;; ("authorize" "E-e a" (make-inactive-authorize))
	    ))
    (-> "image" (link insert-image-menu))
    (-> "special"
	("group" "E-g" (make-group))
	("move object" (interactive '("Horizontal:" "Vertical:") 'make-move))
	("resize object" (interactive
	  '("left:" "bottom:" "right:" "top:") 'make-resize))
	("repeat object" (make-inactive-repeat))
;;	---
	("decorate atoms" (make-inactive-decorate-atoms))
;;	("decorate lines" (make-inactive-decorate-lines))
;;	("decorate pages" (make-inactive-decorate-pages))
;;	---
;;	("page insertion" (make-inactive-float))
	)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Text menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define font-size-menu
  '(("tiny" (make-with "font size" "0.59"))
    ("very small" (make-with "font size" "0.71"))
    ("small" (make-with "font size" "0.84"))
    ("normal" (make-with "font size" "1"))
    ("large" (make-with "font size" "1.19"))
    ("very large" (make-with "font size" "1.41"))
    ("huge" (make-with "font size" "1.68"))
    ("really huge" (make-with "font size" "2"))))

(define text-font-menu
  '((-> "name"
	("roman" (make-with "font" "roman"))
	(if (tex-file-exists? "pnr10.mf")
	    ("pandora" (make-with "font" "pandora")))
	(if (tex-file-exists? "ccr10.mf")
	    ("concrete" (make-with "font" "concrete")))
	---
	(-> "adobe"
	    (if (tex-file-exists? "rpagk.tfm")
		("avant garde" (make-with "font" "avant-garde")))
	    (if (tex-file-exists? "rpbkl.tfm")
		("bookman" (make-with "font" "bookman")))
	    (if (tex-file-exists? "rpzcmi.tfm")
		("chancellary" (make-with "font" "chancellary")))
	    (if (tex-file-exists? "rpcrr.tfm")
		("courier" (make-with "font" "courier")))
	    (if (tex-file-exists? "rpzdr.tfm")
		("dingbat" (make-with "font" "dingbat")))
	    (if (tex-file-exists? "rphvr.tfm")
		("helvetica" (make-with "font" "helvetica")))
	    (if (tex-file-exists? "rpncr.tfm")
		("new century schoolbook"
		  (make-with "font" "new-century-schoolbook")))
	    (if (tex-file-exists? "rpplr.tfm")
		("palatino" (make-with "font" "palatino")))
	    (if (tex-file-exists? "rptmr.tfm")
		("times" (make-with "font" "times"))))
	(-> "latin"
	    (if (tex-file-exists? "callig15.mf")
		("calligraphic" (make-with "font" "calligraphic")))
	    (if (tex-file-exists? "capbas.mf")
		("capbas" (make-with "font" "capbas")))
	    (if (tex-file-exists? "cdr10.mf")
		("Duerer" (make-with "font" "duerer")))
	    (if (tex-file-exists? "hscs10.mf")
		("Hershey" (make-with "font" "hershey")))
	    (if (tex-file-exists? "la14.mf")
		("la" (make-with "font" "la")))
	    (if (tex-file-exists? "cmfi10.mf")
		("messy" (make-with "font" "messy")))
	    (if (tex-file-exists? "ocr10.mf")
		("optical" (make-with "font" "optical")))
	    (if (tex-file-exists? "cpcr10.mf")
		("Pacioli" (make-with "font" "pacioli")))
	    (if (tex-file-exists? "punk20.mf")
		("punk" (make-with "font" "punk")))
	    (if (tex-file-exists? "twcal14.mf")
		("tw#calligraphic" (make-with "font" "twcal")))
	    (if (tex-file-exists? "va14.mf")
		("va" (make-with "font" "va"))))
	(-> "gothic"
	    (if (tex-file-exists? "blackletter.mf")
		("blackletter" (make-with "font" "blackletter")))
	    (if (tex-file-exists? "eufm10.mf")
		("Euler" (make-with "font" "Euler")))
	    (if (tex-file-exists? "ygoth.mf")
		("Gothic" (make-with "font" "gothic")))
	    (if (tex-file-exists? "hge.mf")
		("old English" (make-with "font" "old-english")))
	    (if (tex-file-exists? "schwell.mf")
		("Schwell" (make-with "font" "schwell")))
	    (if (tex-file-exists? "suet14.mf")
		("Suet" (make-with "font" "suet")))
	    (if (tex-file-exists? "yswab.mf")
		("Swab" (make-with "font" "swab"))))
	(-> "foreign"
	    (if (tex-file-exists? "nash14.mf")
		("Arab" (make-with "font" "arab")))
	    (if (tex-file-exists? "artmr10.mf")
		("Armenian" (make-with "font" "armenian")))
	    ("cyrillic" (make-with "font" "cyrillic"))
	    (if (tex-file-exists? "dvng10.mf")
		("Devangari" (make-with "font" "devangari")))
	    (if (tex-file-exists? "mxed.mf")
		(-> "georgian"
		    ("mxedruli" (make-with "font" "mxedruli"))
		    ("xucuri" (make-with "font" "xucuri"))))
	    (if (tex-file-exists? "mrgrrg10.mf")
		("Greek" (make-with "font" "greek")))
	    (if (tex-file-exists? "redis.mf")
		("Hebrew" (make-with "font" "hebrew")))
	    (if (tex-file-exists? "imr10.mf")
		("Icelandic" (make-with "font" "icelandic")))
	    (if (tex-file-exists? "eiadr10.mf")
		("Irish" (make-with "font" "irish")))
	    (if (tex-file-exists? "osmanian.mf")
		("Osmanian" (make-with "font" "osmanian")))
	    (if (tex-file-exists? "wtkr10.mf")
		("Turkish" (make-with "font" "turkish")))
	    (if (tex-file-exists? "wntml10.mf")
		("Tamil" (make-with "font" "tamil")))
	    (if (tex-file-exists? "thairz10.mf")
		("Thai" (make-with "font" "thai")))
	    (if (tex-file-exists? "vmr10.mf")
		("Vietnamese" (make-with "font" "vietnamese"))))
	(-> "archaic"
	    (if (tex-file-exists? "bard.mf")
		("Bard" (make-with "font" "bard")))
	    (if (tex-file-exists? "cypr10.mf")
		("Cypriot" (make-with "font" "cypriot")))
	    (if (tex-file-exists? "etr10.mf")
		("Etruscan" (make-with "font" "etruscan")))
	    (if (tex-file-exists? "givbc10.mf")
		(-> "Greek"
		    ("4th century bc" (make-with "font" "greek4cbc"))
		    ("6th century bc" (make-with "font" "greek6cbc"))))
	    (if (tex-file-exists? "linb10.mf")
		("Linear beta" (make-with "font" "linearb")))
	    (if (tex-file-exists? "ogham.mf")
		("Ogham" (make-with "font" "ogham")))
	    (if (tex-file-exists? "phnc10.mf")
		("Phoenician" (make-with "font" "phoenician")))
	    (if (tex-file-exists? "fut10.mf")
		(-> "Runic"
		    ("default" (make-with "font" "runic"))
		    ("Futhark" (make-with "font" "runic*"))
		    ("Futhork" (make-with "font" "runic**"))))
	    ;; ("south arabian" (make-with "font" "southarabian"))
	    ;; ("syriac" (make-with "font" "syriac"))
	    (if (tex-file-exists? "izhitsa.mf")
		("old Slavonic" (make-with "font" "old-slavonic")))
	    (if (tex-file-exists? "ugaritic.mf")
		("Ugaritic" (make-with "font" "ugaritic"))))
	(-> "phantasy"
	    (if (tex-file-exists? "cherokee.mf")
		("Cherokee" (make-with "font" "cherokee")))
	    (if (tex-file-exists? "shavian.mf")
		("Shavian" (make-with "font" "shavian")))
	    (if (tex-file-exists? "tengwar.mf")
		("Tengwar" (make-with "font" "tengwar"))))
	(-> "miscellaneous"
	    (if (tex-file-exists? "dancers.mf")
		("dancers" (make-with "font" "dancers")))
	    (if (tex-file-exists? "bbding10.mf")
		("dingbat" (make-with "font" "bbding")))
	    (if (tex-file-exists? "go10.mf")
		("go" (make-with "font" "go")))
	    (if (tex-file-exists? "iching.mf")
		("iching" (make-with "font" "iching")))
	    (if (tex-file-exists? "karta15.mf")
		("karta" (make-with "font" "karta")))
	    (if (tex-file-exists? "klinz.mf")
		("klinz" (make-with "font" "klinz")))
	    (if (tex-file-exists? "magic.mf")
		("magic" (make-with "font" "magic")))
	    (if (tex-file-exists? "cmph10.mf")
		("phonetic" (make-with "font" "phonetic")))
	    (if (tex-file-exists? "tsipa10.mf")
		("tsipa" (make-with "font" "tsipa")))
	    (if (tex-file-exists? "wsuipa10.mf")
		("wsuipa" (make-with "font" "wsuipa"))))
	(-> "X-windows"
	    ("times" (make-with "font" "x-times"))
	    ("courier" (make-with "font" "x-courier"))
	    ("helvetica" (make-with "font" "x-helvetica"))
	    ("utopia" (make-with "font" "x-utopia"))
	    ("lucida" (make-with "font" "x-lucida"))))
    (-> "family"
	("roman" (make-with "font family" "rm"))
	("typewriter" "E-C-t" (make-with "font family" "tt"))
	("sans serif" "E-C-s" (make-with "font family" "ss")))
    (-> "series"
	("light" (make-with "font series" "light"))
	("medium" (make-with "font series" "medium"))
	("bold" "E-C-b" (make-with "font series" "bold")))
    (-> "shape"
	("right" "E-C-r" (make-with "font shape" "right"))
	("slanted" "E-C-l" (make-with "font shape" "slanted"))
	("italic" "E-C-i" (make-with "font shape" "italic"))
	("left slanted" (make-with "font shape" "left-slanted"))
	---
	("small caps" "E-C-p" (make-with "font shape" "small-caps"))
	("proportional" (make-with "font shape" "proportional"))
	("condensed" (make-with "font shape" "condensed"))
	("flat" (make-with "font shape" "flat"))
	("long" (make-with "font shape" "long")))
    (-> "size" (link font-size-menu))))

(define math-font-menu
  '((-> "name"
	("roman" "E-C-R" (make-with "math font" "roman"))
	(if (tex-file-exists? "ccr10.mf")
	    ("concrete" (make-with "math font" "concrete")))
	(if (tex-file-exists? "eurm10.mf")
	    ("new roman" "E-C-E" (make-with "math font" "ENR")))
	---
	(if (tex-file-exists? "rpsyr.tfm")
	    ("adobe" (make-with "math font" "adobe")))
	(if (tex-file-exists? "cdr10.mf")
	    ("Duerer" (make-with "math font" "Duerer")))
	(if (tex-file-exists? "eufm10.mf")
	    ("Euler" "E-C-F" (make-with "math font" "Euler")))
	(-> "calligraphic"
	    ("default" "E-C-C" (make-with "math font" "cal"))
	    (if (tex-file-exists? "euxm10.mf")
		("Euler" (make-with "math font" "cal**")))
	    (if (tex-file-exists? "rsfs10.mf")
		("Ralph Smith's" (make-with "math font" "cal*"))))
	(-> "blackboard bold"
	    ("default" "E-C-B" (make-with "math font" "Bbb*"))
	    (if (tex-file-exists? "msbm10.mf")
		("A.M.S." (make-with "math font" "Bbb")))
	    (if (tex-file-exists? "bbold10.mf")
		("blackboard bold" (make-with "math font" "Bbb**")))
	    (if (tex-file-exists? "ocmr10.mf")
		("outlined roman" (make-with "math font" "Bbb***")))
	    (if (tex-file-exists? "dsrom10.mf")
		("double stroke" (make-with "math font" "Bbb****")))))
    (if (real-math-font? (get-env "math font"))
	(-> "family"
	    ("roman" (make-with "math font family" "mr"))
	    ("typewriter" (make-with "math font family" "mt"))
	    ("sans serif" (make-with "math font family" "ms"))
	    ---
	    (-> "text font"
		("roman" (make-with "math font family" "rm"))
		("typewriter" (make-with "math font family" "tt"))
		("sans serif" (make-with "math font family" "ss"))
		("bold" (make-with "math font family" "bf"))
		("right" (make-with "math font family" "up"))
		("slanted" (make-with "math font family" "sl"))
		("italic" (make-with "math font family" "it"))))
	(if (real-math-family? (get-env "math font family"))
	    (-> "series"
		("light" (make-with "math font series" "light"))
		("medium" (make-with "math font series" "medium"))
		("bold" "E-C-b" (make-with "math font series" "bold")))))
    (if (not (real-math-font? (get-env "math font")))
	(-> "family"
	    ("roman" (make-with "math font family" "mr"))
	    ("typewriter" (make-with "math font family" "mt"))
	    ("sans serif" (make-with "math font family" "ms")))
	(-> "series"
	    ("medium" (make-with "math font series" "medium"))
	    ("bold" "E-C-b" (make-with "math font series" "bold")))
	(-> "shape"
	    ("default" (make-with "math font shape" "normal"))
	    ("right" (make-with "math font shape" "right"))
	    ("slanted" (make-with "math font shape" "slanted"))
	    ("italic" (make-with "math font shape" "italic"))))
    (-> "size" (link font-size-menu))))

(define prog-font-menu
  '((-> "name"
	("roman" (make-with "prog font" "roman"))
	(if (tex-file-exists? "ccr10.mf")
	    ("concrete" (make-with "prog font" "concrete")))
	(if (tex-file-exists? "pnr10.mf")
	    ("pandora" (make-with "prog font" "pandora"))))
    (-> "family"
	("roman" (make-with "prog font family" "rm"))
	("typewriter" (make-with "prog font family" "tt"))
	("sans serif" (make-with "prog font family" "ss")))
    (-> "series"
	("medium" (make-with "prog font series" "medium"))
	("bold" (make-with "prog font series" "bold")))
    (-> "shape"
	("default" (make-with "prog font shape" "normal"))
	("right" (make-with "prog font shape" "right"))
	("slanted" (make-with "prog font shape" "slanted"))
	("italic" (make-with "prog font shape" "italic")))
    (-> "size" (link font-size-menu))))

(define color-menu
  '(("black" (make-with "color" "black"))
    ("white" (make-with "color" "white"))
    ("grey" (make-with "color" "grey"))
    ("red" (make-with "color" "red"))
    ("blue" (make-with "color" "blue"))
    ("yellow" (make-with "color" "yellow"))
    ("green" (make-with "color" "green"))
    ("orange" (make-with "color" "orange"))
    ("magenta" (make-with "color" "magenta"))
    ("brown" (make-with "color" "brown"))
    ("pink" (make-with "color" "pink"))))

(define text-menu
  '((if (equal? (get-env "mode") "text")
	(-> "font" (link text-font-menu)))
    (if (equal? (get-env "mode") "math")
	(-> "font" (link math-font-menu)))
    (if (equal? (get-env "mode") "prog")
	(-> "font" (link prog-font-menu)))
    (-> "color" (link color-menu))
    (-> "language"
	("British" (make-with "language" "british"))
	("Czech" (make-with "language" "czech"))
	("Dutch" (make-with "language" "dutch"))
	("English" (make-with "language" "english"))
	("French" (make-with "language" "french"))
	("German" (make-with "language" "german"))
	("Hungarian" (make-with "language" "hungarian"))
	("Polish" (make-with "language" "polish"))
	("Portuguese" (make-with "language" "portuguese"))
	("Romanian" (make-with "language" "romanian"))
	("Russian"
	 (begin
	   (make-with "language" "russian")
	   (make-with "font" "cyrillic")))
	("Spanish" (make-with "language" "spanish"))
	("Swedish" (make-with "language" "swedish"))
	("Ukrainian"
	 (begin
	   (make-with "language" "ukrainian")
	   (make-with "font" "cyrillic"))))
    (if (equal? (get-env "mode") "math")
	---
	(-> "index level"
	    ("normal" (make-with "index level" "0"))
	    ("script size" (make-with "index level" "1"))
	    ("script script size" (make-with "index level" "2")))
	(-> "formula style"
	    ("on" (make-with "formula style" "true"))
	    ("off" (make-with "formula style" "false")))
	(-> "condensed"
	    ("on" (make-with "math condensed" "true"))
	    ("off" (make-with "math condensed" "false"))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Paragraph menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define paragraph-menu
  '((-> "style"
	("justified" (make-line-with "paragraph mode" "justify"))
	("left ragged" (make-line-with "paragraph mode" "left"))
	("centered" (make-line-with "paragraph mode" "center"))
	("right ragged" (make-line-with "paragraph mode" "right")))
    (-> "hyphenation"
	("normal" (make-line-with "paragraph hyphenation" "normal"))
	("professional"
	 (make-line-with "paragraph hyphenation" "professional")))
    (-> "margins"
	("left margin" (interactive '("Left margin:") 'set-left-margin))
	("right margin" (interactive '("Right margin:") 'set-right-margin))
	("first indentation"
	 (interactive '("First indentation:") 'set-first-indent)))
    (-> "spacing"
	("interline separation"
	 (interactive '("Separation between lines:") 'set-interline))
	("interline space"
	 (interactive '("Space between lines:") 'set-interline-spc))
	("interparagraph space"
	 (interactive '("Space between paragraphs:") 'set-interpar-spc)))
    (-> "number of columns"
	("1" (make-line-with "nr columns" "1"))
	("2" (make-line-with "nr columns" "2"))
	("3" (make-line-with "nr columns" "3")))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The table menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define table-special-menu
  '(("deactivate" "E-t *" (table-disactivate))
    ("set extension center" "E-t home" (table-format-center))
    ("extract format" (table-extract-format))
    ---
    ("use paragraph width" "E-t H p" (table-use-paragraph-width))
    ("width" "E-t H w" (table-set-width-ia))
    ("height" "E-t V h" (table-set-height-ia))
    ---
    (-> "border"
	("border" "E-t B =" (table-set-border-ia))
	("left border" "E-t B l" (table-set-lborder-ia))
	("right border" "E-t B r" (table-set-rborder-ia))
	("bottom border" "E-t B b" (table-set-bborder-ia))
	("top border" "E-t B t" (table-set-tborder-ia))
	---
	("padding" "E-t P =" (table-set-padding-ia))
	("left padding" "E-t P l" (table-set-lpadding-ia))
	("right padding" "E-t P r" (table-set-rpadding-ia))
	("bottom padding" "E-t P b" (table-set-bpadding-ia))
	("top padding" "E-t P t" (table-set-tpadding-ia)))
    (-> "hyphenation"
	("off" (table-set-hyphen "n"))
	("on" (table-set-hyphen "y")))
;;  (-> "origin"
;;	("row" "E-t O r" (table-set-row-origin-ia))
;;	("column" "E-t O c" (table-set-column-origin-ia)))
    (-> "size limits"
	("minimal number of rows" "E-t L r" (table-set-min-rows-ia))
	("minimal number of columns" "E-t L c" (table-set-min-columns-ia))
	("maximal number of rows" "E-t L R" (table-set-max-rows-ia))
	("maximal number of columns" "E-t L C" (table-set-max-columns-ia)))))

(define cell-border-menu
  '(("border" "E-t b =" (cell-set-border-ia))
    ("left border" "E-t b l" (cell-set-lborder-ia))
    ("right border" "E-t b r" (cell-set-rborder-ia))
    ("bottom border" "E-t b b" (cell-set-bborder-ia))
    ("top border" "E-t b t" (cell-set-tborder-ia))
    ---
    ("padding" "E-t p =" (cell-set-padding-ia))
    ("left padding" "E-t p l" (cell-set-lpadding-ia))
    ("right padding" "E-t p r" (cell-set-rpadding-ia))
    ("bottom padding" "E-t p b" (cell-set-bpadding-ia))
    ("top padding" "E-t p t" (cell-set-tpadding-ia))))

(define cell-color-menu
  '(("black" (cell-set-background "black"))
    ("white" (cell-set-background "white"))
    ("grey" (cell-set-background "grey"))
    ("red" (cell-set-background "red"))
    ("blue" (cell-set-background "blue"))
    ("yellow" (cell-set-background "yellow"))
    ("green" (cell-set-background "green"))
    ("orange" (cell-set-background "orange"))
    ("magenta" (cell-set-background "magenta"))
    ("brown" (cell-set-background "brown"))
    ("pink" (cell-set-background "pink"))
    ---
    ("foreground" (cell-set-background "foreground"))))

(define cell-special-menu
  '(("set span" "E-t s" (cell-set-span-ia))
    ("subtable" "E-t S" (make-sub-table))
    ---
    (-> "text height correction"
	("off" (cell-set-vcorrect "n"))
	---
	("bottom" (cell-set-vcorrect "b"))
	("top" (cell-set-vcorrect "t"))
	("both" (cell-set-vcorrect "a")))
    (-> "hyphenation"
	("off" (cell-set-hyphen "n"))
	---
	("top" (cell-set-hyphen "t"))
	("center" (cell-set-hyphen "c"))
	("bottom" (cell-set-hyphen "b"))
	---
	("single-paragraph" (cell-multi-paragraph #f))
	("multi-paragraph" (cell-multi-paragraph #t)))
    (-> "distribute unused space"
	("horizontal part" (cell-set-hpart-ia))
	("vertical part" (cell-set-vpart-ia)))
    (-> "glue decorations" (tile 2 (link texmacs-cell-decoration-icons)))))

(define table-menu
  '((-> "insert row"
	("above" "E-up" (table-insert-row #f))
	("below" "E-down" (table-insert-row #t)))
    (-> "insert column"
	("to the left" "E-left" (table-insert-column #f))
	("to the right" "E-right" (table-insert-column #t)))
    (-> "horizontal table alignment"
	("at the left" "E-t H l" (table-set-halign "l"))
	("at the middle" "E-t H c" (table-set-halign "c"))
	("at the right" "E-t H r" (table-set-halign "r")))
    (-> "vertical table alignment"
	("at the bottom" "E-t V b" (table-set-valign "b"))
	("at the middle" "E-t V c" (table-set-valign "c"))
	("at fraction bar height" "E-t V f" (table-set-valign "f"))
	("at the top" "E-t V t" (table-set-valign "t")))
    (-> "special table properties" (link table-special-menu))
    ---
    (-> "cell operation mode"
	("on cells" "E-t m e" (set-cell-mode "cell"))
	("on rows" "E-t m r" (set-cell-mode "row"))
	("on columns" "E-t m c" (set-cell-mode "column"))
	("on entire table" "E-t m t" (set-cell-mode "table")))
    (-> "horizontal cell alignment"
	("to the left" "E-t h l" (cell-set-halign "l"))
	("centered" "E-t h c" (cell-set-halign "c"))
	("at the baseline" "E-t h R" (cell-set-halign "R"))
	("to the right" "E-t h r" (cell-set-halign "r")))
    (-> "vertical cell alignment"
	("at the bottom" "E-t v b" (cell-set-valign "b"))
	("at the baseline" "E-t v B" (cell-set-valign "B"))
	("centered" "E-t v c" (cell-set-valign "c"))
	("at the top" "E-t v b" (cell-set-valign "b")))
    (-> "cell width"
	("set width" "E-t h w" (cell-set-width-ia))
	---
	("minimum mode" "E-t h m" (cell-set-hmode "min"))
	("exact mode" "E-t h e" (cell-set-hmode "exact"))
	("maximum mode" "E-t h M" (cell-set-hmode "max")))
    (-> "cell height"
	("set height" "E-t v h" (cell-set-height-ia))
	---
	("minimum mode" "E-t v m" (cell-set-vmode "min"))
	("exact mode" "E-t v e" (cell-set-vmode "exact"))
	("maximum mode" "E-t v M" (cell-set-vmode "max")))
    (-> "cell border" (link cell-border-menu))
    (-> "cell background color" (link cell-color-menu))
    (-> "special cell properties" (link cell-special-menu))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Document menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define style-menu
  '(("letter" (init-style "letter"))
    ("article" (init-style "article"))
    ("book" (init-style "book"))
    ("seminar" (init-style "seminar"))
    ("browser" (init-style "browser"))))

(define use-package-menu
  '(("basic" (init-extra-style "basic"))
    ("list" (init-extra-style "list"))
    ("theorem" (init-extra-style "theorem"))
    ("program" (init-extra-style "program"))
    ("automatic" (init-extra-style "automatic"))
    ("float" (init-extra-style "float"))))

(define document-menu
  '((-> "style"
	("none" (init-style "none"))
	---
	(link style-menu)
	---
	("other" (interactive '("Document style:") 'init-style)))
    (-> "use package"
	(link use-package-menu)
	---
	("other" (interactive '("Use package:") 'init-extra-style)))
    (-> "master"
	("attach" (interactive
		   '("Master file:") 'project-attach))
	("detach" (project-detach)))
    ---
    (-> "font"
	(-> "text font"
	    ("default" (init-default "font"))
	    ---
	    ("roman" (init-env "font" "roman"))
	    ("pandora" (init-env "font" "pandora"))
	    ("concrete" (init-env "font" "concrete"))
	    ("cyrillic" (init-env "font" "cyrillic"))
	    ---
	    ("bookman" (init-env "font" "bookman"))
	    ("courier" (init-env "font" "courier"))
	    ("helvetica" (init-env "font" "helvetica"))
	    ("palatino" (init-env "font" "palatino"))
	    ("times" (init-env "font" "times"))
	    ---
	    ("lucida" (init-env "font" "x-lucida"))
	    ("utopia" (init-env "font" "x-utopia")))
	(-> "math font"
	    ("default" (init-default "math font"))
	    ---
	    ("roman" (init-env "math font" "roman"))
	    ("concrete" (init-env "math font" "concrete"))
	    ("Euler new roman" (init-env "math font" "ENR"))
	    ("adobe" (init-env "math font" "adobe")))
	(-> "prog font"
	    ("default" (init-default "prog font"))
	    ---
	    ("roman" (init-env "prog font" "roman"))
	    ("pandora" (init-env "prog font" "pandora"))
	    ("concrete" (init-env "prog font" "concrete"))
	    ("times" (init-env "prog font" "times")))
	---
	(-> "size"
	    ("default" (init-default "font base size"))
	    ---
	    ("8" (init-env "font base size" "8"))
	    ("9" (init-env "font base size" "9"))
	    ("10" (init-env "font base size" "10"))
	    ("11" (init-env "font base size" "11"))
	    ("12" (init-env "font base size" "12"))
	    ("14" (init-env "font base size" "14"))
	    ---
	    ("other" (interactive '("Font size:") 'init-font-size)))
	(-> "dpi"
	    ("default" (init-default "dpi"))
	    ---
	    ("150" (init-env "dpi" "150"))
	    ("200" (init-env "dpi" "200"))
	    ("300" (init-env "dpi" "300"))
	    ("400" (init-env "dpi" "400"))
	    ("600" (init-env "dpi" "600"))
	    ("800" (init-env "dpi" "800"))
	    ("1200" (init-env "dpi" "1200"))
	    ---
	    ("other" (interactive '("Font dpi:") 'init-dpi))))
    (-> "color"
	(-> "foreground"
	    ("black" (init-env "color" "black"))
	    ("white" (init-env "color" "white"))
	    ("grey" (init-env "color" "grey"))
	    ("red" (init-env "color" "red"))
	    ("blue" (init-env "color" "blue"))
	    ("yellow" (init-env "color" "yellow"))
	    ("green" (init-env "color" "green"))
	    ("orange" (init-env "color" "orange"))
	    ("magenta" (init-env "color" "magenta"))
	    ("brown" (init-env "color" "brown"))
	    ("pink" (init-env "color" "pink")))
	(-> "background"
	    ("black" (init-env "background color" "black"))
	    ("white" (init-env "background color" "white"))
	    ("grey" (init-env "background color" "grey"))
	    ("red" (init-env "background color" "red"))
	    ("blue" (init-env "background color" "blue"))
	    ("yellow" (init-env "background color" "yellow"))
	    ("green" (init-env "background color" "green"))
	    ("orange" (init-env "background color" "orange"))
	    ("magenta" (init-env "background color" "magenta"))
	    ("brown" (init-env "background color" "brown"))
	    ("pink" (init-env "background color" "pink"))
	    ("light grey" (init-env "background color" "light grey"))
	    ("dark grey" (init-env "background color" "dark grey"))
	    ("broken white" (init-env "background color" "broken white"))))
    (-> "language"
	("default" (init-default "language"))
	---
	("British" (init-env "language" "british"))
	("Czech" (init-env "language" "czech"))
	("Dutch" (init-env "language" "dutch"))
	("English" (init-env "language" "english"))
	("French" (init-env "language" "french"))
	("German" (init-env "language" "german"))
	("Hungarian" (init-env "language" "hungarian"))
	("Polish" (init-env "language" "polish"))
	("Portuguese" (init-env "language" "portuguese"))
	("Romanian" (init-env "language" "romanian"))
	("Russian"
	 (begin
	   (init-env "language" "russian")
	   (init-env "font" "cyrillic")))
	("Spanish" (init-env "language" "spanish"))
	("Swedish" (init-env "language" "swedish"))
	("Ukrainian"
	 (begin
	   (init-env "language" "ukrainian")
	   (init-env "font" "cyrillic"))))
    (-> "paragraph"
	(-> "style"
	    ("default" (init-default "paragraph mode"))
	    ---
	    ("justified" (init-env "paragraph mode" "justify"))
	    ("left ragged" (init-env "paragraph mode" "left"))
	    ("centered" (init-env "paragraph mode" "center"))
	    ("right ragged" (init-env "paragraph mode" "right")))
	(-> "hyphenation"
	    ("default" (init-default "paragraph hyphenation"))
	    ---
	    ("normal" (init-env "paragraph hyphenation" "normal"))
	    ("professional" (init-env "paragraph hyphenation" "professional")))
	(-> "margins"
	    ("default" (init-default "first indentation"))
	    ---
	    ("first indentation"
	      (interactive '("First indentation:") 'init-first-indent))
	    ("last indentation"
	      (interactive '("Last indentation:") 'init-last-indent)))
	(-> "spacing"
	    ("default" (begin
	      (init-default "interline space")
	      (init-default "line stretch")
	      (init-default "interparagraph space")))
	    ---
	    ("interline separation"
	     (interactive '("Separation between lines:") 'init-interline))
	    ("interline space"
	     (interactive '("Space between lines:") 'init-interline-spc))
	    ("interparagraph space"
	     (interactive '("Space between paragraphs:") 'init-interpar-spc))))
    (-> "page"
	(-> "type"
	    ("default" (begin
	      (init-default "page medium")
	      (set-page-parameters)))
	    ---
	    ("paper" (set-page-medium "paper"))
	    ("papyrus" (set-page-medium "papyrus"))
	    ("automatic" (set-page-medium "automatic")))
	(-> "size"
	    ("default" (begin
	      (init-default "page type")
	      (set-page-parameters)))
	    ---
	    ("a3" (set-page-type "a3"))
	    ("a4" (set-page-type "a4"))
	    ("a5" (set-page-type "a5"))
	    ("b4" (set-page-type "b4"))
	    ("b5" (set-page-type "b5"))
	    ("b6" (set-page-type "b6"))
	    ("letter" (set-page-type "letter"))
	    ("legal" (set-page-type "legal"))
	    ("executive" (set-page-type "executive"))
	    ("lecture note" (set-page-type "lecture note"))
	    ---
	    ("other"
	      (interactive '("Page width:" "Page height:" "Text width:")
			   'init-page-size)))
	(-> "orientation"
	    ("default" (begin
	      (init-default "page orientation")
	      (set-page-parameters)))
	    ---
	    ("portrait" (set-page-orientation "portrait"))
	    ("landscape" (set-page-orientation "landscape")))
	(-> "layout"
	    ("default" (begin
	      (init-default "odd page margin")
	      (init-default "even page margin")
	      (init-default "page right margin")
	      (init-default "page top margin")
	      (init-default "page bottom margin")
	      (init-default "paragraph width")))
	    ---
	    ("set margins"
	     (interactive
	       '("Left margin:" "Right margin:"
		 "Top margin:" "Bottom margin:") 'init-page-margins))
	    ("set text width"
	      (interactive '("Text width:") 'init-text-width)))
	(-> "screen layout"
	    ("default" (begin
	      (init-default "reduction page left margin")
	      (init-default "reduction page right margin")
	      (init-default "reduction page top margin")
	      (init-default "reduction page bottom margin")))
	    ---
	    ("as on paper"
	     (begin (init-screen-reduction "0mm" "0mm" "0mm" "0mm")
		    (init-env "show header and footer" "true")))
	    ("reduce margins" (interactive
	      '("Reduce left margin by:"
		"Reduce right margin by:"
		"Reduce top margin by:"
		"Reduce bottom margin by:") 'init-screen-reduction)))
	(-> "breaking"
	    (-> "algorithm"
		("default" (init-default "page breaking"))
		---
		("sloppy" (init-env "page breaking" "sloppy"))
		("medium" (init-env "page breaking" "medium"))
		("professional" (init-env "page breaking" "optimize")))
	    (-> "limits"
		("allowed reduction"
		 (interactive '("How much shorter may pages become?")
			      'init-page-shrink))
		("allowed extension"
		 (interactive '("How much longer may pages become?")
			      'init-page-extend)))
	    (-> "flexibility"
		("default" (init-default "page flexibility"))
		---
		("0" (init-env "page flexibility" "0.0"))
		("1/4" (init-env "page flexibility" "0.25"))
		("1/2" (init-env "page flexibility" "0.5"))
		("3/4" (init-env "page flexibility" "0.75"))
		("1" (init-env "page flexibility" "1"))
		---
		("other"
		 (interactive '("Flexibility factor for vertical spacing: ")
			      'init-page-flexibility)))))
    ---
    (-> "update"
	("all" (begin (generate-all-aux) (update-buffer)))
	---
	("buffer" (update-buffer))
	("bibliography" (update-buffer))
;;	("bibliography" (generate-aux "bibliography"))
	("table of contents" (generate-aux "table-of-contents"))
	("index" (generate-aux "index"))
	("glossary" (generate-aux "glossary")))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Project menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define project-menu
  '((link project-buffer-menu)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Options menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define options-menu
  '((-> "mode"
	("preamble" (begin (init-env "preamble" "true") (update-buffer)))
	("normal" (begin (init-env "preamble" "false") (update-buffer))))
    (-> "language"
	("British" (set-output-language "british"))
	("Czech" (set-output-language "czech"))
	("Dutch" (set-output-language "dutch"))
	("English" (set-output-language "english"))
	("French" (set-output-language "french"))
	("German" (set-output-language "german"))
	("Hungarian" (set-output-language "hungarian"))
	("Polish" (set-output-language "polish"))
	("Portuguese" (set-output-language "portuguese"))
	("Romanian" (set-output-language "romanian"))
	("Russian" (set-output-language "russian"))
	("Spanish" (set-output-language "spanish"))
	("Swedish" (set-output-language "swedish"))
	("Ukrainian" (set-output-language "ukrainian"))
	---
	("other" (interactive '("Language:") 'set-output-language)))
    (-> "keyboard"
        (-> "russian"
            ("translit"
	     (exec-file "$TEXMACS_PATH/progs/keyboard/russian" "translit.scm"))
            ---
            ("jcuken"
	     (exec-file "$TEXMACS_PATH/progs/keyboard/russian" "jcuken.scm"))
            ("yawerty"
	     (exec-file "$TEXMACS_PATH/progs/keyboard/russian" "yawerty.scm"))
            ---
            ("koi8-r"
	     (exec-file "$TEXMACS_PATH/progs/keyboard/russian" "koi8.scm"))
            ("cp1251"
	     (exec-file "$TEXMACS_PATH/progs/keyboard/russian" "cp1251.scm"))))
    (-> "magnification"
	("default" (init-default "magnification"))
	---
	("0.7" (init-env "magnification" "0.7"))
	("0.8" (init-env "magnification" "0.8"))
	("1" (init-env "magnification" "1"))
	("1.2" (init-env "magnification" "1.2"))
	("1.4" (init-env "magnification" "1.4"))
	("1.7" (init-env "magnification" "1.7"))
	("2" (init-env "magnification" "2"))
	---
	("other" (interactive '("Magnification:") 'init-magn)))
    (-> "shrinking factor"
	("default" (set-shrinking-factor 5))
	---
	("1" (set-shrinking-factor 1))
	("2" (set-shrinking-factor 2))
	("3" (set-shrinking-factor 3))
	("4" (set-shrinking-factor 4))
	("5" (set-shrinking-factor 5))
	("7" (set-shrinking-factor 7))
	("10" (set-shrinking-factor 10))
	---
	("other" (interactive '("Shrinking factor:") 'other-shrinking-factor)))
    (-> "view"
	(-> "header and footer"
	    ("default" (init-default "show header and footer"))
	    ---
	    ("on" (init-env "show header and footer" "true"))
	    ("off" (init-env "show header and footer" "false")))
	(-> "main icon bar"
	    ("on" (menu-icons-on 0 #t))
	    ("off" (menu-icons-on 0 #f)))
	(-> "context dependent icons"
	    ("on" (menu-icons-on 1 #t))
	    ("off" (menu-icons-on 1 #f)))
	(-> "user provided icons"
	    ("on" (menu-icons-on 2 #t))
	    ("off" (menu-icons-on 2 #f))))
    (-> "security"
	("accept no scripts" (set-script-status 0))
	("prompt on scripts" (set-script-status 1))
	("accept all scripts" (set-script-status 2)))
    (-> "miscellaneous"
	("execute system command"
	  (interactive '("Command:") 'system))
	("evaluate scheme expression" "E-*"
          (interactive '("Command:") 'TeXmacs-eval)))
    (-> "update"
	("image links" (postscript-gc))
	("inclusions" (inclusions-gc)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The Help menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define help-menu
  '(("welcome" "F1" (load-help-buffer "help/welcome"))
    ---
    ("introduction" (load-help-buffer "help/introduction"))
    ("keyboard" (load-help-buffer "help/keyboard"))
    ("tables" (load-help-buffer "help/tables"))
    ("advanced" (load-help-buffer "help/advanced"))
    ("latex" (load-help-buffer "help/compatibility"))
    ---
    ("styles" (load-help-buffer "help/styles"))
    ("scheme" (load-help-buffer "help/scheme"))
    ("interface" (load-help-buffer "help/interface"))
    ---
    (-> "about"
	("about" (load-help-buffer "help/about"))
	("GNU#license" (load-verbatim-buffer "$TEXMACS_PATH/LICENSE"))
	---
	("first start" (load-help-buffer "startup/readme"))
	(if (file-exists? "$TEXMACS_HOME_PATH"
			  "doc/english/startup/upgrade-last.tex")
	    ("what is new" (load-help-buffer "startup/upgrade-last")))
	("major changes" (load-help-buffer "startup/upgrade-hist")))
    (-> "language"
	("russian" (load-help-buffer "help/russian")))
    (-> "implementation"
	("architecture" (load-help-buffer "source/general"))
	---
	("basic types" (load-help-buffer "source/basic"))
	("data format" (load-help-buffer "source/data"))
	("data conversion" (load-help-buffer "source/convert"))
	("graphical interface" (load-help-buffer "source/window"))
	("fonts" (load-help-buffer "source/fonts"))
	("mathematics" (load-help-buffer "source/math"))
	("typesetted boxes" (load-help-buffer "source/boxes"))
	---
	("known bugs" (load-help-buffer "source/bugs")))
    (-> "projects"
	("past changes" (load-help-buffer "projects/changes"))
	("future changes" (load-help-buffer "projects/tochange"))
	("other projects" (load-help-buffer "projects/projects")))
    (-> "help me"
	("please" (load-help-buffer "projects/helpme")))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The TeXmacs main menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define texmacs-menu
  '((=> "Buffer" (link buffer-menu))
    (=> "File" (link file-menu))
    (=> "Edit" (link edit-menu))
    (=> "Insert" (link insert-menu))
    (=> "Text" (link text-menu))
    (=> "Paragraph" (link paragraph-menu))
    (if (inside? "table") (=> "Table" (link table-menu)))
    (=> "Document" (link document-menu))
    (if (project-attached?) (=> "Project" (link project-menu)))
    (=> "Options" (link options-menu))
    (=> "Help" (link help-menu))))

(define texmacs-popup-menu
  '(ver-menu
    (-> "Buffer" (link buffer-menu))
    (-> "File" (link file-menu))
    ---
    (-> "Edit" (link edit-menu))
    (-> "Insert" (link insert-menu))
    (-> "Text" (link text-menu))
    (if (inside? "table") (-> "Table" (link table-menu)))
    (-> "Paragraph" (link paragraph-menu))
    (-> "Document" (link document-menu))
    (if (project-attached?) (=> "Project" (link project-menu)))
    ---
    (-> "Help" (link help-menu))))
