
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : keymaps.scm
;; DESCRIPTION : setup key combinations for frequently used commands
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set-keymap (always?)
  ("E-e" "" "Insert executable markup")
  ("E-i" "" "Insert inactive markup")
  ("E-s" "" "Insert structural markup")
  ("E-1" "" "Operation on primary selection")
  ("E-2" "" "Operation on secondary selection")
  ("E-3" "" "Operation on ternary selection")
  ("E-0" "" "Operation on named selection")
  ("E-t" "" "Table command")
  ("E-t N" "" "New table (t: tabular, b: block)")
  ("E-t H" "" "Horizontal table alignment (l: left, c: center, r: right)")
  ("E-t V" "" "Vertical table alignment: (b: bottom, c: center, t: top)")
  ("E-t B" "" "Modify table border (options: =, l, r, b, t)")
  ("E-t P" "" "Modify table padding (options: =, l, r, b, t)")
  ("E-t m" "" "Set cell mode (c: cell, h: row, v: column, t: table)")
  ("E-t h" "" "Horizontal cell alignment (l: left, c: center, r: right)")
  ("E-t v" "" "Vertical cell alignment: (b: bottom, c: center, t: top)")
  ("E-t b" "" "Modify cell border (options: =, l, r, b, t)")
  ("E-t p" "" "Modify cell padding (options: =, l, r, b, t)")

  ("S-space" (insert-string " "))
  ("return" (make-return))
  ("S-return" (insert-return))
  ("backspace"
   (if (selection-active-normal?) (cut "primary") (remove-backwards)))
  ("delete"
   (if (selection-active-normal?) (cut "primary") (remove-forwards)))
  ("S-backspace"
   (if (selection-active-normal?) (cut "primary") (remove-backwards)))
  ("S-delete"
   (if (selection-active-normal?) (cut "primary") (remove-forwards)))
  ("C-backspace" (remove-structure-backwards))
  ("C-delete" (remove-structure-forwards))
  ("E-backspace" (remove-structure-upwards))
  ("E-delete" (remove-structure-upwards))
  ("A-space" (make-space "0.2spc"))
  ("A-backspace" (make-space "-0.2spc"))
  ("tab" (if (or (is-deactivated?) (in-preamble-mode?) (inside? "tuple"))
             (insert-argument) (make-htab "5mm")))

  ("left" (cursor-left))
  ("right" (cursor-right))
  ("up" (cursor-up))
  ("down" (cursor-down))
  ("home" (cursor-start-line))
  ("end" (cursor-end-line))
  ("pageup" (cursor-page-up))
  ("pagedown" (cursor-page-down))
  ("S-left" (cursor-select cursor-left))
  ("S-right" (cursor-select cursor-right))
  ("S-up" (cursor-select cursor-up))
  ("S-down" (cursor-select cursor-down))
  ("S-home" (cursor-select cursor-start-line))
  ("S-end" (cursor-select cursor-end-line))
  ("S-pageup" (cursor-select cursor-page-up))
  ("S-pagedown" (cursor-select cursor-page-down))
  ("C-home" (selection-set-start) (select-from-keyboard #t))
  ("C-end" (selection-set-end) (select-from-keyboard #f))

  ("F1" (load-help-buffer "help/welcome"))
  ("F2" (choose-file "Load file" "" 'load-buffer))
  ("S-F2" (choose-file "Load file" "" 'load-in-new-window))
  ("C-F2" (revert-buffer))
  ("E-F2" (new-buffer))
  ("E-S-F2" (open-window))
  ("E-C-F2" (clone-window))
  ("F3" (save-buffer))
  ("S-F3" (choose-file "Save TeXmacs file" "TeXmacs" 'save-buffer))
  ("F4" (print))
  ("S-F4" (interactive '("File name:") 'print-to-file))
  ("C-F4" (print-to-file "$TEXMACS_HOME_PATH/system/preview.ps")
          (shell "ghostview $TEXMACS_HOME_PATH/system/preview.ps &"))
  ("E-F4" (interactive '("First page:" "Last page:") 'print-pages))
  ("E-S-F4" (interactive
	     '("File name:" "First page:" "Last page:")
	     'print-pages-to-file))
  ("E-C-F4" (interactive
	     '("Printing command:" "Paper type:" "Printer dpi:")
	     'setup-printer))
  ("F5" (copy "primary"))
  ("S-F5" (paste "primary"))
  ("C-F5" (selection-clear "primary"))
  ("E-F5" (interactive '("Copy to:") 'copy))
  ("E-S-F5" (interactive '("Paste from:") 'paste))
  ("E-C-F5" (interactive '("Clear selection:") 'selection-clear))
  ("F6" (copy "secondary"))
  ("S-F6" (paste "secondary"))
  ("C-F6" (selection-clear "secondary"))
  ("E-F6" (copy "ternary"))
  ("E-S-F6" (paste "ternary"))
  ("E-C-F6" (selection-clear "ternary"))

  ("cut" (cut "primary"))
  ("paste" (paste "primary"))
  ("copy" (copy "primary"))
  ("undo" (undo))
  ("redo" (redo))
  ("cancel" (selection-clear "primary"))
  ("find" (search-start #t))

  ("\\" (if (inside? "hybrid") (insert-string "\\") (make-inactive-hybrid)))
  ("E-:" (make-format "line break"))
  ("E-;" (make-format "new line"))
  ("E-return" (make-format "next line"))
  ("E-/" (make-format "no line break"))
  ("E-[" (undo))
  ("E-]" (redo))
  ("E-<" (go-start))
  ("E->" (go-end))
  ("E-$" (spell-start))
  ("E-*" (interactive '("Command:") 'TeXmacs-eval))
  ("E-=" (make-inactive-assign))
  ("E-w" (make-inactive-with))
  ("E-m" (make-inactive-macro))
  ("E-f" (make-inactive-function))
  ("E-!" (make-inactive-label))
  ("E-?" (make-inactive-reference))
  ("E-c" (copy "primary"))
  ("E-p" (paste "primary"))
  ("E-x" (cut "primary"))
  ("E-r" (selection-clear "primary"))
  ("E-v" (move))
  ("E-g" (make-group))

  ("E-t N t" (make-expand-arg "tabular"))
  ("E-t N T" (make-expand-arg "tabular*"))
  ("E-t N b" (make-expand-arg "block"))
  ("E-t N B" (make-expand-arg "block*"))
  ("E-t S" (make-sub-table))
  ("E-t H l" (table-set-halign "l"))
  ("E-t H c" (table-set-halign "c"))
  ("E-t H r" (table-set-halign "r"))
  ("E-t H L" (table-set-halign "L"))
  ("E-t H C" (table-set-halign "C"))
  ("E-t H R" (table-set-halign "R"))
  ("E-t H O" (table-set-halign "O"))
  ("E-t H w" (table-set-width-ia))
  ("E-t H p" (table-use-paragraph-width))
  ("E-t V b" (table-set-valign "b"))
  ("E-t V c" (table-set-valign "c"))
  ("E-t V t" (table-set-valign "t"))
  ("E-t V f" (table-set-valign "f"))
  ("E-t V B" (table-set-valign "B"))
  ("E-t V C" (table-set-valign "C"))
  ("E-t V T" (table-set-valign "T"))
  ("E-t V O" (table-set-valign "O"))
  ("E-t V h" (table-set-height-ia))
  ("E-t P =" (table-set-padding-ia))
  ("E-t P l" (table-set-lpadding-ia))
  ("E-t P r" (table-set-rpadding-ia))
  ("E-t P b" (table-set-bpadding-ia))
  ("E-t P t" (table-set-tpadding-ia))
  ("E-t B =" (table-set-border-ia))
  ("E-t B l" (table-set-lborder-ia))
  ("E-t B r" (table-set-rborder-ia))
  ("E-t B b" (table-set-bborder-ia))
  ("E-t B t" (table-set-tborder-ia))
  ("E-t O r" (table-set-row-origin-ia))
  ("E-t O c" (table-set-column-origin-ia))
  ("E-t L r" (table-set-min-rows-ia))
  ("E-t L c" (table-set-min-columns-ia))
  ("E-t L R" (table-set-max-rows-ia))
  ("E-t L C" (table-set-max-columns-ia))
  ("E-t home" (table-format-center))
  ("E-t *" (table-disactivate))
  ("E-t t" (table-test))
  ("E-left" (if (inside-tree?) (branch-insert #f) (table-insert-column #f)))
  ("E-right" (if (inside-tree?) (branch-insert #t) (table-insert-column #t)))
  ("E-up" (table-insert-row #f))
  ("E-down" (table-insert-row #t))

  ("E-t m c" (set-cell-mode "cell"))
  ("E-t m h" (set-cell-mode "row"))
  ("E-t m v" (set-cell-mode "column"))
  ("E-t m t" (set-cell-mode "table"))
  ("E-t h l" (cell-set-halign "l"))
  ("E-t h L" (cell-set-halign "L"))
  ("E-t h c" (cell-set-halign "c"))
  ("E-t h C" (cell-set-halign "C"))
  ("E-t h r" (cell-set-halign "r"))
  ("E-t h R" (cell-set-halign "R"))
  ("E-t h o" (cell-set-halign "o"))
  ("E-t h w" (cell-set-width-ia))
  ("E-t h s" (cell-set-hsep-ia))
  ("E-t h m" (cell-set-hmode "min"))
  ("E-t h e" (cell-set-hmode "exact"))
  ("E-t h M" (cell-set-hmode "max"))
  ("E-t h delete" (table-delete-row #f))
  ("E-t h backspace" (table-delete-row #t))
  ("E-t v b" (cell-set-valign "b"))
  ("E-t v B" (cell-set-valign "B"))
  ("E-t v c" (cell-set-valign "c"))
  ("E-t v C" (cell-set-valign "C"))
  ("E-t v t" (cell-set-valign "t"))
  ("E-t v T" (cell-set-valign "T"))
  ("E-t v o" (cell-set-valign "o"))
  ("E-t v h" (cell-set-height-ia))
  ("E-t v s" (cell-set-vsep-ia))
  ("E-t v m" (cell-set-vmode "min"))
  ("E-t v e" (cell-set-vmode "exact"))
  ("E-t v M" (cell-set-vmode "max"))
  ("E-t v delete" (table-delete-column #f))
  ("E-t v backspace" (table-delete-column #t))
  ("E-t p =" (cell-set-padding-ia))
  ("E-t p l" (cell-set-lpadding-ia))
  ("E-t p r" (cell-set-rpadding-ia))
  ("E-t p b" (cell-set-bpadding-ia))
  ("E-t p t" (cell-set-tpadding-ia))
  ("E-t b =" (cell-set-border-ia))
  ("E-t b l" (cell-set-lborder-ia))
  ("E-t b r" (cell-set-rborder-ia))
  ("E-t b b" (cell-set-bborder-ia))
  ("E-t b t" (cell-set-tborder-ia))
  ("E-t b left" (table-column-decoration #f))
  ("E-t b right" (table-column-decoration #t))
  ("E-t b up" (table-row-decoration #f))
  ("E-t b down" (table-row-decoration #t))
  ("E-t s" (cell-set-span-ia))
  ("A-home" (cell-del-format ""))
  ("A-left" (cell-halign-left))
  ("A-right" (cell-halign-right))
  ("A-down" (cell-valign-down))
  ("A-up" (cell-valign-up))

  ("E-1 c" (copy "primary"))
  ("E-1 p" (paste "primary"))
  ("E-1 x" (cut "primary"))
  ("E-1 r" (selection-clear "primary"))
  ("E-2 c" (copy "secondary"))
  ("E-2 p" (paste "secondary"))
  ("E-2 x" (cut "secondary"))
  ("E-2 r" (selection-clear "secondary"))
  ("E-3 c" (copy "ternary"))
  ("E-3 p" (paste "ternary"))
  ("E-3 x" (cut "ternary"))
  ("E-3 r" (selection-clear "ternary"))
  ("E-0 c" (interactive '("Copy to:") 'copy))
  ("E-0 p" (interactive '("Paste from:") 'paste))
  ("E-0 x" (interactive '("Cut to:") 'cut))
  ("E-0 r" (interactive '("Clear selection:") 'selection-clear))

  ("E-i #" (make-inactive-argument))
  ("E-i $" (make-inactive-symbol))
  ("E-i l" (make-inactive-latex))
  ("E-i e" (make-inactive-expand))
  ("E-i E" (make-inactive-var-expand))
  ("E-i a" (make-inactive-apply))
  ("E-i i" (make-inactive-include))
  ("E-i v" (make-inactive-value))
  ("E-i h" (make-inactive-hold))
  ("E-i r" (make-inactive-release))
  ("E-i q" (make-inactive-quote))
  ("E-i d" (make-inactive-delay))
  ("E-i *" (make-inactive-action))
  ("E-i >" (make-inactive-hyperlink))
  ("E-i w" (make-inactive-write))
  ("E-i s" (make-inactive-surround))
  ("E-i t" (make-inactive-tag))
  ("E-i m" (make-inactive-meaning))
  ("E-i (" (make-tuple))
  ("E-i <" (make-tuple))

  ("E-e x" (make-inactive-eval))
  ("E-e |" (make-inactive-or))
  ("E-e ^" (make-inactive-xor))
  ("E-e &" (make-inactive-and))
  ("E-e !" (make-inactive-not))
  ("E-e +" (make-inactive-plus))
  ("E-e -" (make-inactive-minus))
  ("E-e *" (make-inactive-times))
  ("E-e /" (make-inactive-over))
  ("E-e d" (make-inactive-div))
  ("E-e m" (make-inactive-mod))
  ("E-e ;" (make-inactive-merge))
  ("E-e l" (make-inactive-length))
  ("E-e ," (make-inactive-range))
  ("E-e #" (make-inactive-number))
  ("E-e @" (make-date))
  ("E-e E-@" (make-inactive-date))
  ("E-e t" (make-inactive-translate))
  ("E-e q" (make-inactive-is-tuple))
  ("E-e [" (make-inactive-look-up))
  ("E-e =" (make-inactive-equal))
  ("E-e E-=" (make-inactive-unequal))
  ("E-e <" (make-inactive-less))
  ("E-e E-<" (make-inactive-lesseq))
  ("E-e >" (make-inactive-greater))
  ("E-e E->" (make-inactive-greatereq))
  ("E-e ?" (make-inactive-if))
  ("E-e i" (make-inactive-if))
  ("E-e c" (make-inactive-case))
  ("E-e w" (make-inactive-while))
  ;; ("E-e e" (make-inactive-extern))
  ;; ("E-e a" (make-inactive-authorize))

  ("E-s a" (make-expand-arg "abbr"))
  ("E-s s" (make-expand-arg "strong"))
  ("E-s v" (make-expand-arg "verbatim"))
  ("E-s e" (make-expand-arg "em"))
  ("E-s n" (make-expand-arg "name"))
  ("E-s p" (make-expand-arg "samp"))
  ("E-s o" (make-expand-arg "op"))
  ("E-s 0" (make-section-arg "chapter"))
  ("E-s 1" (make-section-arg "section"))
  ("E-s 2" (make-section-arg "subsection"))
  ("E-s 3" (make-section-arg "subsubsection"))
  ("E-s 4" (make-section-arg "paragraph"))
  ("E-s 5" (make-section-arg "subparagraph"))

  ("E-E-\\" (insert-string "\\"))
  ("E-E-$" (insert-string "$"))
  ("E-E-&" (insert-string "&"))
  ("E-E-#" (insert-string "#"))
  ("E-E-" (insert-string ""))
  ("E-E-%" (insert-string "%")))

(set-keymap (in-text?)
  ("exclamdown" "")
  ("cent" (make-expand "cent"))
  ("sterling" "")
  ("currency" (make-expand "currency"))
  ("yen" (make-expand "yen"))
  ("section" "")
  ("copyright" (make-expand "copyright"))
  ("copyright *" (make-expand "copyleft"))
  ("guillemotleft" "")
  ("registered" (make-expand "registered"))
  ("degree" (make-expand "degreesign"))
  ("twosuperior" (make-expand "twosuperior"))
  ("threesuperior" (make-expand "threesuperior"))
  ("mu" (make-expand "mu"))
  ("paragraph" (make-expand "paragraphsign"))
  ("onesuperior" (make-expand "onesuperior"))
  ("guillemotright" "")
  ("onequarter" (make-expand "onequarter"))
  ("onehalf" (make-expand "onehalf"))
  ("threequarters" (make-expand "threequarters"))
  ("questiondown" "")
  ("euro" (make-expand "euro"))

  ("$" (if (inside? "hybrid") (insert-string "$") (make-with "mode" "math")))
  ("E-I" (make-list "itemize"))
  ("E-E" (make-list "enumerate"))
  ("E-D" (make-list "description"))
  ("E-N" (make-item))
  ("E-S" (make-session "scheme"))

  ("E-C-s" (make-with "font family" "ss"))
  ("E-C-t" (make-with "font family" "tt"))
  ("E-C-b" (make-with "font series" "bold"))
  ("E-C-m" (make-with "font series" "medium"))
  ("E-C-r" (make-with "font shape" "right"))
  ("E-C-i" (make-with "font shape" "italic"))
  ("E-C-l" (make-with "font shape" "slanted"))
  ("E-C-p" (make-with "font shape" "small-caps")))

(set-keymap (in-math?)
  ("`" (make-lprime "`"))
  ("'" (make-rprime "'"))
  ("\"" (make-rprime "'") (make-rprime "'"))
  ("acute" (make-lprime "`"))
  ("grave" (make-rprime "'"))
  ("A-'" (make-rprime "<dag>"))
  ("A-acute" (make-rprime "<dag>"))
  ("notsign" "<neg>")
  ("plusminus" "<pm>")
  ("twosuperior" (insert-object '(rsup "2")))
  ("threesuperior" (insert-object '(rsup "3")))
  ("mu" "<mu>")
  ("onequarter" (insert-object '(frac "1" "4")))
  ("onehalf" (insert-object '(frac "1" "2")))
  ("threequarters" (insert-object '(frac "3" "4")))

  ("$" (go-end-with "mode" "math"))
  ("E-$" (make-with "mode" "text"))
  ("_" (make-script #f #t))
  ("^" (make-script #t #t))
  ("hat" (make-script #t #t))
  ("E-~" (make-wide "~"))
  ("E-^" (make-wide "^"))
  ("E-B" (make-wide "<bar>"))
  ("E-V" (make-wide "<vect>"))
  ("E-C" (make-wide "<check>"))
  ("E-U" (make-wide "<breve>"))
  ("E-'" (make-wide "<acute>"))
  ("E-`" (make-wide "<grave>"))
  ("E-." (make-wide "<dot>"))
  ("E-\"" (make-wide "<ddot>"))
  ("E-tilde" (make-wide "~"))
  ("E-hat" (make-wide "^"))
  ("E-acute" (make-wide "<acute>"))
  ("E-grave" (make-wide "<grave>"))
  ("abovedot" (make-wide "<dot>"))
  ("umlaut" (make-wide "<ddot>"))
  ("E-L _" (make-script #f #f))
  ("E-L ^" (make-script #t #f))
  ("E-L hat" (make-script #t #f))
  ("E-F" (make-fraction))
  ("E-S" (make-sqrt))
  ("E-R" (make-var-sqrt))
  ("E-N" (make-neg))
  ("E-A" (make-tree))

  ("E-t N c" (make-expand-arg "choice"))
  ("E-t N m" (make-expand-arg "matrix"))
  ("E-t N d" (make-expand-arg "det"))

  ("E-C-R" (make-with "math font" "roman"))
  ("E-C-K" (make-with "math font" "concrete"))
  ("E-C-F" (make-with "math font" "Euler"))
  ("E-C-E" (make-with "math font" "ENR"))
  ("E-C-C" (make-with "math font" "cal"))
  ("E-C-B" (make-with "math font" "Bbb*"))
  ("E-C-o" (make-with "math font family" "mr"))
  ("E-C-s" (make-with "math font family" "ms"))
  ("E-C-t" (make-with "math font family" "mt"))
  ("E-C-m" (make-with "math font series" "medium"))
  ("E-C-b" (make-with "math font series" "bold"))
  ("E-C-n" (make-with "math font shape" "normal"))
  ("E-C-r" (make-with "math font shape" "right"))
  ("E-C-l" (make-with "math font shape" "slanted"))
  ("E-C-i" (make-with "math font shape" "italic"))
  ("E-C-u" (make-with "math font shape" "semi-right"))

  ("E-E-S" (make-big-operator "sum"))
  ("E-E-P" (make-big-operator "prod"))
  ("E-E-I" (make-big-operator "int"))
  ("E-E-L I" (make-big-operator "intlim"))
  ("E-E-O" (make-big-operator "oint"))
  ("E-E-L O" (make-big-operator "ointlim"))
  ("E-E-A" (make-big-operator "amalg"))
  ("E-E-N" (make-big-operator "cap"))
  ("E-E-W" (make-big-operator "wedge"))
  ("E-E-U" (make-big-operator "cup"))
  ("E-E-V" (make-big-operator "vee"))
  ("E-E-@ ." (make-big-operator "odot"))
  ("E-E-@ +" (make-big-operator "oplus"))
  ("E-E-@ x" (make-big-operator "otimes"))
  ("E-E-." (make-big-operator "."))

  ("E-E-(" (make-large-left "("))
  ("E-E-)" (make-large-right ")"))
  ("E-E-[" (make-large-left "["))
  ("E-E-]" (make-large-right "]"))
  ("E-E-{" (make-large-left "{"))
  ("E-E-}" (make-large-right "}"))
  ("E-E-<" (make-large-left "langle"))
  ("E-E->" (make-large-right "rangle"))
  ("E-E-/" (make-large-middle "/"))
  ("E-E-b" (make-large-middle "\\"))
  ("E-E-|" (make-large-middle "|"))

  ("E-E-l (" (make-large-left "("))
  ("E-E-l )" (make-large-left ")"))
  ("E-E-l [" (make-large-left "["))
  ("E-E-l ]" (make-large-left "]"))
  ("E-E-l {" (make-large-left "{"))
  ("E-E-l }" (make-large-left "}"))
  ("E-E-l <" (make-large-left "langle"))
  ("E-E-l >" (make-large-left "rangle"))
  ("E-E-l /" (make-large-left "/"))
  ("E-E-l b" (make-large-left "\\"))
  ("E-E-l |" (make-large-left "|"))
  ("E-E-l ." (make-large-left "."))

  ("E-E-m (" (make-large-middle "("))
  ("E-E-m )" (make-large-middle ")"))
  ("E-E-m [" (make-large-middle "["))
  ("E-E-m ]" (make-large-middle "]"))
  ("E-E-m {" (make-large-middle "{"))
  ("E-E-m }" (make-large-middle "}"))
  ("E-E-m <" (make-large-middle "langle"))
  ("E-E-m >" (make-large-middle "rangle"))
  ("E-E-m /" (make-large-middle "/"))
  ("E-E-m b" (make-large-middle "\\"))
  ("E-E-m |" (make-large-middle "|"))
  ("E-E-m ." (make-large-middle "."))

  ("E-E-r (" (make-large-right "("))
  ("E-E-r )" (make-large-right ")"))
  ("E-E-r [" (make-large-right "["))
  ("E-E-r ]" (make-large-right "]"))
  ("E-E-r {" (make-large-right "{"))
  ("E-E-r }" (make-large-right "}"))
  ("E-E-r <" (make-large-right "langle"))
  ("E-E-r >" (make-large-right "rangle"))
  ("E-E-r /" (make-large-right "/"))
  ("E-E-r b" (make-large-right "\\"))
  ("E-E-r |" (make-large-right "|"))
  ("E-E-r ." (make-large-right ".")))

(set-keymap (in-prog?)
  ("<" "<less>")
  (">" "<gtr>")
  ("hat" "^"))

(set-keymap (in-session?)
  ("backspace" (prog-remove-backwards))
  ("delete" (prog-remove-forwards))
  ("S-backspace" (prog-remove-backwards))
  ("S-delete" (prog-remove-forwards)))

(set-keymap (in-cyrillic?)
  ("modeswitch" (make-with "language" "english") (make-with "font" "roman")))
