
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : accents.scm
;; DESCRIPTION : setup shortcuts for accented characters and
;;               other characters for foreign languages
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set-keymap (in-text?)
  ("<" "<less>")
  (">" "<gtr>")
  ;;("- -" "")
  ;;("- - -" "")
  ;;("' '" "")
  ;;("` `" "")
  (", ," "")
  ("sz" "")

  ("A-s" "")
  ("A-S" "")
  ("A-a" "")
  ("A-a A-e" "")
  ("A-o" "")
  ("A-o A-e" "")
  ("A-A" "")
  ("A-A A-E" "")
  ("A-O" "")
  ("A-O A-E" "")
  ("A-!" "")
  ("A-?" "")
  ("A-p" "")
  ("A-P" "")

  ("E-~" "~")
  ("E-~ A" "")
  ("E-~ N" "")
  ("E-~ O" "")
  ("E-~ a" "")
  ("E-~ n" "")
  ("E-~ o" "")
  ("tilde" "~")
  ("tilde A" "")
  ("tilde N" "")
  ("tilde O" "")
  ("tilde a" "")
  ("tilde n" "")
  ("tilde o" "")

  ("E-^" "^")
  ("E-^ A" "")
  ("E-^ E" "")
  ("E-^ I" "")
  ("E-^ O" "")
  ("E-^ U" "")
  ("E-^ a" "")
  ("E-^ e" "")
  ("E-^ i" "")
  ("E-^ o" "")
  ("E-^ u" "")
  ("hat" "^")
  ("hat A" "")
  ("hat E" "")
  ("hat I" "")
  ("hat O" "")
  ("hat U" "")
  ("hat a" "")
  ("hat e" "")
  ("hat i" "")
  ("hat o" "")
  ("hat u" "")

  ("E-\"" "")
  ("E-\" A" "")
  ("E-\" E" "")
  ("E-\" I" "")
  ("E-\" O" "")
  ("E-\" U" "")
  ("E-\" Y" "")
  ("E-\" a" "")
  ("E-\" e" "")
  ("E-\" i" "")
  ("E-\" o" "")
  ("E-\" u" "")
  ("E-\" y" "")
  ("umlaut" "")
  ("umlaut A" "")
  ("umlaut E" "")
  ("umlaut I" "")
  ("umlaut O" "")
  ("umlaut U" "")
  ("umlaut Y" "")
  ("umlaut a" "")
  ("umlaut e" "")
  ("umlaut i" "")
  ("umlaut o" "")
  ("umlaut u" "")
  ("umlaut y" "")

  ("E-'" "'")
  ("E-' A" "")
  ("E-' C" "")
  ("E-' E" "")
  ("E-' I" "")
  ("E-' L" "")
  ("E-' N" "")
  ("E-' O" "")
  ("E-' R" "")
  ("E-' S" "")
  ("E-' U" "")
  ("E-' Y" "")
  ("E-' Z" "")
  ("E-' a" "")
  ("E-' c" "")
  ("E-' e" "")
  ("E-' i" "")
  ("E-' l" "")
  ("E-' n" "")
  ("E-' o" "")
  ("E-' r" "")
  ("E-' s" "")
  ("E-' u" "")
  ("E-' y" "")
  ("E-' z" "")
  ("acute" "'")
  ("acute A" "")
  ("acute C" "")
  ("acute E" "")
  ("acute I" "")
  ("acute L" "")
  ("acute N" "")
  ("acute O" "")
  ("acute R" "")
  ("acute S" "")
  ("acute U" "")
  ("acute Y" "")
  ("acute Z" "")
  ("acute a" "")
  ("acute c" "")
  ("acute e" "")
  ("acute i" "")
  ("acute l" "")
  ("acute n" "")
  ("acute o" "")
  ("acute r" "")
  ("acute s" "")
  ("acute u" "")
  ("acute y" "")
  ("acute z" "")

  ("E-`" "`")
  ("E-` A" "")
  ("E-` E" "")
  ("E-` I" "")
  ("E-` O" "")
  ("E-` U" "")
  ("E-` a" "")
  ("E-` e" "")
  ("E-` i" "")
  ("E-` o" "")
  ("E-` u" "")
  ("grave" "`")
  ("grave A" "")
  ("grave E" "")
  ("grave I" "")
  ("grave O" "")
  ("grave U" "")
  ("grave a" "")
  ("grave e" "")
  ("grave i" "")
  ("grave o" "")
  ("grave u" "")

  ("E-C" "")
  ("E-C C" "")
  ("E-C S" "")
  ("E-C T" "")
  ("E-C c" "")
  ("E-C s" "")
  ("E-C t" "")
  ("cedilla" "")
  ("cedilla C" "")
  ("cedilla S" "")
  ("cedilla T" "")
  ("cedilla c" "")
  ("cedilla s" "")
  ("cedilla t" "")

  ("E-U" "")
  ("E-U A" "")
  ("E-U G" "")
  ("E-U a" "")
  ("E-U g" "")
  ("breve" "")
  ("breve A" "")
  ("breve G" "")
  ("breve a" "")
  ("breve g" "")

  ("E-V" "")
  ("E-V C" "")
  ("E-V D" "")
  ("E-V E" "")
  ("E-V N" "")
  ("E-V R" "")
  ("E-V S" "")
  ("E-V Z" "")
  ("E-V c" "")
  ("E-V d" "")
  ("E-V e" "")
  ("E-V n" "")
  ("E-V r" "")
  ("E-V s" "")
  ("E-V z" "")
  ("check" "")
  ("check C" "")
  ("check D" "")
  ("check E" "")
  ("check N" "")
  ("check R" "")
  ("check S" "")
  ("check T" "")
  ("check U" "")
  ("check Z" "")
  ("check c" "")
  ("check d" "")
  ("check e" "")
  ("check n" "")
  ("check r" "")
  ("check s" "")
  ("check t" "")
  ("check u" "")
  ("check z" "")

  ("E-H" "")
  ("E-H O" "")
  ("E-H U" "")
  ("E-H o" "")
  ("E-H u" "")
  ("doubleacute" "")
  ("doubleacute O" "")
  ("doubleacute U" "")
  ("doubleacute o" "")
  ("doubleacute u" "")

  ("E-O" "")
  ("E-O A" "")
  ("E-O U" "")
  ("E-O a" "")
  ("E-O u" "")
  ("abovering" "")
  ("abovering A" "")
  ("abovering U" "")
  ("abovering a" "")
  ("abovering u" "")

  ("E-." "
")
  ("E-. Z" "")
  ("E-. I" "")
  ("E-. z" "")
  ("abovedot" "
")
  ("abovedot Z" "")
  ("abovedot I" "")
  ("abovedot z" ""))

(set-keymap (in-french?)
  ("<" "<less>")
  (">" "<gtr>")
  ("< *" "")
  ("> *" "")
  ("< <" "")
  ("> >" ""))

(set-keymap (in-german?)
  ("" "")
  ("" ""))

(set-keymap (in-hungarian?)
  ("A-O" "")
  ("A-U" "")
  ("A-o" "")
  ("A-u" "")
  ("<" "<less>")
  (">" "<gtr>")
  ("< <" "")
  ("> >" ""))

(set-keymap (in-spanish?)
  ("" "")
  ("" "")
  ("! *" "")
  ("? *" "")
  ("! `" "")
  ("? `" "")
  ("! grave" "")
  ("? grave" ""))

(set-keymap (in-polish?)
  ("A-a" "")
  ("A-A" "")
  ("A-c" "")
  ("A-C" "")
  ("A-e" "")
  ("A-E" "")
  ("A-l" "")
  ("A-L" "")
  ("A-n" "")
  ("A-N" "")
  ("A-o" "")
  ("A-O" "")
  ("A-s" "")
  ("A-S" "")
  ("A-x" "")
  ("A-X" "")
  ("A-z" "")
  ("A-Z" "")
  ("A-z *" "")
  ("A-Z *" ""))
