
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : init-texmacs.scm
;; DESCRIPTION : This is the standard TeXmacs initialization file
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(debug-set! stack 1000000)

;;(display "Booting TeXmacs\n")
(exec-file "$TEXMACS_PATH/progs/boot" "base.scm")
(exec-file "$TEXMACS_PATH/progs/boot" "general.scm")
(exec-file "$TEXMACS_PATH/progs/boot" "modify.scm")
(exec-file "$TEXMACS_PATH/progs/boot" "table.scm")
(exec-file "$TEXMACS_PATH/progs/boot" "style.scm")

;;(display "Booting menus\n")
(exec-file "$TEXMACS_PATH/progs/menu" "symbol-menu.scm")
(exec-file "$TEXMACS_PATH/progs/menu" "main-menu.scm")
(exec-file "$TEXMACS_PATH/progs/menu" "icon-menu.scm")

;;(display "Booting keyboard\n")
(exec-file "$TEXMACS_PATH/progs/keyboard" "latex.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard" "keymaps.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard" "emacs.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard" "shorthands.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard" "accents.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard/russian" "translit.scm")
(exec-file "$TEXMACS_PATH/progs/keyboard/russian" "cp1251.scm")

;;(display "Booting fonts\n")
(if (use-ec-fonts?)
    (exec-file "$TEXMACS_PATH/progs/fonts" "ec-fonts.scm")
    (exec-file "$TEXMACS_PATH/progs/fonts" "cm-fonts.scm"))
(exec-file "$TEXMACS_PATH/progs/fonts" "adobe-fonts.scm")
(exec-file "$TEXMACS_PATH/progs/fonts" "x-fonts.scm")
(exec-file "$TEXMACS_PATH/progs/fonts" "math-fonts.scm")
(exec-file "$TEXMACS_PATH/progs/fonts" "foreign-fonts.scm")
(exec-file "$TEXMACS_PATH/progs/fonts" "misc-fonts.scm")

;;(display "Booting converters\n")
(exec-file "$TEXMACS_PATH/progs/convert" "tmpre.scm")
(exec-file "$TEXMACS_PATH/progs/convert" "tmtex.scm")
(exec-file "$TEXMACS_PATH/progs/convert" "texout.scm")
(exec-file "$TEXMACS_PATH/progs/convert" "output.scm")

;;(display "Booting computer algebra systems\n")
(exec-file "$TEXMACS_PATH/progs/cas" "convert.scm")
;;(if (file-exists? "$PATH" "tm_bash")
;;    (exec-file "$TEXMACS_PATH/progs/cas" "bash.scm"))
(if (file-exists? "$PATH" "giac")
    (exec-file "$TEXMACS_PATH/progs/cas" "giac.scm"))
(if (file-exists? "$PATH" "gtybalt")
    (exec-file "$TEXMACS_PATH/progs/cas" "gtybalt.scm"))
(if (file-exists? "$PATH" "M2")
    (exec-file "$TEXMACS_PATH/progs/cas" "macaulay2.scm"))
(if (and (file-exists? "$PATH" "maple") (file-exists? "$PATH" "maple_filter"))
    (exec-file "$TEXMACS_PATH/progs/cas" "maple.scm"))
(if (file-exists? "$PATH" "mmx-rewrite")
    (exec-file "$TEXMACS_PATH/progs/cas" "mathemagix.scm"))
(if (file-exists? "$PATH" "maxima")
    (exec-file "$TEXMACS_PATH/progs/cas" "maxima.scm"))
(if (file-exists? "$PATH" "mupad")
    (exec-file "$TEXMACS_PATH/progs/cas" "mupad.scm"))
(if (file-exists? "$PATH" "mycas")
    (exec-file "$TEXMACS_PATH/progs/cas" "mycas.scm"))
(if (file-exists? "$PATH" "gp")
    (exec-file "$TEXMACS_PATH/progs/cas" "pari.scm"))
(if (file-exists? "$PATH" "qcl")
    (exec-file "$TEXMACS_PATH/progs/cas" "qcl.scm"))
(if (file-exists? "$PATH" "reduce")
    (exec-file "$TEXMACS_PATH/progs/cas" "reduce.scm"))
(if (file-exists? "$PATH" "scilab")
    (exec-file "$TEXMACS_PATH/progs/cas" "scilab.scm"))
(set! session-menu (menu-merge session-menu
  '(("scheme" (make-session "scheme" "default"))
    ("shell" (make-session "shell" "default")))))
(if (file-exists? "$PATH" "yacas")
    (exec-file "$TEXMACS_PATH/progs/cas" "yacas.scm"))

;;(connection-declare "bash" "tm_shell")
;;(connection-format "bash" "verbatim" "generic")
(connection-declare "bash" "tm_bash")
(connection-format "bash" "verbatim" "generic")

;;(display "Booting miscellaneous stuff\n")
(connection-declare "ispell" "ispell -a")
(connection-format "ispell" "verbatim" "ispell")
(set-printer-page-type (get-default-paper-size))
