
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : reduce.scm
;; DESCRIPTION : Special support for reduce
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Help menus
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define reduce-help-menu
  '(("abstract" (load-buffer "$reduce/doc/manual/abstract.tex"))
    ("acknowledgement" (load-buffer "$reduce/doc/manual/acknowl.tex"))
    ("introduction" (load-buffer "$reduce/doc/manual/intro.tex"))
    ---
    (-> "programming"
	("structure of programs"
	 (load-buffer "$reduce/doc/manual/progstr.tex"))
	("expressions"
	 (load-buffer "$reduce/doc/manual/exprn.tex"))
	("lists"
	 (load-buffer "$reduce/doc/manual/list.tex"))
	("statements"
	 (load-buffer "$reduce/doc/manual/statemnt.tex"))
	("commands and declarations"
	 (load-buffer "$reduce/doc/manual/command.tex"))
	("procedures"
	 (load-buffer "$reduce/doc/manual/proc.tex"))
	("the remember statement"
	 (load-buffer "$reduce/doc/manual/rememb.tex")))
    (-> "operators"
	("built-in prefix operators"
	 (load-buffer "$reduce/doc/manual/oper.tex"))
	("operators with special properties"
	 (load-buffer "$reduce/doc/manual/oper2.tex"))
	("map operator"
	 (load-buffer "$reduce/doc/manual/map.tex"))
	("substitutions"
	 (load-buffer "$reduce/doc/manual/subst.tex"))
	("solve operator"
	 (load-buffer "$reduce/doc/manual/solve.tex"))
	("root val operator"
	 (load-buffer "$reduce/doc/manual/rest.tex")))
    (-> "data types"
	;;("conversions"
	;;(load-buffer "$reduce/doc/manual/convert.tex"))
	("polynomials and rational functions"
	 (load-buffer "$reduce/doc/manual/polyrat.tex"))
	("matrix calculations"
	 (load-buffer "$reduce/doc/manual/matrix.tex")))
    (-> "using reduce"
	("structure of expressions"
	 (load-buffer "$reduce/doc/manual/structr.tex"))
	("file handling"
	 (load-buffer "$reduce/doc/manual/io.tex"))
	("interactive use"
	 (load-buffer "$reduce/doc/manual/inter.tex"))
	("symbolic mode"
	 (load-buffer "$reduce/doc/manual/symbolic.tex"))
	("rlisp '88"
	 (load-buffer "$reduce/doc/manual/rlisp88.tex"))
	("reduce and rlisp utilities"
	 (load-buffer "$reduce/doc/manual/util.tex")))
    (-> "miscellaneous"
	("algebraic properties"
	 (load-buffer "$reduce/doc/manual/aprop.tex"))
	("continued fractions"
	 (load-buffer "$reduce/doc/manual/cfrac.tex"))
	("heuristic g.c.d."
	 (load-buffer "$reduce/doc/manual/heugcd.tex"))
	("high energy physics"
	 (load-buffer "$reduce/doc/manual/hephys.tex")))
    ---
    ("maintaining reduce"
     (load-buffer "$reduce/doc/manual/maintain.tex"))
    ("reserved identifiers"
     (load-buffer "$reduce/doc/manual/appenda.tex"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (reduce-input-var-row r)
  (if (not (null? r))
      (begin
	(display ", ")
	(cas-input (car r))
	(reduce-input-var-row (cdr r)))))

(define (reduce-input-row r)
  (display "(")
  (cas-input (car r))
  (reduce-input-var-row (cdr r))
  (display ")"))

(define (reduce-input-var-rows t)
  (if (not (null? t))
      (begin
	(display ", ")
	(reduce-input-row (car t))
	(reduce-input-var-rows (cdr t)))))

(define (reduce-input-rows t)
  (display "mat(")
  (reduce-input-row (car t))
  (reduce-input-var-rows (cdr t))
  (display ")"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(connection-declare "reduce" "tm_reduce")
(connection-format "reduce" "verbatim" "generic")
(set! session-menu (menu-merge session-menu
  '(("reduce" (make-session "reduce" "default")))))
(set! texmacs-session-help-icons (menu-merge texmacs-session-help-icons
  '(if (and (equal? (get-env "prog language") "reduce")
	    (file-exists? "$reduce/doc/manual" "abstract.tex"))
       |
       (=> (balloon (icon "tm_help.xpm") "Reduce documentation")
	   (link reduce-help-menu)))))
(define (in-reduce?) (equal? (get-env "prog language") "reduce"))

(set! cas-input-current-cas "reduce")
(cas-input-set! 'rows reduce-input-rows)
(display "")
