
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : style.scm
;; DESCRIPTION : routines for modifying a document with a common style
;; COPYRIGHT   : (C) 2001  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for modifying style parameters
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (set-left-margin s) (make-line-with "left margin" s))
(define (set-right-margin s) (make-line-with "right margin" s))
(define (set-first-indent s) (make-line-with "first indentation" s))
(define (set-last-indent s) (make-line-with "last-indentation" s))
(define (set-interline s) (make-line-with "interline space" s))
(define (set-interline-spc s) (make-line-with "line stretch" s))
(define (set-interpar-spc s) (make-line-with "interparagraph space" s))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Sectional commands
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (inside-section?)
  (or (inside? "chapter")
      (inside? "section")
      (inside? "subsection")
      (inside? "subsubsection")
      (inside? "paragraph")
      (inside? "subparagraph")))

(define (make-section s)
  (if (not (make-return-after))
      (make-expand s)
      (make-return-before)))

(define (make-section-arg s)
  (if (not (make-return-after))
      (make-expand-arg s)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for lists, enumerations and description
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (inside-list?)
  (or (inside? "itemize")
      (inside? "itemize-minus")
      (inside? "itemize-dot")
      (inside? "itemize-arrow")
      (inside? "enumerate")
      (inside? "enumerate-numeric")
      (inside? "enumerate-roman")
      (inside? "enumerate-Roman")
      (inside? "enumerate-alpha")
      (inside? "enumerate-Alpha")))

(define (inside-description?)
  (inside? "description"))

(define (make-list s)
  (make-big-expand s)
  (make-item))

(define (make-item)
  (if (not (make-return-after))
      (cond ((inside-list?) (make-expand "item"))
	    ((inside-description?) (make-expand-arg "item*")))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Routines for inserting miscellaneous content
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-aux env aux)
  (if (not (make-return-after))
      (insert-object (list 'expand env aux '(document "")))))

(define (make-bib style file-name)
  (if (not (make-return-after))
      (insert-object
       (list 'expand "bibliography" "bib" style file-name '(document "")))))
