'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: error.n,v 1.2.18.1 2001/04/03 22:06:43 hobbs Exp $
'\" 
.so man.macros
.TH error n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
error \- Generate an error
.SH SYNOPSIS
\fBerror \fImessage\fR ?\fIinfo\fR? ?\fIcode\fR?
.BE

.SH DESCRIPTION
.PP
Returns a TCL_ERROR code, which causes command interpretation to be
unwound.  \fIMessage\fR is a string that is returned to the application
to indicate what went wrong.
.PP
If the \fIinfo\fR argument is provided and is non-empty,
it is used to initialize the global variable \fBerrorInfo\fR.
\fBerrorInfo\fR is used to accumulate a stack trace of what
was in progress when an error occurred; as nested commands unwind,
the Tcl interpreter adds information to \fBerrorInfo\fR.  If the
\fIinfo\fR argument is present, it is used to initialize
\fBerrorInfo\fR and the first increment of unwind information
will not be added by the Tcl interpreter.  In other
words, the command containing the \fBerror\fR command will not appear
in \fBerrorInfo\fR; in its place will be \fIinfo\fR.
This feature is most useful in conjunction with the \fBcatch\fR command:
if a caught error cannot be handled successfully, \fIinfo\fR can be used
to return a stack trace reflecting the original point of occurrence
of the error:
.CS
\fBcatch {...} errMsg
set savedInfo $errorInfo
\&...
error $errMsg $savedInfo\fR
.CE
.PP
If the \fIcode\fR argument is present, then its value is stored
in the \fBerrorCode\fR global variable.  This variable is intended
to hold a machine-readable description of the error in cases where
such information is available; see the \fBtclvars\fR manual
page for information on the proper format for the variable.
If the \fIcode\fR argument is not
present, then \fBerrorCode\fR is automatically reset to
``NONE'' by the Tcl interpreter as part of processing the
error generated by the command.

.SH "SEE ALSO"
catch(n), tclvars(n)

.SH KEYWORDS
error, errorCode, errorInfo
