from os.path import join
from numpy.distutils.core import setup, Extension
from numpy.distutils.system_info import get_info

short_description = "The symeig module contains a python wrapper for the"+\
                    " LAPACK functions to solve the standard and generalized"+\
                    " eigenvalue problems for symmetric (hermitian) positive"+\
                    " definite matrices."

long_description = """
The symeig module contains a Python wrapper for the LAPACK functions to solve
the standard and generalized eigenvalue problems for symmetric (hermitian)
positive definite matrices. Those specialized algorithms give an important
speed-up with respect to the generic LAPACK eigenvalue problem solver used by
NumPy (linalg.eig and linalg.eigh).

The wrapper function symeig automatically selects the appropriate LAPACK
routine. It is also possible to request only a subset of all eigenvalues, which
consumes less memory and results sometimes in an additional speed-up,
especially for large matrices.

Update for SciPy  0.5.2: some of the routines used in symeig are now included
in SciPy as well. They are available under scipy.lib.lapack.flapack and can be
accessed with the function scipy.lib.lapack.get_lapack_funcs. Some of them are
still missing, though. symeig uses its own wrappers and offers a unified
interface to all the relevant LAPACK routines.  """

classifiers = ["Development Status :: 5 - Production/Stable",
               "Intended Audience :: Developers",
               "Intended Audience :: Science/Research",
               "License :: OSI Approved :: GNU Library or "+\
               "Lesser General Public License (LGPL)",
               "Operating System :: OS Independent",
               "Programming Language :: Python",
               "Topic :: Scientific/Engineering :: Information Analysis",
               "Topic :: Scientific/Engineering :: Mathematics",
               "Topic :: Software Development :: Algorithms"]

lapack_opt = get_info('lapack_opt')
froutines_ext = Extension('froutines',['froutines.pyf'],\
                          **lapack_opt)

setup(name = 'symeig', version = '1.4',
      author = 'Pietro Berkes and Tiziano Zito',
      author_email = 'berkes@gatsby.ucl.ac.uk, tiziano.zito@bccn-berlin.de',
      maintainer = 'Pietro Berkes and Tiziano Zito',
      maintainer_email = 'berkes@gatsby.ucl.ac.uk, tiziano.zito@bccn-berlin.de',
      license = "http://www.gnu.org/licenses/lgpl.html",
      platforms = ["Any"],
      url = 'http://mdp-toolkit.sourceforge.net/symeig.html',
      download_url = 'http://sourceforge.net/project/showfiles.php?group_id=116959',
      description = short_description,
      long_description = long_description,
      packages = ['symeig', 'symeig.test'],
      package_dir = {'symeig': '.'},
      ext_package = 'symeig',
      ext_modules = [froutines_ext])

