#ifndef _HdlStandardStatementConstraint_h
#define _HdlStandardStatementConstraint_h

#include "HdlStatementConstraint.h"

class HdlArgumentConstraint;

class HdlStandardStatementConstraint : public HdlStatementConstraint
{
public:
  HdlStandardStatementConstraint(const string &name,
                         bool is_block)
    : HdlStatementConstraint(name),
      m_isBlock(is_block),
      m_minArgCount(0),
      m_maxArgCount(0)
  {
  }

  virtual ~HdlStandardStatementConstraint()
  {
  }

  virtual void validateStatement(const HdlStatement *stmt) const;

  void addArgument(const Ref<HdlArgumentConstraint> &arg)
  {
    m_arguments.push_back(arg);
  }

  void addChild(const Ref<HdlStatementConstraint> &child)
  {
    m_children.push_back(child);
  }

  void setArgCounts(int min_args,
                    int max_args)
  {
    m_minArgCount = min_args;
    m_maxArgCount = max_args;
  }

private:
  const CRef<HdlStatementConstraint> childConstraint(const string &id) const;
  void throwInvalidStatement(const CRef<HdlToken> &token) const;

private:
  /// Not implemented.
  HdlStandardStatementConstraint(const HdlStandardStatementConstraint &);

  /// Not implemented.
  HdlStandardStatementConstraint& operator=(const HdlStandardStatementConstraint &);

private:
  typedef vector<Ref<HdlArgumentConstraint> > ArgVector;
  typedef vector<Ref<HdlStatementConstraint> > ChildVector;

  bool m_isBlock;
  int m_minArgCount;
  int m_maxArgCount;
  ArgVector m_arguments;
  ChildVector m_children;
};

#endif // _HdlStandardStandardStatementConstraint_h
