/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "playlist.h"
#include "file.h"
#include "other.h"
#include "list.h"

/* When i read a playlist file, i read single lines: */
int
playlist_get_line (FILE * fl, char *s)
{
  char ch;
  int k = 0;

  while ((ch = getc (fl)) != EOF)
    {
      if (ch == '\n')
	{
	  if (k)
	    {
	      s[k] = 0;
	      if (s[0] != '#')
		return k;

	      k = 0;

	    }
	}
      else if (k < SIZE_BUFFER)
	{
	  s[k] = ch;
	  k++;
	}
    }

  return 0;
}

/* Analize the playlist type */
int
playlist_read (char *str)
{

  FILE *fl;
  char s[SIZE_BUFFER];
  int ok, k;

  if (!(fl = fopen (str, "r")))
    return 1;

  if (playlist_get_line (fl, s))
    {
      if (!strncmp ("[playlist]", s, 10))
	ok = 1;
      else
	ok = 2;
    }
  else
    ok = 0;


  switch (ok)
    {
    case 1:			/* playlist type */
      ok = 0;
      if (playlist_get_line (fl, s) && !strncmp (s, "NumberOfEntries=", 16))
	{
	  msg_error ("Playlist file: syntax error.");
	  fclose (fl);
	  return 1;
	}

      ok = atoi (s + 16);
      msg ("Playlist element: %d", ok);
      while (playlist_get_line (fl, s))
	{
	  if (!strncmp (s, "File", 4))
	    {
	      char *p = s;

	      k = atoi (p + 4);
	      if (!k)
		{
		  msg_error ("Playlist file: syntax error.");
		  break;
		}

	      msg ("Insert playlist element: %d", k);

	      while (p && *p != '=')
		p++;

	      p++;

	      if (!p || list_add (p, NULL))
		continue;

	      ok--;
	    }
	}

      break;

    case 2:			/* list */
      if (list_add (s, NULL))
	{
	  fclose (fl);
	  return 1;
	}

      while (playlist_get_line (fl, s))
	if (list_add (s, NULL))
	  {
	    fclose (fl);
	    return 1;
	  }

      break;
    }

  fclose (fl);

  return 0;
}

/* EOF */
