/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../file.h"
#include "../list.h"
#include "../playlist.h"
#include "../other.h"
#include "graphic.h"
#include "queue.h"

list *drag_started = NULL;

void playlist_select_all (GtkWidget *, gpointer);

void
playlist_add (char *fl)
{
  list_add (fl, NULL);
}

void
playlist_select_all (GtkWidget * w, gpointer n)
{
  gtk_tree_selection_select_all (gtk_tree_view_get_selection
				 (GTK_TREE_VIEW (playlist)));
}

void
playlist_select (void)
{
  GtkTreeSelection *selection;
  int k = 0;
  char b[10];
  list *tmp;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;


  while (tmp)
    {

      if (tmp == play->this)
	break;

      k++;
      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  if (!tmp)
    return;

  snprintf (b, 10, "%d", k);

  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));
  gtk_tree_selection_unselect_all (selection);
  gtk_tree_selection_select_path (selection,
				  gtk_tree_path_new_from_string (b));
}

void
playlist_append (list * tmp)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  char *utf8;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));

  utf8 =
    g_convert (tmp->name, strlen (tmp->name), "UTF-8", "ISO-8859-1", NULL,
	       NULL, NULL);
  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, utf8, 1, tmp, -1);
}

void
playlist_append_before (list * tmp, list * before)
{
  GtkTreeModel *model;
  GtkTreeIter iter, new;
  char *utf8;
  void *data;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  if (gtk_tree_model_get_iter_first (model, &iter) != TRUE)
    {
      playlist_append (tmp);
      return;
    }

  do
    {
      gtk_tree_model_get (model, &iter, 1, &data, -1);
      if (data == before)
	{
	  gtk_list_store_insert_before (GTK_LIST_STORE (model), &new, &iter);
	  utf8 =
	    g_convert (tmp->name, strlen (tmp->name), "UTF-8", "ISO-8859-1",
		       NULL, NULL, NULL);
	  gtk_list_store_set (GTK_LIST_STORE (model), &new, 0, utf8, 1, tmp,
			      -1);
	  break;
	}
    }
  while (gtk_tree_model_iter_next (model, &iter));

}

void
playlist_remove (int id)
{
  GtkTreeModel *model;
  GtkTreeIter iter;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  if (gtk_tree_model_iter_nth_child (model, &iter, NULL, id) != TRUE)
    return;
  gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
}

void
playlist_move (list * a, list * b)
{
  GtkTreeModel *model;
  GtkTreeIter init, end;
  int i = 0;
  list *data;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  if (gtk_tree_model_get_iter_first (model, &init) != TRUE)
    return;

  do
    {
      gtk_tree_model_get (model, &init, 1, &data, -1);
      if (data == a)
	{
	  i++;
	  break;
	}
    }
  while (gtk_tree_model_iter_next (model, &init));

  if (!i)
    return;

  if (gtk_tree_model_get_iter_first (model, &end) != TRUE)
    return;

  do
    {
      gtk_tree_model_get (model, &end, 1, &data, -1);
      if (data == b)
	{
	  i = 0;
	  break;
	}
    }
  while (gtk_tree_model_iter_next (model, &end));

  if (i)
    return;

  gtk_list_store_move_after (GTK_LIST_STORE (model), &init, &end);
}

void
playlist_refresh (void)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  list *tmp;
  char *utf8;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
  while (gtk_tree_model_iter_nth_child
	 (GTK_TREE_MODEL (model), &iter, NULL, 0))
    gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

  while (tmp)
    {

      utf8 =
	g_convert (tmp->name, strlen (tmp->name), "UTF-8", "ISO-8859-1", NULL,
		   NULL, NULL);
      gtk_list_store_append (GTK_LIST_STORE (model), &iter);
      gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, utf8, 1, tmp, -1);

      free (utf8);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);
}

void
on_b_remove_clicked (GtkWidget * widget, GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GList *list, *old;
  int k;
  int j = 0;

  if (!selection)
    return;

  if (!(list = gtk_tree_selection_get_selected_rows (selection, &model)))
    return;

  old = list;

  while (list)
    {
      k = gtk_tree_path_get_indices (list->data)[0];
      gtk_tree_path_free (list->data);

      list_remove (k - j);
      j++;

      list = list->next;
    }

  g_list_free (old);
}

gboolean
playlist_key_event (GtkWidget * w, GdkEventKey * event,
		    GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GList *list, *old;
  GtkTreeIter iter;
  void *data;

  if (!selection)
    return FALSE;

  if (event->keyval == GDK_Z || event->keyval == GDK_z)
    {
      on_b_prev_clicked (NULL, NULL);
      return TRUE;
    }

  if (event->keyval == GDK_X || event->keyval == GDK_x)
    {
      on_b_replay_clicked (NULL, NULL);
      return TRUE;
    }

  if (event->keyval == GDK_C || event->keyval == GDK_c)
    {
      on_b_play_clicked (NULL, NULL);
      return TRUE;
    }

  if (event->keyval == GDK_V || event->keyval == GDK_v)
    {
      on_b_stop_clicked (NULL, NULL);
      return TRUE;
    }

  if (event->keyval == GDK_B || event->keyval == GDK_b)
    {
      on_b_next_clicked (NULL, NULL);
      return TRUE;
    }

#ifdef ENABLE_SOMALIST
  if (event->keyval == GDK_P || event->keyval == GDK_p)
    {
      spls_window_show (NULL, NULL);
      return TRUE;
    }
#endif

  if (event->keyval == GDK_S || event->keyval == GDK_s)
    {
      search_window_show (NULL, NULL);
      return TRUE;
    }

  if (event->keyval == GDK_Q || event->keyval == GDK_q)
    {

      if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
	{
	  old = list;

	  while (list)
	    {
	      gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter,
				       list->data);
	      gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data,
				  -1);
	      gtk_tree_path_free (list->data);

	      queue_insert (data);
	      list = list->next;
	    }

	  g_list_free (old);
	}

      return TRUE;
    }

  if (event->keyval == GDK_Return)
    {

      if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
	{

	  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
	  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
	  gtk_tree_path_free (list->data);

	  play->playlist_selected = data;
	  events.skip = 1;

	  if (events.stop)
	    events.stop = 0;
	  if (events.pause)
	    events.pause = 0;

	  pthread_cond_signal (&play->p_pop);

	  g_list_free (list);
	}

      return TRUE;
    }

  if (event->keyval == GDK_Delete)
    {
      int k;
      int j = 0;

      if ((list = gtk_tree_selection_get_selected_rows (selection, &model)))
	{
	  old = list;

	  while (list)
	    {
	      k = gtk_tree_path_get_indices (list->data)[0];
	      gtk_tree_path_free (list->data);

	      list_remove (k - j);
	      j++;

	      list = list->next;
	    }

	  g_list_free (old);
	}

      return TRUE;
    }

  return FALSE;
}

void
on_b_queue_clicked (GtkWidget * widget, GtkTreeSelection * selection)
{
  GtkTreeModel *model;
  GList *list, *old;
  GtkTreeIter iter;
  void *data;

  if (!selection)
    return;

  if (!(list = gtk_tree_selection_get_selected_rows (selection, &model)))
    return;

  old = list;

  while (list)
    {
      gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
      gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
      gtk_tree_path_free (list->data);

      queue_insert (data);
      list = list->next;
    }

  g_list_free (old);
}

GtkWidget *
add_menu (void)
{
  GtkWidget *menu;
  GtkWidget *file;
  GtkWidget *dir;
#ifdef ENABLE_CDAUDIO
  GtkWidget *cdrom;
#endif
  GtkWidget *stream;
  GtkWidget *pl;

  menu = gtk_menu_new ();

  file = gtk_menu_item_new_with_mnemonic (_("Insert files"));
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (menu), file);

  g_signal_connect ((gpointer) file, "activate",
		    G_CALLBACK (add_file_activate), NULL);

  dir = gtk_menu_item_new_with_mnemonic (_("Insert directories"));
  gtk_widget_show (dir);
  gtk_container_add (GTK_CONTAINER (menu), dir);

  g_signal_connect ((gpointer) dir, "activate",
		    G_CALLBACK (add_dir_activate), NULL);

#ifdef ENABLE_CDAUDIO
  cdrom = gtk_menu_item_new_with_mnemonic (_("Insert cdaudio tracks"));
  gtk_widget_show (cdrom);
  gtk_container_add (GTK_CONTAINER (menu), cdrom);

  g_signal_connect ((gpointer) cdrom, "activate",
		    G_CALLBACK (add_cdaudio_activate), NULL);
#endif

  stream = gtk_menu_item_new_with_mnemonic (_("Insert streams"));
  gtk_widget_show (stream);
  gtk_container_add (GTK_CONTAINER (menu), stream);

  g_signal_connect ((gpointer) stream, "activate",
		    G_CALLBACK (add_stream_activate), NULL);

  pl = gtk_menu_item_new_with_mnemonic (_("Insert playlists"));
  gtk_widget_show (pl);
  gtk_container_add (GTK_CONTAINER (menu), pl);

  g_signal_connect ((gpointer) pl, "activate",
		    G_CALLBACK (add_pl_activate), NULL);

  return menu;
}

GtkWidget *
playlist_menu (void)
{
  GtkWidget *menu;
  GtkWidget *file;
  GtkWidget *dir;
#ifdef ENABLE_CDAUDIO
  GtkWidget *cdrom;
#endif
  GtkWidget *stream;
  GtkWidget *pl;
  GtkWidget *separator;
  GtkWidget *remove;
  GtkWidget *search;
  GtkWidget *sep;
  GtkWidget *select_all;
  GtkWidget *cancel;
  GtkWidget *queue;

  GtkTreeSelection *selection;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));

  menu = gtk_menu_new ();

  file = gtk_menu_item_new_with_mnemonic (_("add file"));
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (menu), file);

  g_signal_connect ((gpointer) file, "activate",
		    G_CALLBACK (add_file_activate), NULL);

  dir = gtk_menu_item_new_with_mnemonic (_("add directory"));
  gtk_widget_show (dir);
  gtk_container_add (GTK_CONTAINER (menu), dir);

  g_signal_connect ((gpointer) dir, "activate",
		    G_CALLBACK (add_dir_activate), NULL);

#ifdef ENABLE_CDAUDIO
  cdrom = gtk_menu_item_new_with_mnemonic (_("add cdaudio track"));
  gtk_widget_show (cdrom);
  gtk_container_add (GTK_CONTAINER (menu), cdrom);

  g_signal_connect ((gpointer) cdrom, "activate",
		    G_CALLBACK (add_cdaudio_activate), NULL);
#endif

  stream = gtk_menu_item_new_with_mnemonic (_("add stream"));
  gtk_widget_show (stream);
  gtk_container_add (GTK_CONTAINER (menu), stream);

  g_signal_connect ((gpointer) stream, "activate",
		    G_CALLBACK (add_stream_activate), NULL);

  pl = gtk_menu_item_new_with_mnemonic (_("add playlist"));
  gtk_widget_show (pl);
  gtk_container_add (GTK_CONTAINER (menu), pl);

  g_signal_connect ((gpointer) pl, "activate",
		    G_CALLBACK (add_pl_activate), NULL);

  separator = gtk_menu_item_new ();
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (menu), separator);

  remove = gtk_menu_item_new_with_mnemonic (_("remove item"));
  gtk_widget_show (remove);
  gtk_container_add (GTK_CONTAINER (menu), remove);

  g_signal_connect ((gpointer) remove, "activate",
		    G_CALLBACK (on_b_remove_clicked), selection);

  separator = gtk_menu_item_new ();
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (menu), separator);

  queue = gtk_menu_item_new_with_mnemonic (_("queue item"));
  gtk_widget_show (queue);
  gtk_container_add (GTK_CONTAINER (menu), queue);

  g_signal_connect ((gpointer) queue, "activate",
		    G_CALLBACK (on_b_queue_clicked), selection);

  search = gtk_menu_item_new_with_mnemonic (_("search item"));
  gtk_widget_show (search);
  gtk_container_add (GTK_CONTAINER (menu), search);

  g_signal_connect ((gpointer) search, "activate",
		    G_CALLBACK (search_window_show), NULL);

  sep = gtk_menu_item_new ();
  gtk_widget_show (sep);
  gtk_container_add (GTK_CONTAINER (menu), sep);

  select_all = gtk_menu_item_new_with_mnemonic (_("select all"));
  gtk_widget_show (select_all);
  gtk_container_add (GTK_CONTAINER (menu), select_all);

  g_signal_connect ((gpointer) select_all, "activate",
		    G_CALLBACK (playlist_select_all), NULL);

  cancel = gtk_menu_item_new_with_mnemonic (_("cancel"));
  gtk_widget_show (cancel);
  gtk_container_add (GTK_CONTAINER (menu), cancel);

  return menu;
}

gboolean
playlist_menu_popup (GtkWidget * widget, GdkEventButton * event,
		     gpointer menu)
{
  if (event->type == GDK_2BUTTON_PRESS)
    {
      GtkTreeSelection *selection;
      GtkTreeModel *model;
      GtkTreeIter iter;
      GList *list;
      void *data;

      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));
      list = gtk_tree_selection_get_selected_rows (selection, &model);

      if (list)
	{
	  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
	  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &data, -1);
	  gtk_tree_path_free (list->data);

	  play->playlist_selected = data;
	  events.skip = 1;

	  if (events.stop)
	    events.stop = 0;
	  if (events.pause)
	    events.pause = 0;

	  pthread_cond_signal (&play->p_pop);

	  g_list_free (list);
	}

    }
  else if (event->button == 3)
    {
      gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
		      event->button, event->time);

      return TRUE;
    }

  return FALSE;
}

void
popup_position (GtkMenu * menu, gint * xp, gint * yp, gboolean * p,
		    gpointer data)
{
  GtkRequisition req;
  GdkScreen *screen;
  int x, y, px, py, monitor_n;
  GdkRectangle monitor;
  static int menu_size=0;

  if(!menu_size) {
  gtk_widget_realize(GTK_WIDGET(menu));
  menu_size=GTK_WIDGET(menu)->allocation.width;
  }

  if(menu_size<GTK_WIDGET(data)->allocation.width)
  gtk_widget_set_size_request (GTK_WIDGET (menu),
			       GTK_WIDGET (data)->allocation.width, -1);
  else
  gtk_widget_set_size_request (GTK_WIDGET (menu), menu_size, -1);

  gdk_window_get_origin (GTK_WIDGET (data)->window, &px, &py);
  gtk_widget_size_request (gtk_widget_get_toplevel(GTK_WIDGET(data)), &req);

  y =
    py + GTK_WIDGET (data)->allocation.y +
    GTK_WIDGET (data)->allocation.height + 1;
  x = px + GTK_WIDGET (data)->allocation.x;

  screen = gtk_widget_get_screen (gtk_widget_get_toplevel(GTK_WIDGET(data)));
  monitor_n = gdk_screen_get_monitor_at_point (screen, px, py);
  gdk_screen_get_monitor_geometry (screen, monitor_n, &monitor);

  gtk_widget_size_request (GTK_WIDGET (menu), &req);

  if ((x + req.width) > monitor.x + monitor.width)
    x -= (x + req.width) - (monitor.x + monitor.width);
  else if (x < monitor.x)
    x = monitor.x;

  if ((y + req.height) > monitor.y + monitor.height)
    y -= GTK_WIDGET (data)->allocation.height + req.height + 1;
  else if (y < monitor.y)
    y = monitor.y;

  //GTK BUG: printf("%d %d\n",y, x);
  *xp = x;
  *yp = y;
}

gint
add_menu_popup (GtkWidget * widget, GdkEventButton * event, gpointer menu)
{
  if (event->type == GDK_BUTTON_PRESS)
    {
      gtk_menu_popup (GTK_MENU (menu), NULL, NULL, popup_position, widget,
		      event->button, event->time);

      return TRUE;
    }

  return FALSE;
}

void
playlist_save (char *filename)
{
  struct stat st;
  FILE *fl;
  list *tmp;

  if (!filename)
    return;

  if (!lstat (filename, &st))
    {
      char buf[SIZE_BUFFER];

      snprintf (buf, SIZE_BUFFER, "%s exists! Overwrite?", filename);

      if (dialog_ask (buf) == GTK_RESPONSE_NO)
	return;

    }

  if (!(fl = fopen (filename, "w")))
    {
      dialog_msg ("I can't open your playlist.");
      return;
    }

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;
  while (tmp)
    {
      fprintf (fl, "%s\n", tmp->filename);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  fclose (fl);

  dialog_msg ("Playlist saved.");
}

void
playlist_dump ()
{
  char filename[SIZE_BUFFER];
  FILE *fl;
  list *tmp;
  struct stat st;

  snprintf (filename, SIZE_BUFFER, "%s/.somaplayer", getenv ("HOME"));
  if (lstat (filename, &st))
    {
      unlink (filename);
      mkdir (filename, 0750);
    }

  snprintf (filename, SIZE_BUFFER, "%s/.somaplayer/dump", getenv ("HOME"));

  if (!(fl = fopen (filename, "w")))
    return;

  pthread_mutex_lock (&play->m_list);

  tmp = play->first;

  while (tmp)
    {
      fprintf (fl, "%s\n", tmp->filename);

      tmp = tmp->next;
    }

  pthread_mutex_unlock (&play->m_list);

  fclose (fl);
}

void
playlist_restore (void)
{
  char filename[SIZE_BUFFER];

  if (playing_list ())
    return;

  snprintf (filename, SIZE_BUFFER, "%s/.somaplayer/dump", getenv ("HOME"));

  playlist_read (filename);
}


void
playlist_drop (GtkWidget * w, GdkDragContext * context, int x, int y,
	       GtkSelectionData * data, guint info, guint time,
	       gpointer dummy)
{

  if (data->length >= 0)
    {
      GtkTreePath *path = NULL;
      GtkTreeViewDropPosition position;
      if (gtk_tree_view_get_dest_row_at_pos
	  (GTK_TREE_VIEW (w), x, y, &path, &position))
	{
	  GtkTreeIter iter;
	  GtkTreeModel *model;
	  list *tmp;

	  model = gtk_tree_view_get_model (GTK_TREE_VIEW (playlist));
	  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, path);
	  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &tmp, -1);
	  gtk_tree_path_free (path);

	  if (!tmp)
	    {
	      gtk_drag_finish (context, TRUE, FALSE, time);
	      return;
	    }

	  switch (position)
	    {
	    case GTK_TREE_VIEW_DROP_AFTER:
	    case GTK_TREE_VIEW_DROP_INTO_OR_AFTER:

	      if (drag_started)
		list_move (drag_started, tmp);
	      else
		list_add ((char *) data->data, tmp);


	      break;

	    case GTK_TREE_VIEW_DROP_BEFORE:
	    case GTK_TREE_VIEW_DROP_INTO_OR_BEFORE:

	      if (drag_started)
		list_move (drag_started, tmp->prev);
	      else
		list_add ((char *) data->data, tmp->next);


	      break;

	    default:
	      return;
	    }
	}
      else
	{
	  if (drag_started)
	    list_move (drag_started, play->last);
	  else
	    list_add ((char *) data->data, NULL);
	}

      gtk_drag_finish (context, TRUE, FALSE, time);
      return;
    }
  gtk_drag_finish (context, FALSE, FALSE, time);
}

void
playlist_drag_begin (GtkWidget * w, GdkDragContext * context,
		     GtkSelectionData * selectiondata, guint info, guint time,
		     gpointer dummy)
{
  GList *list;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreeSelection *selection;

  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));
  list = gtk_tree_selection_get_selected_rows (selection, &model);
  if (!list)
    {
      drag_started = NULL;
      return;
    }

  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &drag_started, -1);
  gtk_tree_path_free (list->data);

  g_list_free (list);
}

void
playlist_drag_end (GtkWidget * w, GdkDragContext * context, gpointer dummy)
{
  drag_started = NULL;
}

void
playlist_drag_get (GtkWidget * w, GdkDragContext * context,
		   GtkSelectionData * selection_data, guint info, guint time,
		   gpointer data)
{
  list *tmp;
  GtkTreeModel *model;
  GtkTreeSelection *selection;
  GList *list;
  GtkTreeIter iter;

  pthread_mutex_lock (&play->m_list);

  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (playlist));
  list = gtk_tree_selection_get_selected_rows (selection, &model);

  if (!list)
    {
      pthread_mutex_unlock (&play->m_list);
      return;
    }

  gtk_tree_model_get_iter (GTK_TREE_MODEL (model), &iter, list->data);
  gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 1, &tmp, -1);
  gtk_tree_path_free (list->data);

  if (tmp)
    gtk_selection_data_set (selection_data, selection_data->target, 8,
			    tmp->filename, strlen (tmp->filename));

  g_list_free (list);

  pthread_mutex_unlock (&play->m_list);

}

/* EOF */
