/*
 * -----------------------------------------------------------------------
 * Interface to MMC/SD-Card emulator
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * -----------------------------------------------------------------------
 */

#ifndef _MMCARD_H

typedef struct MMCard MMCard;

/* Return values for MMCard_DoCmd */
#define MMC_ERR_NONE    0
#define MMC_ERR_TIMEOUT 1
#define MMC_ERR_BADCRC  2
#define MMC_ERR_FIFO    3
#define MMC_ERR_FAILED  4
#define MMC_ERR_INVALID 5

#define MMCARD_MAX_RESPLEN 18 /* 16 + CRC == 17, 1 for word alignment because of fifos  */

typedef struct 
MMCResponse {
	unsigned int len;
	uint8_t data[MMCARD_MAX_RESPLEN];
} MMCResponse;

#define CARD_TYPE_MMC (2)
#define CARD_TYPE_SD  (3)
int MMCard_GetType(MMCard *card);
int MMCard_DoCmd(MMCard *card,uint32_t cmd,uint32_t arg,MMCResponse *resp);
void MMCard_Delete(MMCard *card);
MMCard * MMCard_New(const char *name);
/* 
 * ----------------------------------------------------------------
 * MMCard_Read:
 * retval: number of Bytes, -ERRCODE on error  0=eofdata
 * ----------------------------------------------------------------
 */
int MMCard_Read(MMCard *card,uint8_t *buf,int count);

/*
 * ------------------------------------------------------------------
 * MMCard_Write
 * retval: number of Bytes, -errcode on error
 * ------------------------------------------------------------------
 */
int MMCard_Write(MMCard *card,const uint8_t *buf,int count);

#define _MMCARD_H
#endif
